package io.vertx.mutiny.pgclient.pubsub;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A channel to Postgres that tracks the subscription to a given Postgres channel using the <code>LISTEN/UNLISTEN</code> commands.
 * <p/>
 * When paused the channel discards the messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgChannel original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.pgclient.pubsub.PgChannel.class)
public class PgChannel implements io.vertx.mutiny.core.streams.ReadStream<String> {

  public static final io.smallrye.mutiny.vertx.TypeArg<PgChannel> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PgChannel((io.vertx.pgclient.pubsub.PgChannel) obj),
    PgChannel::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgChannel delegate;
  
  public PgChannel(io.vertx.pgclient.pubsub.PgChannel delegate) {
    this.delegate = delegate;
  }

  public PgChannel(Object delegate) {
    this.delegate = (io.vertx.pgclient.pubsub.PgChannel)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PgChannel() {
    this.delegate = null;
  }

  public io.vertx.pgclient.pubsub.PgChannel getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgChannel that = (PgChannel) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Fluent
  public io.vertx.mutiny.core.streams.ReadStream<String> fetch(long arg0) { 
    delegate.fetch(arg0);
    return this;
  }

  public io.vertx.mutiny.core.streams.Pipe<String> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<String> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<String> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<String> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<String> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.pgclient.pubsub.PgChannel __subscribeHandler(Handler<Void> handler) { 
    delegate.subscribeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.pgclient.pubsub.PgChannel subscribeHandler(java.lang.Runnable handler) {
    return __subscribeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.pgclient.pubsub.PgChannel __handler(Handler<String> handler) { 
    delegate.handler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.pgclient.pubsub.PgChannel handler(java.util.function.Consumer<String> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.pgclient.pubsub.PgChannel pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.pgclient.pubsub.PgChannel resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param endHandler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.pgclient.pubsub.PgChannel __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler the handler
   * @return 
   */
  public io.vertx.mutiny.pgclient.pubsub.PgChannel endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  private io.vertx.mutiny.pgclient.pubsub.PgChannel __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.pgclient.pubsub.PgChannel exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private Multi<String> multi;

  @CheckReturnValue
  public synchronized Multi<String> toMulti() {
    if (multi == null) {
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(this.getDelegate());    }
    return multi;
  }

  public java.lang.Iterable<String> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<String> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  PgChannel newInstance(io.vertx.pgclient.pubsub.PgChannel arg) {
    return arg != null ? new PgChannel(arg) : null;
  }

}
