package io.vertx.mutiny.pgclient.pubsub;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A class for managing subscriptions using <code>LISTEN/UNLISTEN</code> to Postgres channels.
 * <p/>
 * The subscriber manages a single connection to Postgres.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgSubscriber original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.pgclient.pubsub.PgSubscriber.class)
public class PgSubscriber {

  public static final io.smallrye.mutiny.vertx.TypeArg<PgSubscriber> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PgSubscriber((io.vertx.pgclient.pubsub.PgSubscriber) obj),
    PgSubscriber::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgSubscriber delegate;
  
  public PgSubscriber(io.vertx.pgclient.pubsub.PgSubscriber delegate) {
    this.delegate = delegate;
  }

  public PgSubscriber(Object delegate) {
    this.delegate = (io.vertx.pgclient.pubsub.PgSubscriber)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PgSubscriber() {
    this.delegate = null;
  }

  public io.vertx.pgclient.pubsub.PgSubscriber getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgSubscriber that = (PgSubscriber) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @param options the connect options
   * @return the subscriber
   */
  public static io.vertx.mutiny.pgclient.pubsub.PgSubscriber subscriber(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    io.vertx.mutiny.pgclient.pubsub.PgSubscriber ret = io.vertx.mutiny.pgclient.pubsub.PgSubscriber.newInstance((io.vertx.pgclient.pubsub.PgSubscriber)io.vertx.pgclient.pubsub.PgSubscriber.subscriber(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param name the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul>
   * @return the channel
   */
  public io.vertx.mutiny.pgclient.pubsub.PgChannel channel(String name) { 
    io.vertx.mutiny.pgclient.pubsub.PgChannel ret = io.vertx.mutiny.pgclient.pubsub.PgChannel.newInstance((io.vertx.pgclient.pubsub.PgChannel)delegate.channel(name));
    return ret;
  }

  /**
   * Connect the subscriber to Postgres.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> connect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#connect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void connectAndAwait() { 
    return (Void) connect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#connect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#connect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#connect} but you don't need to compose it with other operations.
   * @return the instance of PgSubscriber to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.pgclient.pubsub.PgSubscriber connectAndForget() { 
    connect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param policy the policy to set
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.pgclient.pubsub.PgSubscriber reconnectPolicy(Function<Integer, Long> policy) { 
    delegate.reconnectPolicy(policy);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.pgclient.pubsub.PgSubscriber __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.pgclient.pubsub.PgSubscriber closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @return the actual connection to Postgres, it might be <code>null</code>
   */
  public io.vertx.mutiny.pgclient.PgConnection actualConnection() { 
    io.vertx.mutiny.pgclient.PgConnection ret = io.vertx.mutiny.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)delegate.actualConnection());
    return ret;
  }

  /**
   * @return whether the subscriber is closed
   */
  public boolean closed() { 
    boolean ret = delegate.closed();
    return ret;
  }

  /**
   * Close the subscriber, the retry policy will not be invoked.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.pubsub.PgSubscriber#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  PgSubscriber newInstance(io.vertx.pgclient.pubsub.PgSubscriber arg) {
    return arg != null ? new PgSubscriber(arg) : null;
  }

}
