package io.vertx.mutiny.pgclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.PgNotice;
import io.vertx.core.Future;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A connection to Postgres.
 * <P>
 *   The connection object supports all the operations defined in the  interface,
 *   it also provides additional support:
 *   <ul>
 *     <li>Notification</li>
 *     <li>Request Cancellation</li>
 *   </ul>
 * </P>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.pgclient.PgConnection.class)
public class PgConnection extends io.vertx.mutiny.sqlclient.SqlConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<PgConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PgConnection((io.vertx.pgclient.PgConnection) obj),
    PgConnection::getDelegate
  );

  private final io.vertx.pgclient.PgConnection delegate;
  
  public PgConnection(io.vertx.pgclient.PgConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgConnection(Object delegate) {
    super((io.vertx.pgclient.PgConnection)delegate);
    this.delegate = (io.vertx.pgclient.PgConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PgConnection() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.pgclient.PgConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgConnection that = (PgConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.pgclient.PgConnection> connect(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), options, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,PgConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param options the connect options
   * @return the PgConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.pgclient.PgConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    return (io.vertx.mutiny.pgclient.PgConnection) connect(vertx, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,PgConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,PgConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,PgConnectOptions)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param options the connect options
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    connect(vertx, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.pgclient.PgConnection#connect} with options build from the environment variables.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.pgclient.PgConnection> connect(io.vertx.mutiny.core.Vertx vertx) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx 
   * @return the PgConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.pgclient.PgConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx) { 
    return (io.vertx.mutiny.pgclient.PgConnection) connect(vertx).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx)} but you don't need to compose it with other operations.
   * @param vertx 
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx) { 
    connect(vertx).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx 
   * @param connectionUri 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.pgclient.PgConnection> connect(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), connectionUri, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx 
   * @param connectionUri 
   * @return the PgConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.pgclient.PgConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return (io.vertx.mutiny.pgclient.PgConnection) connect(vertx, connectionUri).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.PgConnection#connect(io.vertx.mutiny.core.Vertx,String)} but you don't need to compose it with other operations.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    connect(vertx, connectionUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler the handler
   * @return the transaction instance
   */
  @Fluent
  private io.vertx.mutiny.pgclient.PgConnection __notificationHandler(Handler<io.vertx.pgclient.PgNotification> handler) { 
    delegate.notificationHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.pgclient.PgConnection notificationHandler(java.util.function.Consumer<io.vertx.pgclient.PgNotification> handler) {
    return __notificationHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return 
   */
  @Fluent
  private io.vertx.mutiny.pgclient.PgConnection __noticeHandler(Handler<io.vertx.pgclient.PgNotice> handler) { 
    delegate.noticeHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.pgclient.PgConnection noticeHandler(java.util.function.Consumer<io.vertx.pgclient.PgNotice> handler) {
    return __noticeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * Send a request cancellation message to tell the server to cancel processing request in this connection.
   * <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> cancelRequest() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cancelRequest(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.PgConnection#cancelRequest}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void cancelRequestAndAwait() { 
    return (Void) cancelRequest().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.PgConnection#cancelRequest} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.PgConnection#cancelRequest}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.PgConnection#cancelRequest} but you don't need to compose it with other operations.
   */
  public void cancelRequestAndForget() { 
    cancelRequest().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return The process ID of the target backend
   */
  public int processId() { 
    int ret = delegate.processId();
    return ret;
  }

  /**
   * @return The secret key for the target backend
   */
  public int secretKey() { 
    int ret = delegate.secretKey();
    return ret;
  }

  /**
   * 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.PreparedStatement> prepare(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.prepare(sql, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.pgclient.PgConnection#prepare(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql 
   * @return the PreparedStatement instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.PreparedStatement prepareAndAwait(String sql) { 
    return (io.vertx.mutiny.sqlclient.PreparedStatement) prepare(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.pgclient.PgConnection#prepare(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.pgclient.PgConnection#prepare(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.pgclient.PgConnection#prepare(String)} but you don't need to compose it with other operations.
   * @param sql 
   * @return the instance of PgConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.pgclient.PgConnection prepareAndForget(String sql) { 
    prepare(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler 
   * @return the instance of PgConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.pgclient.PgConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.pgclient.PgConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return the instance of PgConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.pgclient.PgConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.pgclient.PgConnection closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.mutiny.pgclient.PgConnection instance}
   */
  public static io.vertx.mutiny.pgclient.PgConnection cast(io.vertx.mutiny.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.mutiny.pgclient.PgConnection ret = io.vertx.mutiny.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)io.vertx.pgclient.PgConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static  PgConnection newInstance(io.vertx.pgclient.PgConnection arg) {
    return arg != null ? new PgConnection(arg) : null;
  }

}
