package io.vertx.mutiny.rabbitmq;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.rabbitmq.RabbitMQOptions;
import com.rabbitmq.client.BasicProperties;
import io.vertx.core.Future;
import com.rabbitmq.client.AMQP.Queue.DeleteOk;
import java.util.Map;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import com.rabbitmq.client.AMQP.Queue.DeclareOk;
import io.vertx.rabbitmq.RabbitMQConfirmation;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<RabbitMQClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient) obj),
    RabbitMQClient::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQClient delegate;
  
  public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
    this.delegate = delegate;
  }

  public RabbitMQClient(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RabbitMQClient() {
    this.delegate = null;
  }

  public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQClient that = (RabbitMQClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.mutiny.rabbitmq.RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.rabbitmq.RabbitMQClient ret = io.vertx.mutiny.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param config the client config
   * @return the client
   */
  public static io.vertx.mutiny.rabbitmq.RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.rabbitmq.RabbitMQOptions config) { 
    io.vertx.mutiny.rabbitmq.RabbitMQClient ret = io.vertx.mutiny.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param deliveryTag 
   * @param multiple 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicAck(long deliveryTag, boolean multiple) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicAck(deliveryTag, multiple, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicAck(long,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param deliveryTag 
   * @param multiple 
   * @return the Void instance produced by the operation.
   */
  public Void basicAckAndAwait(long deliveryTag, boolean multiple) { 
    return (Void) basicAck(deliveryTag, multiple).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicAck(long,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicAck(long,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicAck(long,boolean)} but you don't need to compose it with other operations.
   * @param deliveryTag 
   * @param multiple 
   */
  public void basicAckAndForget(long deliveryTag, boolean multiple) { 
    basicAck(deliveryTag, multiple).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Reject one or several received messages.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicNack(long,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return the Void instance produced by the operation.
   */
  public Void basicNackAndAwait(long deliveryTag, boolean multiple, boolean requeue) { 
    return (Void) basicNack(deliveryTag, multiple, requeue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicNack(long,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicNack(long,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicNack(long,boolean,boolean)} but you don't need to compose it with other operations.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   */
  public void basicNackAndForget(long deliveryTag, boolean multiple, boolean requeue) { 
    basicNack(deliveryTag, multiple, requeue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param autoAck 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.rabbitmq.RabbitMQMessage> basicGet(String queue, boolean autoAck) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicGet(queue, autoAck, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicGet(String,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param autoAck 
   * @return the RabbitMQMessage instance produced by the operation.
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQMessage basicGetAndAwait(String queue, boolean autoAck) { 
    return (io.vertx.mutiny.rabbitmq.RabbitMQMessage) basicGet(queue, autoAck).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicGet(String,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicGet(String,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicGet(String,boolean)} but you don't need to compose it with other operations.
   * @param queue 
   * @param autoAck 
   */
  public void basicGetAndForget(String queue, boolean autoAck) { 
    basicGet(queue, autoAck).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.rabbitmq.RabbitMQConsumer> basicConsumer(String queue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicConsumer(queue, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @return the RabbitMQConsumer instance produced by the operation.
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer basicConsumerAndAwait(String queue) { 
    return (io.vertx.mutiny.rabbitmq.RabbitMQConsumer) basicConsumer(queue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String)} but you don't need to compose it with other operations.
   * @param queue 
   */
  public void basicConsumerAndForget(String queue) { 
    basicConsumer(queue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Create a consumer with the given <code>options</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue the name of a queue
   * @param options options for queue
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.rabbitmq.RabbitMQConsumer> basicConsumer(String queue, io.vertx.rabbitmq.QueueOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicConsumer(queue, options, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String,QueueOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue the name of a queue
   * @param options options for queue
   * @return the RabbitMQConsumer instance produced by the operation.
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer basicConsumerAndAwait(String queue, io.vertx.rabbitmq.QueueOptions options) { 
    return (io.vertx.mutiny.rabbitmq.RabbitMQConsumer) basicConsumer(queue, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String,QueueOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String,QueueOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicConsumer(String,QueueOptions)} but you don't need to compose it with other operations.
   * @param queue the name of a queue
   * @param options options for queue
   */
  public void basicConsumerAndForget(String queue, io.vertx.rabbitmq.QueueOptions options) { 
    basicConsumer(queue, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicPublish(String exchange, String routingKey, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void basicPublishAndAwait(String exchange, String routingKey, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (Void) basicPublish(exchange, routingKey, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param routingKey 
   * @param body 
   */
  public void basicPublishAndForget(String exchange, String routingKey, io.vertx.mutiny.core.buffer.Buffer body) { 
    basicPublish(exchange, routingKey, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param maxQueueSize maximum size of the queue of confirmations
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>> addConfirmListener(int maxQueueSize) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.addConfirmListener(maxQueueSize, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)event, TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#addConfirmListener(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param maxQueueSize maximum size of the queue of confirmations
   * @return the ReadStream<RabbitMQConfirmation> instance produced by the operation.
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation> addConfirmListenerAndAwait(int maxQueueSize) { 
    return (io.vertx.mutiny.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>) addConfirmListener(maxQueueSize).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#addConfirmListener(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#addConfirmListener(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#addConfirmListener(int)} but you don't need to compose it with other operations.
   * @param maxQueueSize maximum size of the queue of confirmations
   */
  public void addConfirmListenerAndForget(int maxQueueSize) { 
    addConfirmListener(maxQueueSize).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> confirmSelect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.confirmSelect(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#confirmSelect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void confirmSelectAndAwait() { 
    return (Void) confirmSelect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#confirmSelect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#confirmSelect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#confirmSelect} but you don't need to compose it with other operations.
   */
  public void confirmSelectAndForget() { 
    confirmSelect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> waitForConfirms() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.waitForConfirms(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void waitForConfirmsAndAwait() { 
    return (Void) waitForConfirms().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms} but you don't need to compose it with other operations.
   */
  public void waitForConfirmsAndForget() { 
    waitForConfirms().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> waitForConfirms(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.waitForConfirms(timeout, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout 
   * @return the Void instance produced by the operation.
   */
  public Void waitForConfirmsAndAwait(long timeout) { 
    return (Void) waitForConfirms(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#waitForConfirms(long)} but you don't need to compose it with other operations.
   * @param timeout 
   */
  public void waitForConfirmsAndForget(long timeout) { 
    waitForConfirms(timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicQos(int prefetchCount) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicQos(prefetchCount, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @return the Void instance produced by the operation.
   */
  public Void basicQosAndAwait(int prefetchCount) { 
    return (Void) basicQos(prefetchCount).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int)} but you don't need to compose it with other operations.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   */
  public void basicQosAndForget(int prefetchCount) { 
    basicQos(prefetchCount).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicQos(int prefetchCount, boolean global) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicQos(prefetchCount, global, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return the Void instance produced by the operation.
   */
  public Void basicQosAndAwait(int prefetchCount, boolean global) { 
    return (Void) basicQos(prefetchCount, global).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,boolean)} but you don't need to compose it with other operations.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   */
  public void basicQosAndForget(int prefetchCount, boolean global) { 
    basicQos(prefetchCount, global).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicQos(int prefetchSize, int prefetchCount, boolean global) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,int,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return the Void instance produced by the operation.
   */
  public Void basicQosAndAwait(int prefetchSize, int prefetchCount, boolean global) { 
    return (Void) basicQos(prefetchSize, prefetchCount, global).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,int,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,int,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicQos(int,int,boolean)} but you don't need to compose it with other operations.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   */
  public void basicQosAndForget(int prefetchSize, int prefetchCount, boolean global) { 
    basicQos(prefetchSize, prefetchCount, global).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Declare an exchange.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete) { 
    return (Void) exchangeDeclare(exchange, type, durable, autoDelete).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   */
  public void exchangeDeclareAndForget(String exchange, String type, boolean durable, boolean autoDelete) { 
    exchangeDeclare(exchange, type, durable, autoDelete).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) { 
    return (Void) exchangeDeclare(exchange, type, durable, autoDelete, config).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDeclare(String,String,boolean,boolean,JsonObject)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   */
  public void exchangeDeclareAndForget(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) { 
    exchangeDeclare(exchange, type, durable, autoDelete, config).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeDelete(String exchange) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeDelete(exchange, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDelete(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeDeleteAndAwait(String exchange) { 
    return (Void) exchangeDelete(exchange).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDelete(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDelete(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeDelete(String)} but you don't need to compose it with other operations.
   * @param exchange 
   */
  public void exchangeDeleteAndForget(String exchange) { 
    exchangeDelete(exchange).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Bind an exchange to an exchange.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeBind(String destination, String source, String routingKey) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeBind(destination, source, routingKey, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeBindAndAwait(String destination, String source, String routingKey) { 
    return (Void) exchangeBind(destination, source, routingKey).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String)} but you don't need to compose it with other operations.
   * @param destination 
   * @param source 
   * @param routingKey 
   */
  public void exchangeBindAndForget(String destination, String source, String routingKey) { 
    exchangeBind(destination, source, routingKey).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Bind an exchange to an exchange.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeBind(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeBindAndAwait(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return (Void) exchangeBind(destination, source, routingKey, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeBind(String,String,String,Map)} but you don't need to compose it with other operations.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   */
  public void exchangeBindAndForget(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    exchangeBind(destination, source, routingKey, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unbind an exchange from an exchange.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeUnbind(String destination, String source, String routingKey) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeUnbindAndAwait(String destination, String source, String routingKey) { 
    return (Void) exchangeUnbind(destination, source, routingKey).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String)} but you don't need to compose it with other operations.
   * @param destination 
   * @param source 
   * @param routingKey 
   */
  public void exchangeUnbindAndForget(String destination, String source, String routingKey) { 
    exchangeUnbind(destination, source, routingKey).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unbind an exchange from an exchange.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> exchangeUnbind(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return the Void instance produced by the operation.
   */
  public Void exchangeUnbindAndAwait(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return (Void) exchangeUnbind(destination, source, routingKey, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#exchangeUnbind(String,String,String,Map)} but you don't need to compose it with other operations.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   */
  public void exchangeUnbindAndForget(String destination, String source, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    exchangeUnbind(destination, source, routingKey, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> queueDeclareAuto() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueDeclareAuto(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclareAuto}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject queueDeclareAutoAndAwait() { 
    return (JsonObject) queueDeclareAuto().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclareAuto} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclareAuto}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclareAuto} but you don't need to compose it with other operations.
   */
  public void queueDeclareAutoAndForget() { 
    queueDeclareAuto().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Bind a queue to an exchange
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> queueBind(String queue, String exchange, String routingKey) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueBind(queue, exchange, routingKey, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return the Void instance produced by the operation.
   */
  public Void queueBindAndAwait(String queue, String exchange, String routingKey) { 
    return (Void) queueBind(queue, exchange, routingKey).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String)} but you don't need to compose it with other operations.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   */
  public void queueBindAndForget(String queue, String exchange, String routingKey) { 
    queueBind(queue, exchange, routingKey).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Bind a queue to an exchange
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> queueBind(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return the Void instance produced by the operation.
   */
  public Void queueBindAndAwait(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return (Void) queueBind(queue, exchange, routingKey, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueBind(String,String,String,Map)} but you don't need to compose it with other operations.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   */
  public void queueBindAndForget(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    queueBind(queue, exchange, routingKey, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unbind a queue from an exchange
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> queueUnbind(String queue, String exchange, String routingKey) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueUnbind(queue, exchange, routingKey, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return the Void instance produced by the operation.
   */
  public Void queueUnbindAndAwait(String queue, String exchange, String routingKey) { 
    return (Void) queueUnbind(queue, exchange, routingKey).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String)} but you don't need to compose it with other operations.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   */
  public void queueUnbindAndForget(String queue, String exchange, String routingKey) { 
    queueUnbind(queue, exchange, routingKey).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unbind a queue from an exchange
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> queueUnbind(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return the Void instance produced by the operation.
   */
  public Void queueUnbindAndAwait(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    return (Void) queueUnbind(queue, exchange, routingKey, arguments).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueUnbind(String,String,String,Map)} but you don't need to compose it with other operations.
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   */
  public void queueUnbindAndForget(String queue, String exchange, String routingKey, java.util.Map<String, java.lang.Object> arguments) { 
    queueUnbind(queue, exchange, routingKey, arguments).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> messageCount(String queue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.messageCount(queue, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#messageCount(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @return the Long instance produced by the operation.
   */
  public Long messageCountAndAwait(String queue) { 
    return (Long) messageCount(queue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#messageCount(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#messageCount(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#messageCount(String)} but you don't need to compose it with other operations.
   * @param queue 
   */
  public void messageCountAndForget(String queue) { 
    messageCount(queue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Start the rabbitMQ client. Create the connection and the channel.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> start() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.start(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#start}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void startAndAwait() { 
    return (Void) start().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#start} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#start}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#start} but you don't need to compose it with other operations.
   */
  public void startAndForget() { 
    start().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> stop() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.stop(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#stop}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void stopAndAwait() { 
    return (Void) stop().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#stop} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#stop}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#stop} but you don't need to compose it with other operations.
   */
  public void stopAndForget() { 
    stop().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return true when the connection is open, false otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * restart the rabbitMQ connect.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param attempts number of attempts
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> restartConnect(int attempts) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.restartConnect(attempts, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#restartConnect(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param attempts number of attempts
   * @return the Void instance produced by the operation.
   */
  public Void restartConnectAndAwait(int attempts) { 
    return (Void) restartConnect(attempts).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#restartConnect(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#restartConnect(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#restartConnect(int)} but you don't need to compose it with other operations.
   * @param attempts number of attempts
   */
  public void restartConnectAndForget(int attempts) { 
    restartConnect(attempts).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return true when the connection is open, false otherwise
   */
  public boolean isOpenChannel() { 
    boolean ret = delegate.isOpenChannel();
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicPublish(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void basicPublishAndAwait(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (Void) basicPublish(exchange, routingKey, properties, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   */
  public void basicPublishAndForget(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    basicPublish(exchange, routingKey, properties, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> basicPublishWithDeliveryTag(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body, java.util.function.Consumer<Long> deliveryTagHandler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler::accept, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublishWithDeliveryTag(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer,Consumer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @return the Void instance produced by the operation.
   */
  public Void basicPublishWithDeliveryTagAndAwait(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body, java.util.function.Consumer<Long> deliveryTagHandler) { 
    return (Void) basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublishWithDeliveryTag(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer,Consumer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublishWithDeliveryTag(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer,Consumer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicPublishWithDeliveryTag(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer,Consumer)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   */
  public void basicPublishWithDeliveryTagAndForget(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body, java.util.function.Consumer<Long> deliveryTagHandler) { 
    basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Declare a queue
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.rabbitmq.client.AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return the DeclareOk instance produced by the operation.
   */
  public com.rabbitmq.client.AMQP.Queue.DeclareOk queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return (com.rabbitmq.client.AMQP.Queue.DeclareOk) queueDeclare(queue, durable, exclusive, autoDelete).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean)} but you don't need to compose it with other operations.
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   */
  public void queueDeclareAndForget(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    queueDeclare(queue, durable, exclusive, autoDelete).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Declare a queue with config options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.rabbitmq.client.AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return the DeclareOk instance produced by the operation.
   */
  public com.rabbitmq.client.AMQP.Queue.DeclareOk queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) { 
    return (com.rabbitmq.client.AMQP.Queue.DeclareOk) queueDeclare(queue, durable, exclusive, autoDelete, config).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeclare(String,boolean,boolean,boolean,JsonObject)} but you don't need to compose it with other operations.
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   */
  public void queueDeclareAndForget(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) { 
    queueDeclare(queue, durable, exclusive, autoDelete, config).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.rabbitmq.client.AMQP.Queue.DeleteOk> queueDelete(String queue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueDelete(queue, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDelete(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @return the DeleteOk instance produced by the operation.
   */
  public com.rabbitmq.client.AMQP.Queue.DeleteOk queueDeleteAndAwait(String queue) { 
    return (com.rabbitmq.client.AMQP.Queue.DeleteOk) queueDelete(queue).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDelete(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDelete(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDelete(String)} but you don't need to compose it with other operations.
   * @param queue 
   */
  public void queueDeleteAndForget(String queue) { 
    queueDelete(queue).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Delete a queue
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.rabbitmq.client.AMQP.Queue.DeleteOk> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeleteIf(String,boolean,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return the DeleteOk instance produced by the operation.
   */
  public com.rabbitmq.client.AMQP.Queue.DeleteOk queueDeleteIfAndAwait(String queue, boolean ifUnused, boolean ifEmpty) { 
    return (com.rabbitmq.client.AMQP.Queue.DeleteOk) queueDeleteIf(queue, ifUnused, ifEmpty).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeleteIf(String,boolean,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeleteIf(String,boolean,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#queueDeleteIf(String,boolean,boolean)} but you don't need to compose it with other operations.
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   */
  public void queueDeleteIfAndForget(String queue, boolean ifUnused, boolean ifEmpty) { 
    queueDeleteIf(queue, ifUnused, ifEmpty).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
    return arg != null ? new RabbitMQClient(arg) : null;
  }

}
