package io.vertx.mutiny.rabbitmq;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A stream of messages from a rabbitmq queue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQConsumer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.rabbitmq.RabbitMQMessage> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RabbitMQConsumer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer) obj),
    RabbitMQConsumer::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
  
  public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
    this.delegate = delegate;
  }

  public RabbitMQConsumer(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQConsumer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RabbitMQConsumer() {
    this.delegate = null;
  }

  public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.rabbitmq.RabbitMQMessage> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.rabbitmq.RabbitMQMessage>(o1 -> io.vertx.mutiny.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQConsumer that = (RabbitMQConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.rabbitmq.RabbitMQMessage> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.rabbitmq.RabbitMQMessage> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.rabbitmq.RabbitMQMessage> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.rabbitmq.RabbitMQMessage> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.rabbitmq.RabbitMQMessage> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param exceptionHandler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.rabbitmq.RabbitMQConsumer __exceptionHandler(Handler<java.lang.Throwable> exceptionHandler) { 
    delegate.exceptionHandler(exceptionHandler);
    return this;
  }

  /**
   * @param exceptionHandler the exception handler
   * @return 
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer exceptionHandler(java.util.function.Consumer<java.lang.Throwable> exceptionHandler) {
    return __exceptionHandler(exceptionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(exceptionHandler) : null);
  }

  /**
   * @param messageArrived 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.rabbitmq.RabbitMQConsumer __handler(Handler<io.vertx.mutiny.rabbitmq.RabbitMQMessage> messageArrived) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(messageArrived, event -> io.vertx.mutiny.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)event)));
    return this;
  }

  /**
   * @param messageArrived 
   * @return 
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer handler(java.util.function.Consumer<io.vertx.mutiny.rabbitmq.RabbitMQMessage> messageArrived) {
    return __handler(messageArrived != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(messageArrived) : null);
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.rabbitmq.RabbitMQConsumer __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return the name of the queue
   */
  public String queueName() { 
    String ret = delegate.queueName();
    return ret;
  }

  /**
   * @param name the name of the queue
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer setQueueName(String name) { 
    delegate.setQueueName(name);
    return this;
  }

  /**
   * @return a consumer tag
   */
  public String consumerTag() { 
    String ret = delegate.consumerTag();
    return ret;
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption is stopped, you can also be notified via {@link io.vertx.mutiny.rabbitmq.RabbitMQConsumer#endHandler}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> cancel() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(cancelResult -> {
        delegate.cancel(cancelResult);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQConsumer#cancel}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void cancelAndAwait() { 
    return (Void) cancel().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQConsumer#cancel} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQConsumer#cancel}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQConsumer#cancel} but you don't need to compose it with other operations.
   */
  public void cancelAndForget() { 
    cancel().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> if cancel() has been called.
   */
  public boolean isCancelled() { 
    boolean ret = delegate.isCancelled();
    return ret;
  }

  /**
   * @return is the stream paused?
   */
  public boolean isPaused() { 
    boolean ret = delegate.isPaused();
    return ret;
  }

  /**
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.rabbitmq.RabbitMQConsumer fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private Multi<io.vertx.mutiny.rabbitmq.RabbitMQMessage> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.rabbitmq.RabbitMQMessage> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.rabbitmq.RabbitMQMessage, io.vertx.mutiny.rabbitmq.RabbitMQMessage> conv = io.vertx.mutiny.rabbitmq.RabbitMQMessage::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.rabbitmq.RabbitMQMessage> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.rabbitmq.RabbitMQMessage> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
    return arg != null ? new RabbitMQConsumer(arg) : null;
  }

}
