/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.rabbitmq.RabbitMQConsumer;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import java.util.Map;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    RabbitMQClient() {
        this.delegate = null;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> basicAck(long deliveryTag, boolean multiple) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicAck(deliveryTag, multiple, resultHandler));
    }

    public Void basicAckAndAwait(long deliveryTag, boolean multiple) {
        return (Void)this.basicAck(deliveryTag, multiple).await().indefinitely();
    }

    public void basicAckAndForget(long deliveryTag, boolean multiple) {
        this.basicAck(deliveryTag, multiple).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler));
    }

    public Void basicNackAndAwait(long deliveryTag, boolean multiple, boolean requeue) {
        return (Void)this.basicNack(deliveryTag, multiple, requeue).await().indefinitely();
    }

    public void basicNackAndForget(long deliveryTag, boolean multiple, boolean requeue) {
        this.basicNack(deliveryTag, multiple, requeue).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<RabbitMQMessage> basicGet(String queue, boolean autoAck) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicGet(queue, autoAck, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> RabbitMQMessage.newInstance(event)))));
    }

    public RabbitMQMessage basicGetAndAwait(String queue, boolean autoAck) {
        return (RabbitMQMessage)this.basicGet(queue, autoAck).await().indefinitely();
    }

    public void basicGetAndForget(String queue, boolean autoAck) {
        this.basicGet(queue, autoAck).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<RabbitMQConsumer> basicConsumer(String queue) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicConsumer(queue, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> RabbitMQConsumer.newInstance(event)))));
    }

    public RabbitMQConsumer basicConsumerAndAwait(String queue) {
        return (RabbitMQConsumer)this.basicConsumer(queue).await().indefinitely();
    }

    public void basicConsumerAndForget(String queue) {
        this.basicConsumer(queue).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<RabbitMQConsumer> basicConsumer(String queue, QueueOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicConsumer(queue, options, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> RabbitMQConsumer.newInstance(event)))));
    }

    public RabbitMQConsumer basicConsumerAndAwait(String queue, QueueOptions options) {
        return (RabbitMQConsumer)this.basicConsumer(queue, options).await().indefinitely();
    }

    public void basicConsumerAndForget(String queue, QueueOptions options) {
        this.basicConsumer(queue, options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicPublish(String exchange, String routingKey, Buffer body) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler));
    }

    public Void basicPublishAndAwait(String exchange, String routingKey, Buffer body) {
        return (Void)this.basicPublish(exchange, routingKey, body).await().indefinitely();
    }

    public void basicPublishAndForget(String exchange, String routingKey, Buffer body) {
        this.basicPublish(exchange, routingKey, body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<ReadStream<RabbitMQConfirmation>> addConfirmListener(int maxQueueSize) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.addConfirmListener(maxQueueSize, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> ReadStream.newInstance((io.vertx.core.streams.ReadStream)event, (TypeArg)TypeArg.unknown())))));
    }

    public ReadStream<RabbitMQConfirmation> addConfirmListenerAndAwait(int maxQueueSize) {
        return (ReadStream)this.addConfirmListener(maxQueueSize).await().indefinitely();
    }

    public void addConfirmListenerAndForget(int maxQueueSize) {
        this.addConfirmListener(maxQueueSize).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> confirmSelect() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.confirmSelect(resultHandler));
    }

    public Void confirmSelectAndAwait() {
        return (Void)this.confirmSelect().await().indefinitely();
    }

    public void confirmSelectAndForget() {
        this.confirmSelect().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> waitForConfirms() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.waitForConfirms(resultHandler));
    }

    public Void waitForConfirmsAndAwait() {
        return (Void)this.waitForConfirms().await().indefinitely();
    }

    public void waitForConfirmsAndForget() {
        this.waitForConfirms().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> waitForConfirms(long timeout) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.waitForConfirms(timeout, resultHandler));
    }

    public Void waitForConfirmsAndAwait(long timeout) {
        return (Void)this.waitForConfirms(timeout).await().indefinitely();
    }

    public void waitForConfirmsAndForget(long timeout) {
        this.waitForConfirms(timeout).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicQos(int prefetchCount) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicQos(prefetchCount, resultHandler));
    }

    public Void basicQosAndAwait(int prefetchCount) {
        return (Void)this.basicQos(prefetchCount).await().indefinitely();
    }

    public void basicQosAndForget(int prefetchCount) {
        this.basicQos(prefetchCount).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicQos(int prefetchCount, boolean global) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicQos(prefetchCount, global, resultHandler));
    }

    public Void basicQosAndAwait(int prefetchCount, boolean global) {
        return (Void)this.basicQos(prefetchCount, global).await().indefinitely();
    }

    public void basicQosAndForget(int prefetchCount, boolean global) {
        this.basicQos(prefetchCount, global).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicQos(int prefetchSize, int prefetchCount, boolean global) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler));
    }

    public Void basicQosAndAwait(int prefetchSize, int prefetchCount, boolean global) {
        return (Void)this.basicQos(prefetchSize, prefetchCount, global).await().indefinitely();
    }

    public void basicQosAndForget(int prefetchSize, int prefetchCount, boolean global) {
        this.basicQos(prefetchSize, prefetchCount, global).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler));
    }

    public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete) {
        return (Void)this.exchangeDeclare(exchange, type, durable, autoDelete).await().indefinitely();
    }

    public void exchangeDeclareAndForget(String exchange, String type, boolean durable, boolean autoDelete) {
        this.exchangeDeclare(exchange, type, durable, autoDelete).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler));
    }

    public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return (Void)this.exchangeDeclare(exchange, type, durable, autoDelete, config).await().indefinitely();
    }

    public void exchangeDeclareAndForget(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, config).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeDelete(String exchange) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeDelete(exchange, resultHandler));
    }

    public Void exchangeDeleteAndAwait(String exchange) {
        return (Void)this.exchangeDelete(exchange).await().indefinitely();
    }

    public void exchangeDeleteAndForget(String exchange) {
        this.exchangeDelete(exchange).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeBind(String destination, String source, String routingKey) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeBind(destination, source, routingKey, resultHandler));
    }

    public Void exchangeBindAndAwait(String destination, String source, String routingKey) {
        return (Void)this.exchangeBind(destination, source, routingKey).await().indefinitely();
    }

    public void exchangeBindAndForget(String destination, String source, String routingKey) {
        this.exchangeBind(destination, source, routingKey).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler));
    }

    public Void exchangeBindAndAwait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return (Void)this.exchangeBind(destination, source, routingKey, arguments).await().indefinitely();
    }

    public void exchangeBindAndForget(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeBind(destination, source, routingKey, arguments).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeUnbind(String destination, String source, String routingKey) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler));
    }

    public Void exchangeUnbindAndAwait(String destination, String source, String routingKey) {
        return (Void)this.exchangeUnbind(destination, source, routingKey).await().indefinitely();
    }

    public void exchangeUnbindAndForget(String destination, String source, String routingKey) {
        this.exchangeUnbind(destination, source, routingKey).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler));
    }

    public Void exchangeUnbindAndAwait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return (Void)this.exchangeUnbind(destination, source, routingKey, arguments).await().indefinitely();
    }

    public void exchangeUnbindAndForget(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeUnbind(destination, source, routingKey, arguments).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<JsonObject> queueDeclareAuto() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueDeclareAuto(resultHandler));
    }

    public JsonObject queueDeclareAutoAndAwait() {
        return (JsonObject)this.queueDeclareAuto().await().indefinitely();
    }

    public void queueDeclareAutoAndForget() {
        this.queueDeclareAuto().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> queueBind(String queue, String exchange, String routingKey) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueBind(queue, exchange, routingKey, resultHandler));
    }

    public Void queueBindAndAwait(String queue, String exchange, String routingKey) {
        return (Void)this.queueBind(queue, exchange, routingKey).await().indefinitely();
    }

    public void queueBindAndForget(String queue, String exchange, String routingKey) {
        this.queueBind(queue, exchange, routingKey).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler));
    }

    public Void queueBindAndAwait(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return (Void)this.queueBind(queue, exchange, routingKey, arguments).await().indefinitely();
    }

    public void queueBindAndForget(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueBind(queue, exchange, routingKey, arguments).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> queueUnbind(String queue, String exchange, String routingKey) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueUnbind(queue, exchange, routingKey, resultHandler));
    }

    public Void queueUnbindAndAwait(String queue, String exchange, String routingKey) {
        return (Void)this.queueUnbind(queue, exchange, routingKey).await().indefinitely();
    }

    public void queueUnbindAndForget(String queue, String exchange, String routingKey) {
        this.queueUnbind(queue, exchange, routingKey).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler));
    }

    public Void queueUnbindAndAwait(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return (Void)this.queueUnbind(queue, exchange, routingKey, arguments).await().indefinitely();
    }

    public void queueUnbindAndForget(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueUnbind(queue, exchange, routingKey, arguments).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Long> messageCount(String queue) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.messageCount(queue, resultHandler));
    }

    public Long messageCountAndAwait(String queue) {
        return (Long)this.messageCount(queue).await().indefinitely();
    }

    public void messageCountAndForget(String queue) {
        this.messageCount(queue).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> start() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.start(resultHandler));
    }

    public Void startAndAwait() {
        return (Void)this.start().await().indefinitely();
    }

    public void startAndForget() {
        this.start().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> stop() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.stop(resultHandler));
    }

    public Void stopAndAwait() {
        return (Void)this.stop().await().indefinitely();
    }

    public void stopAndForget() {
        this.stop().subscribe().with(UniHelper.NOOP);
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> restartConnect(int attempts) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.restartConnect(attempts, resultHandler));
    }

    public Void restartConnectAndAwait(int attempts) {
        return (Void)this.restartConnect(attempts).await().indefinitely();
    }

    public void restartConnectAndForget(int attempts) {
        this.restartConnect(attempts).subscribe().with(UniHelper.NOOP);
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler));
    }

    public Void basicPublishAndAwait(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return (Void)this.basicPublish(exchange, routingKey, properties, body).await().indefinitely();
    }

    public void basicPublishAndForget(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        this.basicPublish(exchange, routingKey, properties, body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Consumer<Long> deliveryTagHandler) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler::accept, resultHandler));
    }

    public Void basicPublishWithDeliveryTagAndAwait(String exchange, String routingKey, BasicProperties properties, Buffer body, Consumer<Long> deliveryTagHandler) {
        return (Void)this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).await().indefinitely();
    }

    public void basicPublishWithDeliveryTagAndForget(String exchange, String routingKey, BasicProperties properties, Buffer body, Consumer<Long> deliveryTagHandler) {
        this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler));
    }

    public AMQP.Queue.DeclareOk queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return (AMQP.Queue.DeclareOk)this.queueDeclare(queue, durable, exclusive, autoDelete).await().indefinitely();
    }

    public void queueDeclareAndForget(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        this.queueDeclare(queue, durable, exclusive, autoDelete).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler));
    }

    public AMQP.Queue.DeclareOk queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return (AMQP.Queue.DeclareOk)this.queueDeclare(queue, durable, exclusive, autoDelete, config).await().indefinitely();
    }

    public void queueDeclareAndForget(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, config).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AMQP.Queue.DeleteOk> queueDelete(String queue) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueDelete(queue, resultHandler));
    }

    public AMQP.Queue.DeleteOk queueDeleteAndAwait(String queue) {
        return (AMQP.Queue.DeleteOk)this.queueDelete(queue).await().indefinitely();
    }

    public void queueDeleteAndForget(String queue) {
        this.queueDelete(queue).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AMQP.Queue.DeleteOk> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler));
    }

    public AMQP.Queue.DeleteOk queueDeleteIfAndAwait(String queue, boolean ifUnused, boolean ifEmpty) {
        return (AMQP.Queue.DeleteOk)this.queueDeleteIf(queue, ifUnused, ifEmpty).await().indefinitely();
    }

    public void queueDeleteIfAndForget(String queue, boolean ifUnused, boolean ifEmpty) {
        this.queueDeleteIf(queue, ifUnused, ifEmpty).subscribe().with(UniHelper.NOOP);
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

