/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.rabbitmq;

import com.rabbitmq.client.BasicProperties;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQPublisherConfirmation;
import io.vertx.rabbitmq.RabbitMQPublisherOptions;

@MutinyGen(value=io.vertx.rabbitmq.RabbitMQPublisher.class)
public class RabbitMQPublisher {
    public static final TypeArg<RabbitMQPublisher> __TYPE_ARG = new TypeArg(obj -> new RabbitMQPublisher((io.vertx.rabbitmq.RabbitMQPublisher)obj), RabbitMQPublisher::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQPublisher delegate;

    public RabbitMQPublisher(io.vertx.rabbitmq.RabbitMQPublisher delegate) {
        this.delegate = delegate;
    }

    public RabbitMQPublisher(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQPublisher)delegate;
    }

    RabbitMQPublisher() {
        this.delegate = null;
    }

    public io.vertx.rabbitmq.RabbitMQPublisher getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQPublisher that = (RabbitMQPublisher)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static RabbitMQPublisher create(io.vertx.mutiny.core.Vertx vertx, RabbitMQClient client, RabbitMQPublisherOptions options) {
        RabbitMQPublisher ret = RabbitMQPublisher.newInstance(io.vertx.rabbitmq.RabbitMQPublisher.create((Vertx)vertx.getDelegate(), (io.vertx.rabbitmq.RabbitMQClient)client.getDelegate(), (RabbitMQPublisherOptions)options));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> start() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.start(resultHandler));
    }

    public Void startAndAwait() {
        return (Void)this.start().await().indefinitely();
    }

    public void startAndForget() {
        this.start().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> stop() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.stop(resultHandler));
    }

    public Void stopAndAwait() {
        return (Void)this.stop().await().indefinitely();
    }

    public void stopAndForget() {
        this.stop().subscribe().with(UniHelper.NOOP);
    }

    public void restart() {
        this.delegate.restart();
    }

    public ReadStream<RabbitMQPublisherConfirmation> getConfirmationStream() {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.getConfirmationStream(), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public int queueSize() {
        int ret = this.delegate.queueSize();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> publish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.publish(exchange, routingKey, properties, body.getDelegate(), resultHandler));
    }

    public Void publishAndAwait(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return (Void)this.publish(exchange, routingKey, properties, body).await().indefinitely();
    }

    public void publishAndForget(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        this.publish(exchange, routingKey, properties, body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Long> publishConfirm(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.publishConfirm(exchange, routingKey, properties, body.getDelegate(), resultHandler));
    }

    public Long publishConfirmAndAwait(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return (Long)this.publishConfirm(exchange, routingKey, properties, body).await().indefinitely();
    }

    public void publishConfirmAndForget(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        this.publishConfirm(exchange, routingKey, properties, body).subscribe().with(UniHelper.NOOP);
    }

    public static RabbitMQPublisher newInstance(io.vertx.rabbitmq.RabbitMQPublisher arg) {
        return arg != null ? new RabbitMQPublisher(arg) : null;
    }
}

