package io.vertx.mutiny.rabbitmq;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.BasicProperties;

/**
 * Represent a message received message received in a rabbitmq-queue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQMessage original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.rabbitmq.RabbitMQMessage.class)
public class RabbitMQMessage {

  public static final io.smallrye.mutiny.vertx.TypeArg<RabbitMQMessage> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RabbitMQMessage((io.vertx.rabbitmq.RabbitMQMessage) obj),
    RabbitMQMessage::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQMessage delegate;
  
  public RabbitMQMessage(io.vertx.rabbitmq.RabbitMQMessage delegate) {
    this.delegate = delegate;
  }

  public RabbitMQMessage(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQMessage)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RabbitMQMessage() {
    this.delegate = null;
  }

  public io.vertx.rabbitmq.RabbitMQMessage getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQMessage that = (RabbitMQMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the message body
   */
  public io.vertx.mutiny.core.buffer.Buffer body() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.body());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the <i>consumer tag</i> associated with the consumer
   */
  public String consumerTag() { 
    if (cached_1 != null) {
      return cached_1;
    }
    String ret = delegate.consumerTag();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the message count for messages obtained with {@link io.vertx.mutiny.rabbitmq.RabbitMQClient#basicGet}
   */
  public Integer messageCount() { 
    if (cached_2 != null) {
      return cached_2;
    }
    Integer ret = delegate.messageCount();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return packaging data for the message
   */
  public com.rabbitmq.client.Envelope envelope() { 
    if (cached_3 != null) {
      return cached_3;
    }
    com.rabbitmq.client.Envelope ret = delegate.envelope();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return content header data for the message
   */
  public com.rabbitmq.client.BasicProperties properties() { 
    if (cached_4 != null) {
      return cached_4;
    }
    com.rabbitmq.client.BasicProperties ret = delegate.properties();
    cached_4 = ret;
    return ret;
  }

  private io.vertx.mutiny.core.buffer.Buffer cached_0;
  private String cached_1;
  private Integer cached_2;
  private com.rabbitmq.client.Envelope cached_3;
  private com.rabbitmq.client.BasicProperties cached_4;
  public static  RabbitMQMessage newInstance(io.vertx.rabbitmq.RabbitMQMessage arg) {
    return arg != null ? new RabbitMQMessage(arg) : null;
  }

}
