package io.vertx.mutiny.rabbitmq;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import com.rabbitmq.client.BasicProperties;
import io.vertx.core.Future;
import io.vertx.rabbitmq.RabbitMQPublisherConfirmation;
import io.vertx.rabbitmq.RabbitMQPublisherOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A reliable publisher that
 * <ul>
 * <li>Queues up messages internally until it can successfully call basicPublish.
 * <li>Notifies the caller using a robust ID (not delivery tag) when the message is confirmed by rabbit.
 * </ul>
 * 
 * This is a layer above the RabbitMQClient that provides a lot of standard implementation when guaranteed at least once delivery is required.
 * If confirmations are not required do not use this publisher as it does have overhead.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQPublisher original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.rabbitmq.RabbitMQPublisher.class)
public class RabbitMQPublisher {

  public static final io.smallrye.mutiny.vertx.TypeArg<RabbitMQPublisher> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RabbitMQPublisher((io.vertx.rabbitmq.RabbitMQPublisher) obj),
    RabbitMQPublisher::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQPublisher delegate;
  
  public RabbitMQPublisher(io.vertx.rabbitmq.RabbitMQPublisher delegate) {
    this.delegate = delegate;
  }

  public RabbitMQPublisher(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQPublisher)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RabbitMQPublisher() {
    this.delegate = null;
  }

  public io.vertx.rabbitmq.RabbitMQPublisher getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQPublisher that = (RabbitMQPublisher) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance.
   * @param client the RabbitMQClient.
   * @param options options for the publisher.
   * @return the publisher
   */
  public static io.vertx.mutiny.rabbitmq.RabbitMQPublisher create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.rabbitmq.RabbitMQClient client, io.vertx.rabbitmq.RabbitMQPublisherOptions options) { 
    io.vertx.mutiny.rabbitmq.RabbitMQPublisher ret = io.vertx.mutiny.rabbitmq.RabbitMQPublisher.newInstance((io.vertx.rabbitmq.RabbitMQPublisher)io.vertx.rabbitmq.RabbitMQPublisher.create(vertx.getDelegate(), client.getDelegate(), options));
    return ret;
  }

  /**
   * Start the rabbitMQ publisher.
   * The RabbitMQClient should have been started before this.
   *
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> start() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.start(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#start}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void startAndAwait() { 
    return (Void) start().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#start} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#start}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#start} but you don't need to compose it with other operations.
   */
  public void startAndForget() { 
    start().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Stop the rabbitMQ publisher.
   * Calling this is optional, but it gives the opportunity to drain the send queue without losing messages.
   * Future calls to publish will be ignored.
   *
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> stop() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.stop(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#stop}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void stopAndAwait() { 
    return (Void) stop().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#stop} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#stop}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#stop} but you don't need to compose it with other operations.
   */
  public void stopAndForget() { 
    stop().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void restart() { 
    delegate.restart();
  }

  /**
   * @return the ReadStream that contains the message IDs for confirmed messages.
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQPublisherConfirmation> getConfirmationStream() { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQPublisherConfirmation> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.getConfirmationStream(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the number of published, but not sent, messages.
   */
  public int queueSize() { 
    int ret = delegate.queueSize();
    return ret;
  }

  /**
   * Publish a message. 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> publish(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.publish(exchange, routingKey, properties, body.getDelegate(), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#publish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void publishAndAwait(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (Void) publish(exchange, routingKey, properties, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#publish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#publish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.rabbitmq.RabbitMQPublisher#publish(String,String,BasicProperties,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   */
  public void publishAndForget(String exchange, String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.mutiny.core.buffer.Buffer body) { 
    publish(exchange, routingKey, properties, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  RabbitMQPublisher newInstance(io.vertx.rabbitmq.RabbitMQPublisher arg) {
    return arg != null ? new RabbitMQPublisher(arg) : null;
  }

}
