/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis.client;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisConnection;
import io.vertx.mutiny.redis.client.Response;
import java.util.List;

@MutinyGen(value=io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {
    public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg(obj -> new RedisAPI((io.vertx.redis.client.RedisAPI)obj), RedisAPI::getDelegate);
    private final io.vertx.redis.client.RedisAPI delegate;

    public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
        this.delegate = delegate;
    }

    public RedisAPI(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
    }

    RedisAPI() {
        this.delegate = null;
    }

    public io.vertx.redis.client.RedisAPI getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisAPI that = (RedisAPI)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void close() {
        this.delegate.close();
    }

    @CheckReturnValue
    public Uni<Response> acl(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.acl(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response aclAndAwait(List<String> args) {
        return (Response)this.acl(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI aclAndForget(List<String> args) {
        this.acl(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> append(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.append(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response appendAndAwait(String arg0, String arg1) {
        return (Response)this.append(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI appendAndForget(String arg0, String arg1) {
        this.append(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> asking() {
        return AsyncResultUni.toUni(handler -> this.delegate.asking((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response askingAndAwait() {
        return (Response)this.asking().await().indefinitely();
    }

    @Fluent
    public RedisAPI askingAndForget() {
        this.asking().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> auth(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.auth(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response authAndAwait(List<String> args) {
        return (Response)this.auth(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI authAndForget(List<String> args) {
        this.auth(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bgrewriteaof() {
        return AsyncResultUni.toUni(handler -> this.delegate.bgrewriteaof((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bgrewriteaofAndAwait() {
        return (Response)this.bgrewriteaof().await().indefinitely();
    }

    @Fluent
    public RedisAPI bgrewriteaofAndForget() {
        this.bgrewriteaof().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bgsave(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bgsave(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bgsaveAndAwait(List<String> args) {
        return (Response)this.bgsave(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bgsaveAndForget(List<String> args) {
        this.bgsave(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bitcount(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bitcount(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bitcountAndAwait(List<String> args) {
        return (Response)this.bitcount(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bitcountAndForget(List<String> args) {
        this.bitcount(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bitfield(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bitfield(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bitfieldAndAwait(List<String> args) {
        return (Response)this.bitfield(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bitfieldAndForget(List<String> args) {
        this.bitfield(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bitfieldRo(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bitfieldRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bitfieldRoAndAwait(List<String> args) {
        return (Response)this.bitfieldRo(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bitfieldRoAndForget(List<String> args) {
        this.bitfieldRo(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bitop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bitop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bitopAndAwait(List<String> args) {
        return (Response)this.bitop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bitopAndForget(List<String> args) {
        this.bitop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bitpos(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bitpos(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bitposAndAwait(List<String> args) {
        return (Response)this.bitpos(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bitposAndForget(List<String> args) {
        this.bitpos(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> blmove(String arg0, String arg1, String arg2, String arg3, String arg4) {
        return AsyncResultUni.toUni(handler -> this.delegate.blmove(arg0, arg1, arg2, arg3, arg4, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response blmoveAndAwait(String arg0, String arg1, String arg2, String arg3, String arg4) {
        return (Response)this.blmove(arg0, arg1, arg2, arg3, arg4).await().indefinitely();
    }

    @Fluent
    public RedisAPI blmoveAndForget(String arg0, String arg1, String arg2, String arg3, String arg4) {
        this.blmove(arg0, arg1, arg2, arg3, arg4).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> blpop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.blpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response blpopAndAwait(List<String> args) {
        return (Response)this.blpop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI blpopAndForget(List<String> args) {
        this.blpop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> brpop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.brpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response brpopAndAwait(List<String> args) {
        return (Response)this.brpop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI brpopAndForget(List<String> args) {
        this.brpop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> brpoplpush(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.brpoplpush(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response brpoplpushAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.brpoplpush(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI brpoplpushAndForget(String arg0, String arg1, String arg2) {
        this.brpoplpush(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bzpopmax(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bzpopmax(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bzpopmaxAndAwait(List<String> args) {
        return (Response)this.bzpopmax(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bzpopmaxAndForget(List<String> args) {
        this.bzpopmax(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> bzpopmin(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.bzpopmin(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response bzpopminAndAwait(List<String> args) {
        return (Response)this.bzpopmin(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI bzpopminAndForget(List<String> args) {
        this.bzpopmin(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> client(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.client(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response clientAndAwait(List<String> args) {
        return (Response)this.client(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI clientAndForget(List<String> args) {
        this.client(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> cluster(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.cluster(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response clusterAndAwait(List<String> args) {
        return (Response)this.cluster(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI clusterAndForget(List<String> args) {
        this.cluster(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> command(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.command(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response commandAndAwait(List<String> args) {
        return (Response)this.command(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI commandAndForget(List<String> args) {
        this.command(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> config(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.config(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response configAndAwait(List<String> args) {
        return (Response)this.config(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI configAndForget(List<String> args) {
        this.config(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> copy(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.copy(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response copyAndAwait(List<String> args) {
        return (Response)this.copy(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI copyAndForget(List<String> args) {
        this.copy(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> dbsize() {
        return AsyncResultUni.toUni(handler -> this.delegate.dbsize((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response dbsizeAndAwait() {
        return (Response)this.dbsize().await().indefinitely();
    }

    @Fluent
    public RedisAPI dbsizeAndForget() {
        this.dbsize().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> debug(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.debug(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response debugAndAwait(List<String> args) {
        return (Response)this.debug(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI debugAndForget(List<String> args) {
        this.debug(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> decr(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.decr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response decrAndAwait(String arg0) {
        return (Response)this.decr(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI decrAndForget(String arg0) {
        this.decr(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> decrby(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.decrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response decrbyAndAwait(String arg0, String arg1) {
        return (Response)this.decrby(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI decrbyAndForget(String arg0, String arg1) {
        this.decrby(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> del(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.del(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response delAndAwait(List<String> args) {
        return (Response)this.del(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI delAndForget(List<String> args) {
        this.del(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> discard() {
        return AsyncResultUni.toUni(handler -> this.delegate.discard((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response discardAndAwait() {
        return (Response)this.discard().await().indefinitely();
    }

    @Fluent
    public RedisAPI discardAndForget() {
        this.discard().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> dump(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.dump(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response dumpAndAwait(String arg0) {
        return (Response)this.dump(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI dumpAndForget(String arg0) {
        this.dump(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> echo(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.echo(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response echoAndAwait(String arg0) {
        return (Response)this.echo(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI echoAndForget(String arg0) {
        this.echo(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> eval(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.eval(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response evalAndAwait(List<String> args) {
        return (Response)this.eval(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI evalAndForget(List<String> args) {
        this.eval(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> evalsha(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.evalsha(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response evalshaAndAwait(List<String> args) {
        return (Response)this.evalsha(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI evalshaAndForget(List<String> args) {
        this.evalsha(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> exec() {
        return AsyncResultUni.toUni(handler -> this.delegate.exec((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response execAndAwait() {
        return (Response)this.exec().await().indefinitely();
    }

    @Fluent
    public RedisAPI execAndForget() {
        this.exec().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> exists(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.exists(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response existsAndAwait(List<String> args) {
        return (Response)this.exists(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI existsAndForget(List<String> args) {
        this.exists(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> expire(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.expire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response expireAndAwait(String arg0, String arg1) {
        return (Response)this.expire(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI expireAndForget(String arg0, String arg1) {
        this.expire(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> expireat(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.expireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response expireatAndAwait(String arg0, String arg1) {
        return (Response)this.expireat(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI expireatAndForget(String arg0, String arg1) {
        this.expireat(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> failover(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.failover(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response failoverAndAwait(List<String> args) {
        return (Response)this.failover(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI failoverAndForget(List<String> args) {
        this.failover(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> flushall(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.flushall(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response flushallAndAwait(List<String> args) {
        return (Response)this.flushall(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI flushallAndForget(List<String> args) {
        this.flushall(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> flushdb(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.flushdb(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response flushdbAndAwait(List<String> args) {
        return (Response)this.flushdb(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI flushdbAndForget(List<String> args) {
        this.flushdb(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geoadd(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geoadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geoaddAndAwait(List<String> args) {
        return (Response)this.geoadd(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geoaddAndForget(List<String> args) {
        this.geoadd(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geodist(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geodist(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geodistAndAwait(List<String> args) {
        return (Response)this.geodist(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geodistAndForget(List<String> args) {
        this.geodist(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geohash(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geohash(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geohashAndAwait(List<String> args) {
        return (Response)this.geohash(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geohashAndForget(List<String> args) {
        this.geohash(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geopos(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geopos(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geoposAndAwait(List<String> args) {
        return (Response)this.geopos(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geoposAndForget(List<String> args) {
        this.geopos(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> georadius(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.georadius(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response georadiusAndAwait(List<String> args) {
        return (Response)this.georadius(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI georadiusAndForget(List<String> args) {
        this.georadius(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> georadiusRo(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.georadiusRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response georadiusRoAndAwait(List<String> args) {
        return (Response)this.georadiusRo(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI georadiusRoAndForget(List<String> args) {
        this.georadiusRo(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> georadiusbymember(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.georadiusbymember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response georadiusbymemberAndAwait(List<String> args) {
        return (Response)this.georadiusbymember(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI georadiusbymemberAndForget(List<String> args) {
        this.georadiusbymember(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> georadiusbymemberRo(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.georadiusbymemberRo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response georadiusbymemberRoAndAwait(List<String> args) {
        return (Response)this.georadiusbymemberRo(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI georadiusbymemberRoAndForget(List<String> args) {
        this.georadiusbymemberRo(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geosearch(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geosearch(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geosearchAndAwait(List<String> args) {
        return (Response)this.geosearch(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geosearchAndForget(List<String> args) {
        this.geosearch(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> geosearchstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.geosearchstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response geosearchstoreAndAwait(List<String> args) {
        return (Response)this.geosearchstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI geosearchstoreAndForget(List<String> args) {
        this.geosearchstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> get(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.get(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getAndAwait(String arg0) {
        return (Response)this.get(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI getAndForget(String arg0) {
        this.get(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> getbit(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.getbit(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getbitAndAwait(String arg0, String arg1) {
        return (Response)this.getbit(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI getbitAndForget(String arg0, String arg1) {
        this.getbit(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> getdel(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.getdel(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getdelAndAwait(String arg0) {
        return (Response)this.getdel(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI getdelAndForget(String arg0) {
        this.getdel(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> getex(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.getex(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getexAndAwait(List<String> args) {
        return (Response)this.getex(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI getexAndForget(List<String> args) {
        this.getex(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> getrange(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.getrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getrangeAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.getrange(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI getrangeAndForget(String arg0, String arg1, String arg2) {
        this.getrange(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> getset(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.getset(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response getsetAndAwait(String arg0, String arg1) {
        return (Response)this.getset(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI getsetAndForget(String arg0, String arg1) {
        this.getset(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hdel(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hdel(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hdelAndAwait(List<String> args) {
        return (Response)this.hdel(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hdelAndForget(List<String> args) {
        this.hdel(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hello(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hello(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response helloAndAwait(List<String> args) {
        return (Response)this.hello(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI helloAndForget(List<String> args) {
        this.hello(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hexists(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.hexists(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hexistsAndAwait(String arg0, String arg1) {
        return (Response)this.hexists(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI hexistsAndForget(String arg0, String arg1) {
        this.hexists(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hget(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.hget(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hgetAndAwait(String arg0, String arg1) {
        return (Response)this.hget(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI hgetAndForget(String arg0, String arg1) {
        this.hget(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hgetall(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.hgetall(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hgetallAndAwait(String arg0) {
        return (Response)this.hgetall(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI hgetallAndForget(String arg0) {
        this.hgetall(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hincrby(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.hincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hincrbyAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.hincrby(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI hincrbyAndForget(String arg0, String arg1, String arg2) {
        this.hincrby(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hincrbyfloat(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.hincrbyfloat(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hincrbyfloatAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.hincrbyfloat(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI hincrbyfloatAndForget(String arg0, String arg1, String arg2) {
        this.hincrbyfloat(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hkeys(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.hkeys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hkeysAndAwait(String arg0) {
        return (Response)this.hkeys(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI hkeysAndForget(String arg0) {
        this.hkeys(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hlen(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.hlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hlenAndAwait(String arg0) {
        return (Response)this.hlen(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI hlenAndForget(String arg0) {
        this.hlen(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hmget(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hmget(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hmgetAndAwait(List<String> args) {
        return (Response)this.hmget(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hmgetAndForget(List<String> args) {
        this.hmget(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hmset(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hmset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hmsetAndAwait(List<String> args) {
        return (Response)this.hmset(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hmsetAndForget(List<String> args) {
        this.hmset(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> host(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.host(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hostAndAwait(List<String> args) {
        return (Response)this.host(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hostAndForget(List<String> args) {
        this.host(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hrandfield(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hrandfield(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hrandfieldAndAwait(List<String> args) {
        return (Response)this.hrandfield(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hrandfieldAndForget(List<String> args) {
        this.hrandfield(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hscan(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hscanAndAwait(List<String> args) {
        return (Response)this.hscan(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hscanAndForget(List<String> args) {
        this.hscan(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hset(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.hset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hsetAndAwait(List<String> args) {
        return (Response)this.hset(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI hsetAndForget(List<String> args) {
        this.hset(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hsetnx(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.hsetnx(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hsetnxAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.hsetnx(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI hsetnxAndForget(String arg0, String arg1, String arg2) {
        this.hsetnx(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hstrlen(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.hstrlen(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hstrlenAndAwait(String arg0, String arg1) {
        return (Response)this.hstrlen(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI hstrlenAndForget(String arg0, String arg1) {
        this.hstrlen(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> hvals(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.hvals(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response hvalsAndAwait(String arg0) {
        return (Response)this.hvals(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI hvalsAndForget(String arg0) {
        this.hvals(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> incr(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.incr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response incrAndAwait(String arg0) {
        return (Response)this.incr(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI incrAndForget(String arg0) {
        this.incr(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> incrby(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.incrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response incrbyAndAwait(String arg0, String arg1) {
        return (Response)this.incrby(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI incrbyAndForget(String arg0, String arg1) {
        this.incrby(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> incrbyfloat(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.incrbyfloat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response incrbyfloatAndAwait(String arg0, String arg1) {
        return (Response)this.incrbyfloat(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI incrbyfloatAndForget(String arg0, String arg1) {
        this.incrbyfloat(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> info(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.info(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response infoAndAwait(List<String> args) {
        return (Response)this.info(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI infoAndForget(List<String> args) {
        this.info(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> keys(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.keys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response keysAndAwait(String arg0) {
        return (Response)this.keys(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI keysAndForget(String arg0) {
        this.keys(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lastsave() {
        return AsyncResultUni.toUni(handler -> this.delegate.lastsave((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lastsaveAndAwait() {
        return (Response)this.lastsave().await().indefinitely();
    }

    @Fluent
    public RedisAPI lastsaveAndForget() {
        this.lastsave().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> latency(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.latency(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response latencyAndAwait(List<String> args) {
        return (Response)this.latency(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI latencyAndForget(List<String> args) {
        this.latency(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lindex(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.lindex(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lindexAndAwait(String arg0, String arg1) {
        return (Response)this.lindex(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI lindexAndForget(String arg0, String arg1) {
        this.lindex(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> linsert(String arg0, String arg1, String arg2, String arg3) {
        return AsyncResultUni.toUni(handler -> this.delegate.linsert(arg0, arg1, arg2, arg3, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response linsertAndAwait(String arg0, String arg1, String arg2, String arg3) {
        return (Response)this.linsert(arg0, arg1, arg2, arg3).await().indefinitely();
    }

    @Fluent
    public RedisAPI linsertAndForget(String arg0, String arg1, String arg2, String arg3) {
        this.linsert(arg0, arg1, arg2, arg3).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> llen(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.llen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response llenAndAwait(String arg0) {
        return (Response)this.llen(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI llenAndForget(String arg0) {
        this.llen(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lmove(String arg0, String arg1, String arg2, String arg3) {
        return AsyncResultUni.toUni(handler -> this.delegate.lmove(arg0, arg1, arg2, arg3, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lmoveAndAwait(String arg0, String arg1, String arg2, String arg3) {
        return (Response)this.lmove(arg0, arg1, arg2, arg3).await().indefinitely();
    }

    @Fluent
    public RedisAPI lmoveAndForget(String arg0, String arg1, String arg2, String arg3) {
        this.lmove(arg0, arg1, arg2, arg3).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lolwut(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.lolwut(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lolwutAndAwait(List<String> args) {
        return (Response)this.lolwut(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI lolwutAndForget(List<String> args) {
        this.lolwut(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lpop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.lpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lpopAndAwait(List<String> args) {
        return (Response)this.lpop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI lpopAndForget(List<String> args) {
        this.lpop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lpos(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.lpos(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lposAndAwait(List<String> args) {
        return (Response)this.lpos(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI lposAndForget(List<String> args) {
        this.lpos(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lpush(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.lpush(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lpushAndAwait(List<String> args) {
        return (Response)this.lpush(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI lpushAndForget(List<String> args) {
        this.lpush(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lpushx(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.lpushx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lpushxAndAwait(List<String> args) {
        return (Response)this.lpushx(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI lpushxAndForget(List<String> args) {
        this.lpushx(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lrange(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.lrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lrangeAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.lrange(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI lrangeAndForget(String arg0, String arg1, String arg2) {
        this.lrange(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lrem(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.lrem(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lremAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.lrem(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI lremAndForget(String arg0, String arg1, String arg2) {
        this.lrem(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> lset(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.lset(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response lsetAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.lset(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI lsetAndForget(String arg0, String arg1, String arg2) {
        this.lset(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> ltrim(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.ltrim(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response ltrimAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.ltrim(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI ltrimAndForget(String arg0, String arg1, String arg2) {
        this.ltrim(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> memory(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.memory(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response memoryAndAwait(List<String> args) {
        return (Response)this.memory(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI memoryAndForget(List<String> args) {
        this.memory(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> mget(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.mget(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response mgetAndAwait(List<String> args) {
        return (Response)this.mget(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI mgetAndForget(List<String> args) {
        this.mget(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> migrate(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.migrate(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response migrateAndAwait(List<String> args) {
        return (Response)this.migrate(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI migrateAndForget(List<String> args) {
        this.migrate(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> module(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.module(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response moduleAndAwait(List<String> args) {
        return (Response)this.module(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI moduleAndForget(List<String> args) {
        this.module(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> monitor() {
        return AsyncResultUni.toUni(handler -> this.delegate.monitor((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response monitorAndAwait() {
        return (Response)this.monitor().await().indefinitely();
    }

    @Fluent
    public RedisAPI monitorAndForget() {
        this.monitor().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> move(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.move(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response moveAndAwait(String arg0, String arg1) {
        return (Response)this.move(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI moveAndForget(String arg0, String arg1) {
        this.move(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> mset(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.mset(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response msetAndAwait(List<String> args) {
        return (Response)this.mset(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI msetAndForget(List<String> args) {
        this.mset(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> msetnx(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.msetnx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response msetnxAndAwait(List<String> args) {
        return (Response)this.msetnx(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI msetnxAndForget(List<String> args) {
        this.msetnx(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> multi() {
        return AsyncResultUni.toUni(handler -> this.delegate.multi((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response multiAndAwait() {
        return (Response)this.multi().await().indefinitely();
    }

    @Fluent
    public RedisAPI multiAndForget() {
        this.multi().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> object(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.object(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response objectAndAwait(List<String> args) {
        return (Response)this.object(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI objectAndForget(List<String> args) {
        this.object(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> persist(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.persist(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response persistAndAwait(String arg0) {
        return (Response)this.persist(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI persistAndForget(String arg0) {
        this.persist(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pexpire(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.pexpire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pexpireAndAwait(String arg0, String arg1) {
        return (Response)this.pexpire(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI pexpireAndForget(String arg0, String arg1) {
        this.pexpire(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pexpireat(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.pexpireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pexpireatAndAwait(String arg0, String arg1) {
        return (Response)this.pexpireat(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI pexpireatAndForget(String arg0, String arg1) {
        this.pexpireat(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pfadd(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.pfadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pfaddAndAwait(List<String> args) {
        return (Response)this.pfadd(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pfaddAndForget(List<String> args) {
        this.pfadd(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pfcount(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.pfcount(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pfcountAndAwait(List<String> args) {
        return (Response)this.pfcount(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pfcountAndForget(List<String> args) {
        this.pfcount(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pfdebug(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.pfdebug(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pfdebugAndAwait(List<String> args) {
        return (Response)this.pfdebug(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pfdebugAndForget(List<String> args) {
        this.pfdebug(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pfmerge(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.pfmerge(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pfmergeAndAwait(List<String> args) {
        return (Response)this.pfmerge(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pfmergeAndForget(List<String> args) {
        this.pfmerge(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pfselftest() {
        return AsyncResultUni.toUni(handler -> this.delegate.pfselftest((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pfselftestAndAwait() {
        return (Response)this.pfselftest().await().indefinitely();
    }

    @Fluent
    public RedisAPI pfselftestAndForget() {
        this.pfselftest().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> ping(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.ping(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pingAndAwait(List<String> args) {
        return (Response)this.ping(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pingAndForget(List<String> args) {
        this.ping(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> post(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.post(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response postAndAwait(List<String> args) {
        return (Response)this.post(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI postAndForget(List<String> args) {
        this.post(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> psetex(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.psetex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response psetexAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.psetex(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI psetexAndForget(String arg0, String arg1, String arg2) {
        this.psetex(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> psubscribe(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.psubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response psubscribeAndAwait(List<String> args) {
        return (Response)this.psubscribe(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI psubscribeAndForget(List<String> args) {
        this.psubscribe(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> psync(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.psync(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response psyncAndAwait(List<String> args) {
        return (Response)this.psync(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI psyncAndForget(List<String> args) {
        this.psync(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pttl(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.pttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pttlAndAwait(String arg0) {
        return (Response)this.pttl(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI pttlAndForget(String arg0) {
        this.pttl(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> publish(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.publish(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response publishAndAwait(String arg0, String arg1) {
        return (Response)this.publish(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI publishAndForget(String arg0, String arg1) {
        this.publish(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> pubsub(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.pubsub(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response pubsubAndAwait(List<String> args) {
        return (Response)this.pubsub(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI pubsubAndForget(List<String> args) {
        this.pubsub(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> punsubscribe(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.punsubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response punsubscribeAndAwait(List<String> args) {
        return (Response)this.punsubscribe(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI punsubscribeAndForget(List<String> args) {
        this.punsubscribe(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> randomkey() {
        return AsyncResultUni.toUni(handler -> this.delegate.randomkey((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response randomkeyAndAwait() {
        return (Response)this.randomkey().await().indefinitely();
    }

    @Fluent
    public RedisAPI randomkeyAndForget() {
        this.randomkey().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> readonly() {
        return AsyncResultUni.toUni(handler -> this.delegate.readonly((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response readonlyAndAwait() {
        return (Response)this.readonly().await().indefinitely();
    }

    @Fluent
    public RedisAPI readonlyAndForget() {
        this.readonly().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> readwrite() {
        return AsyncResultUni.toUni(handler -> this.delegate.readwrite((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response readwriteAndAwait() {
        return (Response)this.readwrite().await().indefinitely();
    }

    @Fluent
    public RedisAPI readwriteAndForget() {
        this.readwrite().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> rename(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.rename(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response renameAndAwait(String arg0, String arg1) {
        return (Response)this.rename(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI renameAndForget(String arg0, String arg1) {
        this.rename(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> renamenx(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.renamenx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response renamenxAndAwait(String arg0, String arg1) {
        return (Response)this.renamenx(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI renamenxAndForget(String arg0, String arg1) {
        this.renamenx(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> replconf(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.replconf(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response replconfAndAwait(List<String> args) {
        return (Response)this.replconf(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI replconfAndForget(List<String> args) {
        this.replconf(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> replicaof(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.replicaof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response replicaofAndAwait(String arg0, String arg1) {
        return (Response)this.replicaof(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI replicaofAndForget(String arg0, String arg1) {
        this.replicaof(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> reset() {
        return AsyncResultUni.toUni(handler -> this.delegate.reset((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response resetAndAwait() {
        return (Response)this.reset().await().indefinitely();
    }

    @Fluent
    public RedisAPI resetAndForget() {
        this.reset().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> restore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.restore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response restoreAndAwait(List<String> args) {
        return (Response)this.restore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI restoreAndForget(List<String> args) {
        this.restore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> restoreAsking(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.restoreAsking(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response restoreAskingAndAwait(List<String> args) {
        return (Response)this.restoreAsking(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI restoreAskingAndForget(List<String> args) {
        this.restoreAsking(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> role() {
        return AsyncResultUni.toUni(handler -> this.delegate.role((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response roleAndAwait() {
        return (Response)this.role().await().indefinitely();
    }

    @Fluent
    public RedisAPI roleAndForget() {
        this.role().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> rpop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.rpop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response rpopAndAwait(List<String> args) {
        return (Response)this.rpop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI rpopAndForget(List<String> args) {
        this.rpop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> rpoplpush(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.rpoplpush(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response rpoplpushAndAwait(String arg0, String arg1) {
        return (Response)this.rpoplpush(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI rpoplpushAndForget(String arg0, String arg1) {
        this.rpoplpush(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> rpush(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.rpush(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response rpushAndAwait(List<String> args) {
        return (Response)this.rpush(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI rpushAndForget(List<String> args) {
        this.rpush(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> rpushx(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.rpushx(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response rpushxAndAwait(List<String> args) {
        return (Response)this.rpushx(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI rpushxAndForget(List<String> args) {
        this.rpushx(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sadd(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response saddAndAwait(List<String> args) {
        return (Response)this.sadd(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI saddAndForget(List<String> args) {
        this.sadd(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> save() {
        return AsyncResultUni.toUni(handler -> this.delegate.save((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response saveAndAwait() {
        return (Response)this.save().await().indefinitely();
    }

    @Fluent
    public RedisAPI saveAndForget() {
        this.save().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> scan(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.scan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response scanAndAwait(List<String> args) {
        return (Response)this.scan(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI scanAndForget(List<String> args) {
        this.scan(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> scard(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.scard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response scardAndAwait(String arg0) {
        return (Response)this.scard(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI scardAndForget(String arg0) {
        this.scard(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> script(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.script(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response scriptAndAwait(List<String> args) {
        return (Response)this.script(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI scriptAndForget(List<String> args) {
        this.script(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sdiff(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sdiff(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sdiffAndAwait(List<String> args) {
        return (Response)this.sdiff(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sdiffAndForget(List<String> args) {
        this.sdiff(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sdiffstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sdiffstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sdiffstoreAndAwait(List<String> args) {
        return (Response)this.sdiffstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sdiffstoreAndForget(List<String> args) {
        this.sdiffstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> select(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.select(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response selectAndAwait(String arg0) {
        return (Response)this.select(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI selectAndForget(String arg0) {
        this.select(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> set(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.set(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response setAndAwait(List<String> args) {
        return (Response)this.set(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI setAndForget(List<String> args) {
        this.set(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> setbit(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.setbit(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response setbitAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.setbit(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI setbitAndForget(String arg0, String arg1, String arg2) {
        this.setbit(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> setex(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.setex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response setexAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.setex(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI setexAndForget(String arg0, String arg1, String arg2) {
        this.setex(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> setnx(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.setnx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response setnxAndAwait(String arg0, String arg1) {
        return (Response)this.setnx(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI setnxAndForget(String arg0, String arg1) {
        this.setnx(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> setrange(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.setrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response setrangeAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.setrange(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI setrangeAndForget(String arg0, String arg1, String arg2) {
        this.setrange(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> shutdown(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.shutdown(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response shutdownAndAwait(List<String> args) {
        return (Response)this.shutdown(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI shutdownAndForget(List<String> args) {
        this.shutdown(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sinter(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sinter(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sinterAndAwait(List<String> args) {
        return (Response)this.sinter(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sinterAndForget(List<String> args) {
        this.sinter(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sinterstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sinterstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sinterstoreAndAwait(List<String> args) {
        return (Response)this.sinterstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sinterstoreAndForget(List<String> args) {
        this.sinterstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sismember(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.sismember(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sismemberAndAwait(String arg0, String arg1) {
        return (Response)this.sismember(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI sismemberAndForget(String arg0, String arg1) {
        this.sismember(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> slaveof(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.slaveof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response slaveofAndAwait(String arg0, String arg1) {
        return (Response)this.slaveof(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI slaveofAndForget(String arg0, String arg1) {
        this.slaveof(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> slowlog(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.slowlog(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response slowlogAndAwait(List<String> args) {
        return (Response)this.slowlog(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI slowlogAndForget(List<String> args) {
        this.slowlog(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> smembers(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.smembers(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response smembersAndAwait(String arg0) {
        return (Response)this.smembers(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI smembersAndForget(String arg0) {
        this.smembers(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> smismember(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.smismember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response smismemberAndAwait(List<String> args) {
        return (Response)this.smismember(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI smismemberAndForget(List<String> args) {
        this.smismember(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> smove(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.smove(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response smoveAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.smove(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI smoveAndForget(String arg0, String arg1, String arg2) {
        this.smove(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sort(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sort(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sortAndAwait(List<String> args) {
        return (Response)this.sort(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sortAndForget(List<String> args) {
        this.sort(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> spop(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.spop(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response spopAndAwait(List<String> args) {
        return (Response)this.spop(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI spopAndForget(List<String> args) {
        this.spop(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> srandmember(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.srandmember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response srandmemberAndAwait(List<String> args) {
        return (Response)this.srandmember(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI srandmemberAndForget(List<String> args) {
        this.srandmember(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> srem(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.srem(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sremAndAwait(List<String> args) {
        return (Response)this.srem(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sremAndForget(List<String> args) {
        this.srem(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sscan(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sscanAndAwait(List<String> args) {
        return (Response)this.sscan(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sscanAndForget(List<String> args) {
        this.sscan(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> stralgo(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.stralgo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response stralgoAndAwait(List<String> args) {
        return (Response)this.stralgo(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI stralgoAndForget(List<String> args) {
        this.stralgo(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> strlen(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.strlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response strlenAndAwait(String arg0) {
        return (Response)this.strlen(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI strlenAndForget(String arg0) {
        this.strlen(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> subscribe(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.subscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response subscribeAndAwait(List<String> args) {
        return (Response)this.subscribe(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI subscribeAndForget(List<String> args) {
        this.subscribe(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> substr(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.substr(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response substrAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.substr(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI substrAndForget(String arg0, String arg1, String arg2) {
        this.substr(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sunion(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sunion(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sunionAndAwait(List<String> args) {
        return (Response)this.sunion(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sunionAndForget(List<String> args) {
        this.sunion(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sunionstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.sunionstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response sunionstoreAndAwait(List<String> args) {
        return (Response)this.sunionstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI sunionstoreAndForget(List<String> args) {
        this.sunionstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> swapdb(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.swapdb(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response swapdbAndAwait(String arg0, String arg1) {
        return (Response)this.swapdb(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI swapdbAndForget(String arg0, String arg1) {
        this.swapdb(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> sync() {
        return AsyncResultUni.toUni(handler -> this.delegate.sync((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response syncAndAwait() {
        return (Response)this.sync().await().indefinitely();
    }

    @Fluent
    public RedisAPI syncAndForget() {
        this.sync().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> time() {
        return AsyncResultUni.toUni(handler -> this.delegate.time((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response timeAndAwait() {
        return (Response)this.time().await().indefinitely();
    }

    @Fluent
    public RedisAPI timeAndForget() {
        this.time().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> touch(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.touch(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response touchAndAwait(List<String> args) {
        return (Response)this.touch(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI touchAndForget(List<String> args) {
        this.touch(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> ttl(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.ttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response ttlAndAwait(String arg0) {
        return (Response)this.ttl(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI ttlAndForget(String arg0) {
        this.ttl(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> type(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.type(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response typeAndAwait(String arg0) {
        return (Response)this.type(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI typeAndForget(String arg0) {
        this.type(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> unlink(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.unlink(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response unlinkAndAwait(List<String> args) {
        return (Response)this.unlink(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI unlinkAndForget(List<String> args) {
        this.unlink(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> unsubscribe(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.unsubscribe(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response unsubscribeAndAwait(List<String> args) {
        return (Response)this.unsubscribe(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI unsubscribeAndForget(List<String> args) {
        this.unsubscribe(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> unwatch() {
        return AsyncResultUni.toUni(handler -> this.delegate.unwatch((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response unwatchAndAwait() {
        return (Response)this.unwatch().await().indefinitely();
    }

    @Fluent
    public RedisAPI unwatchAndForget() {
        this.unwatch().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> wait(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.wait(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response waitAndAwait(String arg0, String arg1) {
        return (Response)this.wait(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI waitAndForget(String arg0, String arg1) {
        this.wait(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> watch(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.watch(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response watchAndAwait(List<String> args) {
        return (Response)this.watch(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI watchAndForget(List<String> args) {
        this.watch(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xack(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xack(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xackAndAwait(List<String> args) {
        return (Response)this.xack(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xackAndForget(List<String> args) {
        this.xack(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xadd(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xaddAndAwait(List<String> args) {
        return (Response)this.xadd(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xaddAndForget(List<String> args) {
        this.xadd(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xautoclaim(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xautoclaim(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xautoclaimAndAwait(List<String> args) {
        return (Response)this.xautoclaim(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xautoclaimAndForget(List<String> args) {
        this.xautoclaim(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xclaim(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xclaim(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xclaimAndAwait(List<String> args) {
        return (Response)this.xclaim(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xclaimAndForget(List<String> args) {
        this.xclaim(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xdel(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xdel(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xdelAndAwait(List<String> args) {
        return (Response)this.xdel(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xdelAndForget(List<String> args) {
        this.xdel(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xgroup(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xgroup(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xgroupAndAwait(List<String> args) {
        return (Response)this.xgroup(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xgroupAndForget(List<String> args) {
        this.xgroup(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xinfo(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xinfo(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xinfoAndAwait(List<String> args) {
        return (Response)this.xinfo(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xinfoAndForget(List<String> args) {
        this.xinfo(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xlen(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.xlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xlenAndAwait(String arg0) {
        return (Response)this.xlen(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI xlenAndForget(String arg0) {
        this.xlen(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xpending(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xpending(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xpendingAndAwait(List<String> args) {
        return (Response)this.xpending(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xpendingAndForget(List<String> args) {
        this.xpending(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xrange(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xrangeAndAwait(List<String> args) {
        return (Response)this.xrange(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xrangeAndForget(List<String> args) {
        this.xrange(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xread(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xread(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xreadAndAwait(List<String> args) {
        return (Response)this.xread(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xreadAndForget(List<String> args) {
        this.xread(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xreadgroup(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xreadgroup(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xreadgroupAndAwait(List<String> args) {
        return (Response)this.xreadgroup(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xreadgroupAndForget(List<String> args) {
        this.xreadgroup(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xrevrange(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xrevrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xrevrangeAndAwait(List<String> args) {
        return (Response)this.xrevrange(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xrevrangeAndForget(List<String> args) {
        this.xrevrange(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xsetid(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.xsetid(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xsetidAndAwait(String arg0, String arg1) {
        return (Response)this.xsetid(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI xsetidAndForget(String arg0, String arg1) {
        this.xsetid(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> xtrim(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.xtrim(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response xtrimAndAwait(List<String> args) {
        return (Response)this.xtrim(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI xtrimAndForget(List<String> args) {
        this.xtrim(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zadd(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zadd(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zaddAndAwait(List<String> args) {
        return (Response)this.zadd(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zaddAndForget(List<String> args) {
        this.zadd(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zcard(String arg0) {
        return AsyncResultUni.toUni(handler -> this.delegate.zcard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zcardAndAwait(String arg0) {
        return (Response)this.zcard(arg0).await().indefinitely();
    }

    @Fluent
    public RedisAPI zcardAndForget(String arg0) {
        this.zcard(arg0).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zcount(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zcountAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zcount(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zcountAndForget(String arg0, String arg1, String arg2) {
        this.zcount(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zdiff(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zdiff(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zdiffAndAwait(List<String> args) {
        return (Response)this.zdiff(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zdiffAndForget(List<String> args) {
        this.zdiff(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zdiffstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zdiffstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zdiffstoreAndAwait(List<String> args) {
        return (Response)this.zdiffstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zdiffstoreAndForget(List<String> args) {
        this.zdiffstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zincrby(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zincrbyAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zincrby(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zincrbyAndForget(String arg0, String arg1, String arg2) {
        this.zincrby(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zinter(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zinter(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zinterAndAwait(List<String> args) {
        return (Response)this.zinter(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zinterAndForget(List<String> args) {
        this.zinter(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zinterstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zinterstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zinterstoreAndAwait(List<String> args) {
        return (Response)this.zinterstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zinterstoreAndForget(List<String> args) {
        this.zinterstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zlexcount(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zlexcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zlexcountAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zlexcount(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zlexcountAndForget(String arg0, String arg1, String arg2) {
        this.zlexcount(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zmscore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zmscore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zmscoreAndAwait(List<String> args) {
        return (Response)this.zmscore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zmscoreAndForget(List<String> args) {
        this.zmscore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zpopmax(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zpopmax(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zpopmaxAndAwait(List<String> args) {
        return (Response)this.zpopmax(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zpopmaxAndForget(List<String> args) {
        this.zpopmax(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zpopmin(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zpopmin(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zpopminAndAwait(List<String> args) {
        return (Response)this.zpopmin(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zpopminAndForget(List<String> args) {
        this.zpopmin(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrandmember(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrandmember(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrandmemberAndAwait(List<String> args) {
        return (Response)this.zrandmember(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrandmemberAndForget(List<String> args) {
        this.zrandmember(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrange(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrangeAndAwait(List<String> args) {
        return (Response)this.zrange(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrangeAndForget(List<String> args) {
        this.zrange(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrangebylex(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrangebylex(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrangebylexAndAwait(List<String> args) {
        return (Response)this.zrangebylex(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrangebylexAndForget(List<String> args) {
        this.zrangebylex(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrangebyscore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrangebyscore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrangebyscoreAndAwait(List<String> args) {
        return (Response)this.zrangebyscore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrangebyscoreAndForget(List<String> args) {
        this.zrangebyscore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrangestore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrangestore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrangestoreAndAwait(List<String> args) {
        return (Response)this.zrangestore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrangestoreAndForget(List<String> args) {
        this.zrangestore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrank(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrankAndAwait(String arg0, String arg1) {
        return (Response)this.zrank(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrankAndForget(String arg0, String arg1) {
        this.zrank(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrem(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrem(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zremAndAwait(List<String> args) {
        return (Response)this.zrem(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zremAndForget(List<String> args) {
        this.zrem(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zremrangebylex(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zremrangebylex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zremrangebylexAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zremrangebylex(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zremrangebylexAndForget(String arg0, String arg1, String arg2) {
        this.zremrangebylex(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zremrangebyrank(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zremrangebyrank(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zremrangebyrankAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zremrangebyrank(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zremrangebyrankAndForget(String arg0, String arg1, String arg2) {
        this.zremrangebyrank(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zremrangebyscore(String arg0, String arg1, String arg2) {
        return AsyncResultUni.toUni(handler -> this.delegate.zremrangebyscore(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zremrangebyscoreAndAwait(String arg0, String arg1, String arg2) {
        return (Response)this.zremrangebyscore(arg0, arg1, arg2).await().indefinitely();
    }

    @Fluent
    public RedisAPI zremrangebyscoreAndForget(String arg0, String arg1, String arg2) {
        this.zremrangebyscore(arg0, arg1, arg2).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrevrange(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrevrange(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrevrangeAndAwait(List<String> args) {
        return (Response)this.zrevrange(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrevrangeAndForget(List<String> args) {
        this.zrevrange(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrevrangebylex(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrevrangebylex(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrevrangebylexAndAwait(List<String> args) {
        return (Response)this.zrevrangebylex(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrevrangebylexAndForget(List<String> args) {
        this.zrevrangebylex(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrevrangebyscore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrevrangebyscore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrevrangebyscoreAndAwait(List<String> args) {
        return (Response)this.zrevrangebyscore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrevrangebyscoreAndForget(List<String> args) {
        this.zrevrangebyscore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zrevrank(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.zrevrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zrevrankAndAwait(String arg0, String arg1) {
        return (Response)this.zrevrank(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI zrevrankAndForget(String arg0, String arg1) {
        this.zrevrank(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zscan(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zscan(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zscanAndAwait(List<String> args) {
        return (Response)this.zscan(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zscanAndForget(List<String> args) {
        this.zscan(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zscore(String arg0, String arg1) {
        return AsyncResultUni.toUni(handler -> this.delegate.zscore(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zscoreAndAwait(String arg0, String arg1) {
        return (Response)this.zscore(arg0, arg1).await().indefinitely();
    }

    @Fluent
    public RedisAPI zscoreAndForget(String arg0, String arg1) {
        this.zscore(arg0, arg1).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zunion(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zunion(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zunionAndAwait(List<String> args) {
        return (Response)this.zunion(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zunionAndForget(List<String> args) {
        this.zunion(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Response> zunionstore(List<String> args) {
        return AsyncResultUni.toUni(handler -> this.delegate.zunionstore(args, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Response zunionstoreAndAwait(List<String> args) {
        return (Response)this.zunionstore(args).await().indefinitely();
    }

    @Fluent
    public RedisAPI zunionstoreAndForget(List<String> args) {
        this.zunionstore(args).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static RedisAPI api(Redis client) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.Redis)client.getDelegate()));
        return ret;
    }

    public static RedisAPI api(RedisConnection connection) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.RedisConnection)connection.getDelegate()));
        return ret;
    }

    public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
        return arg != null ? new RedisAPI(arg) : null;
    }
}

