package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.redis.client.RedisOptions;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.Redis.class)
public class Redis {

  public static final io.smallrye.mutiny.vertx.TypeArg<Redis> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public Redis(Object delegate) {
    this.delegate = (io.vertx.redis.client.Redis)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Redis() {
    this.delegate = null;
  }

  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.mutiny.redis.client.Redis createClient(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.redis.client.Redis ret = io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
   * @return the client
   */
  public static io.vertx.mutiny.redis.client.Redis createClient(io.vertx.mutiny.core.Vertx vertx, String connectionString) { 
    io.vertx.mutiny.redis.client.Redis ret = io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), connectionString));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the user provided options
   * @return the client
   */
  public static io.vertx.mutiny.redis.client.Redis createClient(io.vertx.mutiny.core.Vertx vertx, io.vertx.redis.client.RedisOptions options) { 
    io.vertx.mutiny.redis.client.Redis ret = io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the redis server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.RedisConnection> connect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.connect(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.Redis#connect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the RedisConnection instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.RedisConnection connectAndAwait() { 
    return (io.vertx.mutiny.redis.client.RedisConnection) connect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.Redis#connect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.Redis#connect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.Redis#connect} but you don't need to compose it with other operations.
   * @return the instance of Redis to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Redis connectAndForget() { 
    connect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Send the given command to the redis server or cluster.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param command the command to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> send(io.vertx.mutiny.redis.client.Request command) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(onSend -> {
        delegate.send(command.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(onSend, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.Redis#send(io.vertx.mutiny.redis.client.Request)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param command the command to send
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sendAndAwait(io.vertx.mutiny.redis.client.Request command) { 
    return (io.vertx.mutiny.redis.client.Response) send(command).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.Redis#send(io.vertx.mutiny.redis.client.Request)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.Redis#send(io.vertx.mutiny.redis.client.Request)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.Redis#send(io.vertx.mutiny.redis.client.Request)} but you don't need to compose it with other operations.
   * @param command the command to send
   * @return the instance of Redis to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Redis sendAndForget(io.vertx.mutiny.redis.client.Request command) { 
    send(command).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param commands list of command to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.mutiny.redis.client.Response>> batch(List<io.vertx.mutiny.redis.client.Request> commands) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(onSend -> {
        delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new io.smallrye.mutiny.vertx.DelegatingHandler<>(onSend, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(java.util.stream.Collectors.toList()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.Redis#batch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param commands list of command to send
   * @return the List<Response> instance produced by the operation.
   */
  public List<io.vertx.mutiny.redis.client.Response> batchAndAwait(List<io.vertx.mutiny.redis.client.Request> commands) { 
    return (List<io.vertx.mutiny.redis.client.Response>) batch(commands).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.Redis#batch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.Redis#batch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.Redis#batch(List)} but you don't need to compose it with other operations.
   * @param commands list of command to send
   * @return the instance of Redis to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Redis batchAndForget(List<io.vertx.mutiny.redis.client.Request> commands) { 
    batch(commands).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }

}
