/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis.client;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.redis.client.RedisConnection;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.RedisOptions;
import java.util.List;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.redis.client.Redis.class)
public class Redis {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    Redis() {
        this.delegate = null;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Redis createClient(io.vertx.mutiny.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.mutiny.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.mutiny.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    @CheckReturnValue
    public Uni<RedisConnection> connect() {
        return AsyncResultUni.toUni(handler -> this.delegate.connect((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> RedisConnection.newInstance(event)))));
    }

    public RedisConnection connectAndAwait() {
        return (RedisConnection)this.connect().await().indefinitely();
    }

    @Fluent
    public Redis connectAndForget() {
        this.connect().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    @CheckReturnValue
    public Uni<Response> send(Request command) {
        return AsyncResultUni.toUni(onSend -> this.delegate.send(command.getDelegate(), (Handler)new DelegatingHandler(onSend, ar -> ar.map(event -> Response.newInstance(event)))));
    }

    public Response sendAndAwait(Request command) {
        return (Response)this.send(command).await().indefinitely();
    }

    @Fluent
    public Redis sendAndForget(Request command) {
        this.send(command).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Response>> batch(List<Request> commands) {
        return AsyncResultUni.toUni(onSend -> this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new DelegatingHandler(onSend, ar -> ar.map(event -> event.stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())))));
    }

    public List<Response> batchAndAwait(List<Request> commands) {
        return (List)this.batch(commands).await().indefinitely();
    }

    @Fluent
    public Redis batchAndForget(List<Request> commands) {
        this.batch(commands).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

