package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * <b>Auto generated</b> API Commands to interact with REDIS.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Command original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.Command.class)
public class Command implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Command> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Command((io.vertx.redis.client.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.redis.client.Command delegate;
  
  public Command(io.vertx.redis.client.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.redis.client.Command)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Command() {
    this.delegate = null;
  }

  @Override
  public io.vertx.redis.client.Command getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param command command name
   * @return the cacheable immutable command instance
   */
  public static io.vertx.mutiny.redis.client.Command create(String command) { 
    io.vertx.mutiny.redis.client.Command ret = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.create(command));
    return ret;
  }

  /**
   * A container for Access List Control commands.
   */
  public static final io.vertx.mutiny.redis.client.Command ACL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ACL);
  /**
   * Append a value to a key.
   */
  public static final io.vertx.mutiny.redis.client.Command APPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.APPEND);
  /**
   * Sent by cluster clients after an -ASK redirect.
   */
  public static final io.vertx.mutiny.redis.client.Command ASKING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ASKING);
  /**
   * Authenticate to the server.
   */
  public static final io.vertx.mutiny.redis.client.Command AUTH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.AUTH);
  public static final io.vertx.mutiny.redis.client.Command BF_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_ADD);
  public static final io.vertx.mutiny.redis.client.Command BF_CARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_CARD);
  public static final io.vertx.mutiny.redis.client.Command BF_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command BF_EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_EXISTS);
  public static final io.vertx.mutiny.redis.client.Command BF_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_INFO);
  public static final io.vertx.mutiny.redis.client.Command BF_INSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_INSERT);
  public static final io.vertx.mutiny.redis.client.Command BF_LOADCHUNK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_LOADCHUNK);
  public static final io.vertx.mutiny.redis.client.Command BF_MADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_MADD);
  public static final io.vertx.mutiny.redis.client.Command BF_MEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_MEXISTS);
  public static final io.vertx.mutiny.redis.client.Command BF_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_RESERVE);
  public static final io.vertx.mutiny.redis.client.Command BF_SCANDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BF_SCANDUMP);
  /**
   * Asynchronously rewrite the append-only file.
   */
  public static final io.vertx.mutiny.redis.client.Command BGREWRITEAOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGREWRITEAOF);
  /**
   * Asynchronously save the dataset to disk.
   */
  public static final io.vertx.mutiny.redis.client.Command BGSAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGSAVE);
  /**
   * Count set bits in a string.
   */
  public static final io.vertx.mutiny.redis.client.Command BITCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITCOUNT);
  /**
   * Perform arbitrary bitfield integer operations on strings.
   */
  public static final io.vertx.mutiny.redis.client.Command BITFIELD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD);
  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   */
  public static final io.vertx.mutiny.redis.client.Command BITFIELD_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD_RO);
  /**
   * Perform bitwise operations between strings.
   */
  public static final io.vertx.mutiny.redis.client.Command BITOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITOP);
  /**
   * Find first bit set or clear in a string.
   */
  public static final io.vertx.mutiny.redis.client.Command BITPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITPOS);
  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BLMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLMOVE);
  /**
   * Pop elements from a list, or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BLMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLMPOP);
  /**
   * Remove and get the first element in a list, or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BLPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLPOP);
  /**
   * Remove and get the last element in a list, or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BRPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOP);
  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BRPOPLPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOPLPUSH);
  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BZMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZMPOP);
  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BZPOPMAX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMAX);
  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   */
  public static final io.vertx.mutiny.redis.client.Command BZPOPMIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMIN);
  public static final io.vertx.mutiny.redis.client.Command CF_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_ADD);
  public static final io.vertx.mutiny.redis.client.Command CF_ADDNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_ADDNX);
  public static final io.vertx.mutiny.redis.client.Command CF_COMPACT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_COMPACT);
  public static final io.vertx.mutiny.redis.client.Command CF_COUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_COUNT);
  public static final io.vertx.mutiny.redis.client.Command CF_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command CF_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_DEL);
  public static final io.vertx.mutiny.redis.client.Command CF_EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_EXISTS);
  public static final io.vertx.mutiny.redis.client.Command CF_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INFO);
  public static final io.vertx.mutiny.redis.client.Command CF_INSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INSERT);
  public static final io.vertx.mutiny.redis.client.Command CF_INSERTNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_INSERTNX);
  public static final io.vertx.mutiny.redis.client.Command CF_LOADCHUNK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_LOADCHUNK);
  public static final io.vertx.mutiny.redis.client.Command CF_MEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_MEXISTS);
  public static final io.vertx.mutiny.redis.client.Command CF_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_RESERVE);
  public static final io.vertx.mutiny.redis.client.Command CF_SCANDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CF_SCANDUMP);
  /**
   * A container for client connection commands.
   */
  public static final io.vertx.mutiny.redis.client.Command CLIENT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLIENT);
  /**
   * A container for cluster commands.
   */
  public static final io.vertx.mutiny.redis.client.Command CLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLUSTER);
  public static final io.vertx.mutiny.redis.client.Command CMS_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command CMS_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INFO);
  public static final io.vertx.mutiny.redis.client.Command CMS_INITBYDIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INITBYDIM);
  public static final io.vertx.mutiny.redis.client.Command CMS_INITBYPROB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_INITBYPROB);
  public static final io.vertx.mutiny.redis.client.Command CMS_MERGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_MERGE);
  public static final io.vertx.mutiny.redis.client.Command CMS_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CMS_QUERY);
  /**
   * Get array of Redis command details.
   */
  public static final io.vertx.mutiny.redis.client.Command COMMAND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.COMMAND);
  /**
   * A container for server configuration commands.
   */
  public static final io.vertx.mutiny.redis.client.Command CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CONFIG);
  /**
   * Copy a key.
   */
  public static final io.vertx.mutiny.redis.client.Command COPY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.COPY);
  /**
   * Return the number of keys in the selected database.
   */
  public static final io.vertx.mutiny.redis.client.Command DBSIZE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DBSIZE);
  /**
   * A container for debugging commands.
   */
  public static final io.vertx.mutiny.redis.client.Command DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEBUG);
  /**
   * Decrement the integer value of a key by one.
   */
  public static final io.vertx.mutiny.redis.client.Command DECR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECR);
  /**
   * Decrement the integer value of a key by the given number.
   */
  public static final io.vertx.mutiny.redis.client.Command DECRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECRBY);
  /**
   * Delete a key.
   */
  public static final io.vertx.mutiny.redis.client.Command DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEL);
  /**
   * Discard all commands issued after MULTI.
   */
  public static final io.vertx.mutiny.redis.client.Command DISCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DISCARD);
  /**
   * Return a serialized version of the value stored at the specified key.
   */
  public static final io.vertx.mutiny.redis.client.Command DUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DUMP);
  /**
   * Echo the given string.
   */
  public static final io.vertx.mutiny.redis.client.Command ECHO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ECHO);
  /**
   * Execute a Lua script server side.
   */
  public static final io.vertx.mutiny.redis.client.Command EVAL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVAL);
  /**
   * Execute a Lua script server side.
   */
  public static final io.vertx.mutiny.redis.client.Command EVALSHA = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVALSHA);
  /**
   * Execute a read-only Lua script server side.
   */
  public static final io.vertx.mutiny.redis.client.Command EVALSHA_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVALSHA_RO);
  /**
   * Execute a read-only Lua script server side.
   */
  public static final io.vertx.mutiny.redis.client.Command EVAL_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVAL_RO);
  /**
   * Execute all commands issued after MULTI.
   */
  public static final io.vertx.mutiny.redis.client.Command EXEC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXEC);
  /**
   * Determine if a key exists.
   */
  public static final io.vertx.mutiny.redis.client.Command EXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXISTS);
  /**
   * Set a key's time to live in seconds.
   */
  public static final io.vertx.mutiny.redis.client.Command EXPIRE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIRE);
  /**
   * Set the expiration for a key as a UNIX timestamp.
   */
  public static final io.vertx.mutiny.redis.client.Command EXPIREAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIREAT);
  /**
   * Get the expiration Unix timestamp for a key.
   */
  public static final io.vertx.mutiny.redis.client.Command EXPIRETIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIRETIME);
  /**
   * Start a coordinated failover between this server and one of its replicas.
   */
  public static final io.vertx.mutiny.redis.client.Command FAILOVER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FAILOVER);
  /**
   * Invoke a function.
   */
  public static final io.vertx.mutiny.redis.client.Command FCALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FCALL);
  /**
   * Invoke a read-only function.
   */
  public static final io.vertx.mutiny.redis.client.Command FCALL_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FCALL_RO);
  /**
   * Remove all keys from all databases.
   */
  public static final io.vertx.mutiny.redis.client.Command FLUSHALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHALL);
  /**
   * Remove all keys from the current database.
   */
  public static final io.vertx.mutiny.redis.client.Command FLUSHDB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHDB);
  public static final io.vertx.mutiny.redis.client.Command FT_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ADD);
  public static final io.vertx.mutiny.redis.client.Command FT_AGGREGATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_AGGREGATE);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASADD);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_ALIASUPDATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALIASUPDATE);
  public static final io.vertx.mutiny.redis.client.Command FT_ALTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_ALTER);
  public static final io.vertx.mutiny.redis.client.Command FT_CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CONFIG);
  public static final io.vertx.mutiny.redis.client.Command FT_CREATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CREATE);
  public static final io.vertx.mutiny.redis.client.Command FT_CURSOR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_CURSOR);
  public static final io.vertx.mutiny.redis.client.Command FT_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command FT_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DEL);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTADD);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_DICTDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DICTDUMP);
  public static final io.vertx.mutiny.redis.client.Command FT_DROP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DROP);
  public static final io.vertx.mutiny.redis.client.Command FT_DROPINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_DROPINDEX);
  public static final io.vertx.mutiny.redis.client.Command FT_EXPLAIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_EXPLAIN);
  public static final io.vertx.mutiny.redis.client.Command FT_EXPLAINCLI = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_EXPLAINCLI);
  public static final io.vertx.mutiny.redis.client.Command FT_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_GET);
  public static final io.vertx.mutiny.redis.client.Command FT_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_INFO);
  public static final io.vertx.mutiny.redis.client.Command FT_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_MGET);
  public static final io.vertx.mutiny.redis.client.Command FT_PROFILE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_PROFILE);
  public static final io.vertx.mutiny.redis.client.Command FT_SAFEADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SAFEADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SEARCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SEARCH);
  public static final io.vertx.mutiny.redis.client.Command FT_SPELLCHECK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SPELLCHECK);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGDEL);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGGET);
  public static final io.vertx.mutiny.redis.client.Command FT_SUGLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SUGLEN);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNADD);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNDUMP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNDUMP);
  public static final io.vertx.mutiny.redis.client.Command FT_SYNUPDATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_SYNUPDATE);
  public static final io.vertx.mutiny.redis.client.Command FT_TAGVALS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT_TAGVALS);
  public static final io.vertx.mutiny.redis.client.Command FT__ALIASADDIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALIASADDIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__ALIASDELIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALIASDELIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__ALTERIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__ALTERIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__CREATEIFNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__CREATEIFNX);
  public static final io.vertx.mutiny.redis.client.Command FT__DROPIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__DROPIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__DROPINDEXIFX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__DROPINDEXIFX);
  public static final io.vertx.mutiny.redis.client.Command FT__LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FT__LIST);
  /**
   * A container for function commands.
   */
  public static final io.vertx.mutiny.redis.client.Command FUNCTION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FUNCTION);
  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command GEOADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOADD);
  /**
   * Returns the distance between two members of a geospatial index.
   */
  public static final io.vertx.mutiny.redis.client.Command GEODIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEODIST);
  /**
   * Returns members of a geospatial index as standard geohash strings.
   */
  public static final io.vertx.mutiny.redis.client.Command GEOHASH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOHASH);
  /**
   * Returns longitude and latitude of members of a geospatial index.
   */
  public static final io.vertx.mutiny.redis.client.Command GEOPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOPOS);
  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   */
  public static final io.vertx.mutiny.redis.client.Command GEORADIUS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS);
  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   */
  public static final io.vertx.mutiny.redis.client.Command GEORADIUSBYMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER);
  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   */
  public static final io.vertx.mutiny.redis.client.Command GEORADIUSBYMEMBER_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER_RO);
  /**
   * A read-only variant for GEORADIUS.
   */
  public static final io.vertx.mutiny.redis.client.Command GEORADIUS_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS_RO);
  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   */
  public static final io.vertx.mutiny.redis.client.Command GEOSEARCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOSEARCH);
  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   */
  public static final io.vertx.mutiny.redis.client.Command GEOSEARCHSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOSEARCHSTORE);
  /**
   * Get the value of a key.
   */
  public static final io.vertx.mutiny.redis.client.Command GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GET);
  /**
   * Returns the bit value at offset in the string value stored at key.
   */
  public static final io.vertx.mutiny.redis.client.Command GETBIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETBIT);
  /**
   * Get the value of a key and delete the key.
   */
  public static final io.vertx.mutiny.redis.client.Command GETDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETDEL);
  /**
   * Get the value of a key and optionally set its expiration.
   */
  public static final io.vertx.mutiny.redis.client.Command GETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETEX);
  /**
   * Get a substring of the string stored at a key.
   */
  public static final io.vertx.mutiny.redis.client.Command GETRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETRANGE);
  /**
   * Set the string value of a key and return its old value.
   */
  public static final io.vertx.mutiny.redis.client.Command GETSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETSET);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_BULK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_BULK);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_CONFIG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_CONFIG);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_DELETE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_DELETE);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_EXPLAIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_EXPLAIN);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_LIST);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_PROFILE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_PROFILE);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_QUERY);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_RO_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_RO_QUERY);
  public static final io.vertx.mutiny.redis.client.Command GRAPH_SLOWLOG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GRAPH_SLOWLOG);
  /**
   * Delete one or more hash fields.
   */
  public static final io.vertx.mutiny.redis.client.Command HDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HDEL);
  /**
   * Handshake with Redis.
   */
  public static final io.vertx.mutiny.redis.client.Command HELLO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HELLO);
  /**
   * Determine if a hash field exists.
   */
  public static final io.vertx.mutiny.redis.client.Command HEXISTS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HEXISTS);
  /**
   * Get the value of a hash field.
   */
  public static final io.vertx.mutiny.redis.client.Command HGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGET);
  /**
   * Get all the fields and values in a hash.
   */
  public static final io.vertx.mutiny.redis.client.Command HGETALL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGETALL);
  /**
   * Increment the integer value of a hash field by the given number.
   */
  public static final io.vertx.mutiny.redis.client.Command HINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBY);
  /**
   * Increment the float value of a hash field by the given amount.
   */
  public static final io.vertx.mutiny.redis.client.Command HINCRBYFLOAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBYFLOAT);
  /**
   * Get all the fields in a hash.
   */
  public static final io.vertx.mutiny.redis.client.Command HKEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HKEYS);
  /**
   * Get the number of fields in a hash.
   */
  public static final io.vertx.mutiny.redis.client.Command HLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HLEN);
  /**
   * Get the values of all the given hash fields.
   */
  public static final io.vertx.mutiny.redis.client.Command HMGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMGET);
  /**
   * Set multiple hash fields to multiple values.
   */
  public static final io.vertx.mutiny.redis.client.Command HMSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMSET);
  /**
   * Get one or multiple random fields from a hash.
   */
  public static final io.vertx.mutiny.redis.client.Command HRANDFIELD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HRANDFIELD);
  /**
   * Incrementally iterate hash fields and associated values.
   */
  public static final io.vertx.mutiny.redis.client.Command HSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSCAN);
  /**
   * Set the string value of a hash field.
   */
  public static final io.vertx.mutiny.redis.client.Command HSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSET);
  /**
   * Set the value of a hash field, only if the field does not exist.
   */
  public static final io.vertx.mutiny.redis.client.Command HSETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSETNX);
  /**
   * Get the length of the value of a hash field.
   */
  public static final io.vertx.mutiny.redis.client.Command HSTRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSTRLEN);
  /**
   * Get all the values in a hash.
   */
  public static final io.vertx.mutiny.redis.client.Command HVALS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HVALS);
  /**
   * Increment the integer value of a key by one.
   */
  public static final io.vertx.mutiny.redis.client.Command INCR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCR);
  /**
   * Increment the integer value of a key by the given amount.
   */
  public static final io.vertx.mutiny.redis.client.Command INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBY);
  /**
   * Increment the float value of a key by the given amount.
   */
  public static final io.vertx.mutiny.redis.client.Command INCRBYFLOAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBYFLOAT);
  /**
   * Get information and statistics about the server.
   */
  public static final io.vertx.mutiny.redis.client.Command INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INFO);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRAPPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRAPPEND);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRINDEX);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRINSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRINSERT);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRPOP);
  public static final io.vertx.mutiny.redis.client.Command JSON_ARRTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_ARRTRIM);
  public static final io.vertx.mutiny.redis.client.Command JSON_CLEAR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_CLEAR);
  public static final io.vertx.mutiny.redis.client.Command JSON_DEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_DEBUG);
  public static final io.vertx.mutiny.redis.client.Command JSON_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_DEL);
  public static final io.vertx.mutiny.redis.client.Command JSON_FORGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_FORGET);
  public static final io.vertx.mutiny.redis.client.Command JSON_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_GET);
  public static final io.vertx.mutiny.redis.client.Command JSON_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_MGET);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMINCRBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMMULTBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMMULTBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_NUMPOWBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_NUMPOWBY);
  public static final io.vertx.mutiny.redis.client.Command JSON_OBJKEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_OBJKEYS);
  public static final io.vertx.mutiny.redis.client.Command JSON_OBJLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_OBJLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_RESP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_RESP);
  public static final io.vertx.mutiny.redis.client.Command JSON_SET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_SET);
  public static final io.vertx.mutiny.redis.client.Command JSON_STRAPPEND = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_STRAPPEND);
  public static final io.vertx.mutiny.redis.client.Command JSON_STRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_STRLEN);
  public static final io.vertx.mutiny.redis.client.Command JSON_TOGGLE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_TOGGLE);
  public static final io.vertx.mutiny.redis.client.Command JSON_TYPE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.JSON_TYPE);
  /**
   * Find all keys matching the given pattern.
   */
  public static final io.vertx.mutiny.redis.client.Command KEYS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.KEYS);
  /**
   * Get the UNIX time stamp of the last successful save to disk.
   */
  public static final io.vertx.mutiny.redis.client.Command LASTSAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LASTSAVE);
  /**
   * A container for latency diagnostics commands.
   */
  public static final io.vertx.mutiny.redis.client.Command LATENCY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LATENCY);
  /**
   * Find longest common substring.
   */
  public static final io.vertx.mutiny.redis.client.Command LCS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LCS);
  /**
   * Get an element from a list by its index.
   */
  public static final io.vertx.mutiny.redis.client.Command LINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINDEX);
  /**
   * Insert an element before or after another element in a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LINSERT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINSERT);
  /**
   * Get the length of a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LLEN);
  /**
   * Pop an element from a list, push it to another list and return it.
   */
  public static final io.vertx.mutiny.redis.client.Command LMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LMOVE);
  /**
   * Pop elements from a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LMPOP);
  /**
   * Display some computer art and the Redis version.
   */
  public static final io.vertx.mutiny.redis.client.Command LOLWUT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LOLWUT);
  /**
   * Remove and get the first elements in a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPOP);
  /**
   * Return the index of matching elements on a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LPOS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPOS);
  /**
   * Prepend one or multiple elements to a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSH);
  /**
   * Prepend an element to a list, only if the list exists.
   */
  public static final io.vertx.mutiny.redis.client.Command LPUSHX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSHX);
  /**
   * Get a range of elements from a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LRANGE);
  /**
   * Remove elements from a list.
   */
  public static final io.vertx.mutiny.redis.client.Command LREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LREM);
  /**
   * Set the value of an element in a list by its index.
   */
  public static final io.vertx.mutiny.redis.client.Command LSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LSET);
  /**
   * Trim a list to the specified range.
   */
  public static final io.vertx.mutiny.redis.client.Command LTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LTRIM);
  /**
   * A container for memory diagnostics commands.
   */
  public static final io.vertx.mutiny.redis.client.Command MEMORY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MEMORY);
  /**
   * Get the values of all the given keys.
   */
  public static final io.vertx.mutiny.redis.client.Command MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MGET);
  /**
   * Atomically transfer a key from a Redis instance to another one.
   */
  public static final io.vertx.mutiny.redis.client.Command MIGRATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MIGRATE);
  /**
   * A container for module commands.
   */
  public static final io.vertx.mutiny.redis.client.Command MODULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MODULE);
  /**
   * Listen for all requests received by the server in real time.
   */
  public static final io.vertx.mutiny.redis.client.Command MONITOR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MONITOR);
  /**
   * Move a key to another database.
   */
  public static final io.vertx.mutiny.redis.client.Command MOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MOVE);
  /**
   * Set multiple keys to multiple values.
   */
  public static final io.vertx.mutiny.redis.client.Command MSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSET);
  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   */
  public static final io.vertx.mutiny.redis.client.Command MSETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSETNX);
  /**
   * Mark the start of a transaction block.
   */
  public static final io.vertx.mutiny.redis.client.Command MULTI = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MULTI);
  /**
   * A container for object introspection commands.
   */
  public static final io.vertx.mutiny.redis.client.Command OBJECT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.OBJECT);
  /**
   * Remove the expiration from a key.
   */
  public static final io.vertx.mutiny.redis.client.Command PERSIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PERSIST);
  /**
   * Set a key's time to live in milliseconds.
   */
  public static final io.vertx.mutiny.redis.client.Command PEXPIRE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIRE);
  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   */
  public static final io.vertx.mutiny.redis.client.Command PEXPIREAT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIREAT);
  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   */
  public static final io.vertx.mutiny.redis.client.Command PEXPIRETIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIRETIME);
  /**
   * Adds the specified elements to the specified HyperLogLog.
   */
  public static final io.vertx.mutiny.redis.client.Command PFADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFADD);
  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   */
  public static final io.vertx.mutiny.redis.client.Command PFCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFCOUNT);
  /**
   * Internal commands for debugging HyperLogLog values.
   */
  public static final io.vertx.mutiny.redis.client.Command PFDEBUG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFDEBUG);
  /**
   * Merge N different HyperLogLogs into a single one.
   */
  public static final io.vertx.mutiny.redis.client.Command PFMERGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFMERGE);
  /**
   * An internal command for testing HyperLogLog values.
   */
  public static final io.vertx.mutiny.redis.client.Command PFSELFTEST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFSELFTEST);
  /**
   * Ping the server.
   */
  public static final io.vertx.mutiny.redis.client.Command PING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PING);
  /**
   * Set the value and expiration in milliseconds of a key.
   */
  public static final io.vertx.mutiny.redis.client.Command PSETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSETEX);
  /**
   * Listen for messages published to channels matching the given patterns.
   */
  public static final io.vertx.mutiny.redis.client.Command PSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSUBSCRIBE);
  /**
   * Internal command used for replication.
   */
  public static final io.vertx.mutiny.redis.client.Command PSYNC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSYNC);
  /**
   * Get the time to live for a key in milliseconds.
   */
  public static final io.vertx.mutiny.redis.client.Command PTTL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PTTL);
  /**
   * Post a message to a channel.
   */
  public static final io.vertx.mutiny.redis.client.Command PUBLISH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBLISH);
  /**
   * A container for Pub/Sub commands.
   */
  public static final io.vertx.mutiny.redis.client.Command PUBSUB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBSUB);
  /**
   * Stop listening for messages posted to channels matching the given patterns.
   */
  public static final io.vertx.mutiny.redis.client.Command PUNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUNSUBSCRIBE);
  /**
   * Close the connection.
   */
  public static final io.vertx.mutiny.redis.client.Command QUIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.QUIT);
  /**
   * Return a random key from the keyspace.
   */
  public static final io.vertx.mutiny.redis.client.Command RANDOMKEY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RANDOMKEY);
  /**
   * Enables read queries for a connection to a cluster replica node.
   */
  public static final io.vertx.mutiny.redis.client.Command READONLY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READONLY);
  /**
   * Disables read queries for a connection to a cluster replica node.
   */
  public static final io.vertx.mutiny.redis.client.Command READWRITE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READWRITE);
  /**
   * Rename a key.
   */
  public static final io.vertx.mutiny.redis.client.Command RENAME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAME);
  /**
   * Rename a key, only if the new key does not exist.
   */
  public static final io.vertx.mutiny.redis.client.Command RENAMENX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAMENX);
  /**
   * An internal command for configuring the replication stream.
   */
  public static final io.vertx.mutiny.redis.client.Command REPLCONF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLCONF);
  /**
   * Make the server a replica of another instance, or promote it as master.
   */
  public static final io.vertx.mutiny.redis.client.Command REPLICAOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLICAOF);
  /**
   * Reset the connection.
   */
  public static final io.vertx.mutiny.redis.client.Command RESET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESET);
  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   */
  public static final io.vertx.mutiny.redis.client.Command RESTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE);
  /**
   * An internal command for migrating keys in a cluster.
   */
  public static final io.vertx.mutiny.redis.client.Command RESTORE_ASKING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE_ASKING);
  /**
   * Return the role of the instance in the context of replication.
   */
  public static final io.vertx.mutiny.redis.client.Command ROLE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ROLE);
  /**
   * Remove and get the last elements in a list.
   */
  public static final io.vertx.mutiny.redis.client.Command RPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOP);
  /**
   * Remove the last element in a list, prepend it to another list and return it.
   */
  public static final io.vertx.mutiny.redis.client.Command RPOPLPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOPLPUSH);
  /**
   * Append one or multiple elements to a list.
   */
  public static final io.vertx.mutiny.redis.client.Command RPUSH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSH);
  /**
   * Append an element to a list, only if the list exists.
   */
  public static final io.vertx.mutiny.redis.client.Command RPUSHX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSHX);
  /**
   * Add one or more members to a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SADD);
  /**
   * Synchronously save the dataset to disk.
   */
  public static final io.vertx.mutiny.redis.client.Command SAVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SAVE);
  /**
   * Incrementally iterate the keys space.
   */
  public static final io.vertx.mutiny.redis.client.Command SCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCAN);
  /**
   * Get the number of members in a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCARD);
  /**
   * A container for Lua scripts management commands.
   */
  public static final io.vertx.mutiny.redis.client.Command SCRIPT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCRIPT);
  /**
   * Subtract multiple sets.
   */
  public static final io.vertx.mutiny.redis.client.Command SDIFF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFF);
  /**
   * Subtract multiple sets and store the resulting set in a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SDIFFSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFFSTORE);
  /**
   * Change the selected database for the current connection.
   */
  public static final io.vertx.mutiny.redis.client.Command SELECT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SELECT);
  /**
   * Set the string value of a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SET);
  /**
   * Sets or clears the bit at offset in the string value stored at key.
   */
  public static final io.vertx.mutiny.redis.client.Command SETBIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETBIT);
  /**
   * Set the value and expiration of a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SETEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETEX);
  /**
   * Set the value of a key, only if the key does not exist.
   */
  public static final io.vertx.mutiny.redis.client.Command SETNX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETNX);
  /**
   * Overwrite part of a string at key starting at the specified offset.
   */
  public static final io.vertx.mutiny.redis.client.Command SETRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETRANGE);
  /**
   * Synchronously save the dataset to disk and then shut down the server.
   */
  public static final io.vertx.mutiny.redis.client.Command SHUTDOWN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SHUTDOWN);
  /**
   * Intersect multiple sets.
   */
  public static final io.vertx.mutiny.redis.client.Command SINTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTER);
  /**
   * Intersect multiple sets and return the cardinality of the result.
   */
  public static final io.vertx.mutiny.redis.client.Command SINTERCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTERCARD);
  /**
   * Intersect multiple sets and store the resulting set in a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SINTERSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTERSTORE);
  /**
   * Determine if a given value is a member of a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SISMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SISMEMBER);
  /**
   * Make the server a replica of another instance, or promote it as master.
   */
  public static final io.vertx.mutiny.redis.client.Command SLAVEOF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLAVEOF);
  /**
   * A container for slow log commands.
   */
  public static final io.vertx.mutiny.redis.client.Command SLOWLOG = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLOWLOG);
  /**
   * Get all the members in a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SMEMBERS = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMEMBERS);
  /**
   * Returns the membership associated with the given elements for a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SMISMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMISMEMBER);
  /**
   * Move a member from one set to another.
   */
  public static final io.vertx.mutiny.redis.client.Command SMOVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMOVE);
  /**
   * Sort the elements in a list, set or sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command SORT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SORT);
  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   */
  public static final io.vertx.mutiny.redis.client.Command SORT_RO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SORT_RO);
  /**
   * Remove and return one or multiple random members from a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SPOP);
  /**
   * Post a message to a shard channel.
   */
  public static final io.vertx.mutiny.redis.client.Command SPUBLISH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SPUBLISH);
  /**
   * Get one or multiple random members from a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SRANDMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SRANDMEMBER);
  /**
   * Remove one or more members from a set.
   */
  public static final io.vertx.mutiny.redis.client.Command SREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SREM);
  /**
   * Incrementally iterate Set elements.
   */
  public static final io.vertx.mutiny.redis.client.Command SSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SSCAN);
  /**
   * Listen for messages published to the given shard channels.
   */
  public static final io.vertx.mutiny.redis.client.Command SSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SSUBSCRIBE);
  /**
   * Get the length of the value stored in a key.
   */
  public static final io.vertx.mutiny.redis.client.Command STRLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.STRLEN);
  /**
   * Listen for messages published to the given channels.
   */
  public static final io.vertx.mutiny.redis.client.Command SUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSCRIBE);
  /**
   * Get a substring of the string stored at a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SUBSTR = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSTR);
  /**
   * Add multiple sets.
   */
  public static final io.vertx.mutiny.redis.client.Command SUNION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNION);
  /**
   * Add multiple sets and store the resulting set in a key.
   */
  public static final io.vertx.mutiny.redis.client.Command SUNIONSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNIONSTORE);
  /**
   * Stop listening for messages posted to the given shard channels.
   */
  public static final io.vertx.mutiny.redis.client.Command SUNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNSUBSCRIBE);
  /**
   * Swaps two Redis databases.
   */
  public static final io.vertx.mutiny.redis.client.Command SWAPDB = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SWAPDB);
  /**
   * Internal command used for replication.
   */
  public static final io.vertx.mutiny.redis.client.Command SYNC = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SYNC);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_ADD);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_BYRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_BYRANK);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_BYREVRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_BYREVRANK);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_CDF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_CDF);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_CREATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_CREATE);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_INFO);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_MAX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_MAX);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_MERGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_MERGE);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_MIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_MIN);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_QUANTILE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_QUANTILE);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_RANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_RANK);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_RESET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_RESET);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_REVRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_REVRANK);
  public static final io.vertx.mutiny.redis.client.Command TDIGEST_TRIMMED_MEAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TDIGEST_TRIMMED_MEAN);
  /**
   * Return the current server time.
   */
  public static final io.vertx.mutiny.redis.client.Command TIME = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIME);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_CLUSTERSET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_CLUSTERSET);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_CLUSTERSETFROMSHARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_CLUSTERSETFROMSHARD);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_HELLO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_HELLO);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_INFOCLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_INFOCLUSTER);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_INNERCOMMUNICATION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_INNERCOMMUNICATION);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_NETWORKTEST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_NETWORKTEST);
  public static final io.vertx.mutiny.redis.client.Command TIMESERIES_REFRESHCLUSTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIMESERIES_REFRESHCLUSTER);
  public static final io.vertx.mutiny.redis.client.Command TOPK_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_ADD);
  public static final io.vertx.mutiny.redis.client.Command TOPK_COUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_COUNT);
  public static final io.vertx.mutiny.redis.client.Command TOPK_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command TOPK_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_INFO);
  public static final io.vertx.mutiny.redis.client.Command TOPK_LIST = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_LIST);
  public static final io.vertx.mutiny.redis.client.Command TOPK_QUERY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_QUERY);
  public static final io.vertx.mutiny.redis.client.Command TOPK_RESERVE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOPK_RESERVE);
  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   */
  public static final io.vertx.mutiny.redis.client.Command TOUCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOUCH);
  public static final io.vertx.mutiny.redis.client.Command TS_ADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_ADD);
  public static final io.vertx.mutiny.redis.client.Command TS_ALTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_ALTER);
  public static final io.vertx.mutiny.redis.client.Command TS_CREATE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_CREATE);
  public static final io.vertx.mutiny.redis.client.Command TS_CREATERULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_CREATERULE);
  public static final io.vertx.mutiny.redis.client.Command TS_DECRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DECRBY);
  public static final io.vertx.mutiny.redis.client.Command TS_DEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DEL);
  public static final io.vertx.mutiny.redis.client.Command TS_DELETERULE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_DELETERULE);
  public static final io.vertx.mutiny.redis.client.Command TS_GET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_GET);
  public static final io.vertx.mutiny.redis.client.Command TS_INCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_INCRBY);
  public static final io.vertx.mutiny.redis.client.Command TS_INFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_INFO);
  public static final io.vertx.mutiny.redis.client.Command TS_MADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MADD);
  public static final io.vertx.mutiny.redis.client.Command TS_MGET = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MGET);
  public static final io.vertx.mutiny.redis.client.Command TS_MRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MRANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_MREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_MREVRANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_QUERYINDEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_QUERYINDEX);
  public static final io.vertx.mutiny.redis.client.Command TS_RANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_RANGE);
  public static final io.vertx.mutiny.redis.client.Command TS_REVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TS_REVRANGE);
  /**
   * Get the time to live for a key in seconds.
   */
  public static final io.vertx.mutiny.redis.client.Command TTL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TTL);
  /**
   * Determine the type stored at key.
   */
  public static final io.vertx.mutiny.redis.client.Command TYPE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TYPE);
  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   */
  public static final io.vertx.mutiny.redis.client.Command UNLINK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNLINK);
  /**
   * Stop listening for messages posted to the given channels.
   */
  public static final io.vertx.mutiny.redis.client.Command UNSUBSCRIBE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNSUBSCRIBE);
  /**
   * Forget about all watched keys.
   */
  public static final io.vertx.mutiny.redis.client.Command UNWATCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNWATCH);
  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   */
  public static final io.vertx.mutiny.redis.client.Command WAIT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WAIT);
  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   */
  public static final io.vertx.mutiny.redis.client.Command WATCH = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WATCH);
  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   */
  public static final io.vertx.mutiny.redis.client.Command XACK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XACK);
  /**
   * Appends a new entry to a stream.
   */
  public static final io.vertx.mutiny.redis.client.Command XADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XADD);
  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   */
  public static final io.vertx.mutiny.redis.client.Command XAUTOCLAIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XAUTOCLAIM);
  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   */
  public static final io.vertx.mutiny.redis.client.Command XCLAIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XCLAIM);
  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   */
  public static final io.vertx.mutiny.redis.client.Command XDEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XDEL);
  /**
   * A container for consumer groups commands.
   */
  public static final io.vertx.mutiny.redis.client.Command XGROUP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XGROUP);
  /**
   * A container for stream introspection commands.
   */
  public static final io.vertx.mutiny.redis.client.Command XINFO = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XINFO);
  /**
   * Return the number of entries in a stream.
   */
  public static final io.vertx.mutiny.redis.client.Command XLEN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XLEN);
  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   */
  public static final io.vertx.mutiny.redis.client.Command XPENDING = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XPENDING);
  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   */
  public static final io.vertx.mutiny.redis.client.Command XRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XRANGE);
  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   */
  public static final io.vertx.mutiny.redis.client.Command XREAD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREAD);
  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   */
  public static final io.vertx.mutiny.redis.client.Command XREADGROUP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREADGROUP);
  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   */
  public static final io.vertx.mutiny.redis.client.Command XREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREVRANGE);
  /**
   * An internal command for replicating stream values.
   */
  public static final io.vertx.mutiny.redis.client.Command XSETID = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XSETID);
  /**
   * Trims the stream to (approximately if '~' is passed) a certain size.
   */
  public static final io.vertx.mutiny.redis.client.Command XTRIM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XTRIM);
  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   */
  public static final io.vertx.mutiny.redis.client.Command ZADD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZADD);
  /**
   * Get the number of members in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCARD);
  /**
   * Count the members in a sorted set with scores within the given values.
   */
  public static final io.vertx.mutiny.redis.client.Command ZCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCOUNT);
  /**
   * Subtract multiple sorted sets.
   */
  public static final io.vertx.mutiny.redis.client.Command ZDIFF = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZDIFF);
  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   */
  public static final io.vertx.mutiny.redis.client.Command ZDIFFSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZDIFFSTORE);
  /**
   * Increment the score of a member in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZINCRBY = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINCRBY);
  /**
   * Intersect multiple sorted sets.
   */
  public static final io.vertx.mutiny.redis.client.Command ZINTER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTER);
  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   */
  public static final io.vertx.mutiny.redis.client.Command ZINTERCARD = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTERCARD);
  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   */
  public static final io.vertx.mutiny.redis.client.Command ZINTERSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTERSTORE);
  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   */
  public static final io.vertx.mutiny.redis.client.Command ZLEXCOUNT = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZLEXCOUNT);
  /**
   * Remove and return members with scores in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZMPOP = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZMPOP);
  /**
   * Get the score associated with the given members in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZMSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZMSCORE);
  /**
   * Remove and return members with the highest scores in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZPOPMAX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMAX);
  /**
   * Remove and return members with the lowest scores in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZPOPMIN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMIN);
  /**
   * Get one or multiple random elements from a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANDMEMBER = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANDMEMBER);
  /**
   * Return a range of members in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGE);
  /**
   * Return a range of members in a sorted set, by lexicographical range.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYLEX);
  /**
   * Return a range of members in a sorted set, by score.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYSCORE);
  /**
   * Store a range of members from sorted set into another key.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANGESTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGESTORE);
  /**
   * Determine the index of a member in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANK);
  /**
   * Remove one or more members from a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREM = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREM);
  /**
   * Remove all members in a sorted set between the given lexicographical range.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYLEX);
  /**
   * Remove all members in a sorted set within the given indexes.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYRANK);
  /**
   * Remove all members in a sorted set within the given scores.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREMRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYSCORE);
  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGE);
  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGEBYLEX = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYLEX);
  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREVRANGEBYSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYSCORE);
  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   */
  public static final io.vertx.mutiny.redis.client.Command ZREVRANK = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANK);
  /**
   * Incrementally iterate sorted sets elements and associated scores.
   */
  public static final io.vertx.mutiny.redis.client.Command ZSCAN = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCAN);
  /**
   * Get the score associated with the given member in a sorted set.
   */
  public static final io.vertx.mutiny.redis.client.Command ZSCORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCORE);
  /**
   * Add multiple sorted sets.
   */
  public static final io.vertx.mutiny.redis.client.Command ZUNION = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZUNION);
  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   */
  public static final io.vertx.mutiny.redis.client.Command ZUNIONSTORE = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZUNIONSTORE);
  public static final io.vertx.mutiny.redis.client.Command SENTINEL = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SENTINEL);
  public static  Command newInstance(io.vertx.redis.client.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
