package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<RedisAPI> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RedisAPI() {
    this.delegate = null;
  }

  @Override
  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.add/">FT.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAddAndForget(List<String> args) { 
    ftAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aggregate/">FT.AGGREGATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAggregate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAggregate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAggregate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAggregateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAggregate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAggregate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAggregate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAggregate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAggregateAndForget(List<String> args) { 
    ftAggregate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasadd/">FT.ALIASADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAliasadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAliasadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAliasaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAliasadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAliasaddAndForget(List<String> args) { 
    ftAliasadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasdel/">FT.ALIASDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAliasdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAliasdel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAliasdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAliasdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAliasdelAndForget(List<String> args) { 
    ftAliasdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.aliasupdate/">FT.ALIASUPDATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAliasupdate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAliasupdate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasupdate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAliasupdateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAliasupdate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasupdate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasupdate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasupdate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAliasupdateAndForget(List<String> args) { 
    ftAliasupdate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.alter/">FT.ALTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAlter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAlter(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlter(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAlterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAlter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlter(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlter(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlter(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAlterAndForget(List<String> args) { 
    ftAlter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.config/">FT.CONFIG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftConfig(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftConfig(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftConfig(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftConfigAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftConfig(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftConfig(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftConfig(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftConfig(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftConfigAndForget(List<String> args) { 
    ftConfig(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.create/">FT.CREATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftCreate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftCreate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftCreateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftCreate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftCreateAndForget(List<String> args) { 
    ftCreate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.cursor/">FT.CURSOR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftCursor(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftCursor(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCursor(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftCursorAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftCursor(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCursor(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCursor(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftCursor(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftCursorAndForget(List<String> args) { 
    ftCursor(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.debug/">FT.DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDebug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDebug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDebug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDebug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDebug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDebugAndForget(List<String> args) { 
    ftDebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.del/">FT.DEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDelAndForget(List<String> args) { 
    ftDel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictadd/">FT.DICTADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDictadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDictadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDictaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDictadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDictaddAndForget(List<String> args) { 
    ftDictadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdel/">FT.DICTDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDictdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDictdel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDictdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDictdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDictdelAndForget(List<String> args) { 
    ftDictdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dictdump/">FT.DICTDUMP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDictdump(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDictdump(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdump(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDictdumpAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDictdump(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdump(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdump(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDictdump(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDictdumpAndForget(List<String> args) { 
    ftDictdump(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.drop/">FT.DROP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDrop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDrop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDrop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDropAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDrop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDrop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDrop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDrop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDropAndForget(List<String> args) { 
    ftDrop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.dropindex/">FT.DROPINDEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDropindex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDropindex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDropindexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDropindex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDropindexAndForget(List<String> args) { 
    ftDropindex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explain/">FT.EXPLAIN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftExplain(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftExplain(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplain(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftExplainAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftExplain(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplain(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplain(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplain(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftExplainAndForget(List<String> args) { 
    ftExplain(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.explaincli/">FT.EXPLAINCLI</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftExplaincli(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftExplaincli(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplaincli(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftExplaincliAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftExplaincli(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplaincli(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplaincli(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftExplaincli(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftExplaincliAndForget(List<String> args) { 
    ftExplaincli(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.get/">FT.GET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftGet(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftGet(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftGet(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftGetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftGet(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftGet(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftGet(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftGet(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftGetAndForget(List<String> args) { 
    ftGet(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.info/">FT.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftInfoAndForget(List<String> args) { 
    ftInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.mget/">FT.MGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftMget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftMget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftMget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftMgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftMget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftMget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftMget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftMget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftMgetAndForget(List<String> args) { 
    ftMget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.profile/">FT.PROFILE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftProfile(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftProfile(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftProfile(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftProfileAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftProfile(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftProfile(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftProfile(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftProfile(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftProfileAndForget(List<String> args) { 
    ftProfile(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.safeadd/">FT.SAFEADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSafeadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSafeadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSafeadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSafeaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSafeadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSafeadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSafeadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSafeadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSafeaddAndForget(List<String> args) { 
    ftSafeadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.search/">FT.SEARCH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSearch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSearch(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSearch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSearchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSearch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSearch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSearch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSearch(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSearchAndForget(List<String> args) { 
    ftSearch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.spellcheck/">FT.SPELLCHECK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSpellcheck(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSpellcheck(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSpellcheck(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSpellcheckAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSpellcheck(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSpellcheck(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSpellcheck(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSpellcheck(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSpellcheckAndForget(List<String> args) { 
    ftSpellcheck(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugadd/">FT.SUGADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSugadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSugadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSugaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSugadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSugaddAndForget(List<String> args) { 
    ftSugadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugdel/">FT.SUGDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSugdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSugdel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugdel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSugdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSugdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugdel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugdel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugdel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSugdelAndForget(List<String> args) { 
    ftSugdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.sugget/">FT.SUGGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSugget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSugget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSuggetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSugget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSugget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSuggetAndForget(List<String> args) { 
    ftSugget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.suglen/">FT.SUGLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSuglen(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSuglen(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSuglen(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSuglenAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSuglen(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSuglen(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSuglen(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSuglen(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSuglenAndForget(List<String> args) { 
    ftSuglen(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synadd/">FT.SYNADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSynadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSynadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSynaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSynadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSynaddAndForget(List<String> args) { 
    ftSynadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.syndump/">FT.SYNDUMP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSyndump(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSyndump(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSyndump(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSyndumpAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSyndump(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSyndump(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSyndump(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSyndump(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSyndumpAndForget(List<String> args) { 
    ftSyndump(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.synupdate/">FT.SYNUPDATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftSynupdate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftSynupdate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynupdate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftSynupdateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftSynupdate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynupdate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynupdate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftSynupdate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftSynupdateAndForget(List<String> args) { 
    ftSynupdate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft.tagvals/">FT.TAGVALS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftTagvals(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftTagvals(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftTagvals(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftTagvalsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftTagvals(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftTagvals(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftTagvals(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftTagvals(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftTagvalsAndForget(List<String> args) { 
    ftTagvals(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasaddifnx/">FT._ALIASADDIFNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAliasaddifnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAliasaddifnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasaddifnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAliasaddifnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAliasaddifnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasaddifnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasaddifnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasaddifnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAliasaddifnxAndForget(List<String> args) { 
    ftAliasaddifnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._aliasdelifx/">FT._ALIASDELIFX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAliasdelifx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAliasdelifx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdelifx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAliasdelifxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAliasdelifx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdelifx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdelifx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAliasdelifx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAliasdelifxAndForget(List<String> args) { 
    ftAliasdelifx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._alterifnx/">FT._ALTERIFNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftAlterifnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftAlterifnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlterifnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftAlterifnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftAlterifnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlterifnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlterifnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftAlterifnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftAlterifnxAndForget(List<String> args) { 
    ftAlterifnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._createifnx/">FT._CREATEIFNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftCreateifnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftCreateifnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreateifnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftCreateifnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftCreateifnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreateifnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreateifnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftCreateifnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftCreateifnxAndForget(List<String> args) { 
    ftCreateifnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropifx/">FT._DROPIFX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDropifx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDropifx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropifx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDropifxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDropifx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropifx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropifx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropifx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDropifxAndForget(List<String> args) { 
    ftDropifx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._dropindexifx/">FT._DROPINDEXIFX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftDropindexifx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftDropindexifx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindexifx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftDropindexifxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftDropindexifx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindexifx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindexifx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftDropindexifx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftDropindexifxAndForget(List<String> args) { 
    ftDropindexifx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ft._list/">FT._LIST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ftList(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ftList(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftList(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ftListAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ftList(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ftList(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ftList(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ftList(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ftListAndForget(List<String> args) { 
    ftList(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for Access List Control commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/acl/">ACL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> acl(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.acl(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response aclAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) acl(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI aclAndForget(List<String> args) { 
    acl(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Append a value to a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/append/">APPEND</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> append(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.append(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response appendAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) append(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI appendAndForget(String arg0, String arg1) { 
    append(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sent by cluster clients after an -ASK redirect.
   * <p>
   * Redis command <a href="https://redis.io/commands/asking/">ASKING</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> asking() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.asking(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#asking}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response askingAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) asking().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#asking} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#asking}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#asking} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI askingAndForget() { 
    asking().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Authenticate to the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/auth/">AUTH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> auth(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.auth(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response authAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) auth(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI authAndForget(List<String> args) { 
    auth(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add/">BF.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfAddAndForget(List<String> args) { 
    bfAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.card/">BF.CARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfCard(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfCard(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfCard(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfCardAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfCard(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfCard(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfCard(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfCard(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfCardAndForget(List<String> args) { 
    bfCard(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug/">BF.DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfDebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfDebug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfDebug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfDebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfDebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfDebug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfDebug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfDebug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfDebugAndForget(List<String> args) { 
    bfDebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists/">BF.EXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfExists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfExists(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfExists(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfExistsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfExists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfExists(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfExists(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfExists(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfExistsAndForget(List<String> args) { 
    bfExists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info/">BF.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfInfoAndForget(List<String> args) { 
    bfInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert/">BF.INSERT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfInsert(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfInsert(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInsert(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfInsertAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfInsert(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInsert(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfInsert(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfInsert(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfInsertAndForget(List<String> args) { 
    bfInsert(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk/">BF.LOADCHUNK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfLoadchunk(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfLoadchunk(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfLoadchunk(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfLoadchunkAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfLoadchunk(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfLoadchunk(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfLoadchunk(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfLoadchunk(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfLoadchunkAndForget(List<String> args) { 
    bfLoadchunk(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd/">BF.MADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfMadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfMadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfMaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfMadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfMadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfMaddAndForget(List<String> args) { 
    bfMadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists/">BF.MEXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfMexists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfMexists(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMexists(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfMexistsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfMexists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMexists(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfMexists(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfMexists(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfMexistsAndForget(List<String> args) { 
    bfMexists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve/">BF.RESERVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfReserve(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfReserve(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfReserve(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfReserveAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfReserve(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfReserve(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfReserve(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfReserve(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfReserveAndForget(List<String> args) { 
    bfReserve(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump/">BF.SCANDUMP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bfScandump(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bfScandump(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfScandump(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bfScandumpAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bfScandump(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bfScandump(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bfScandump(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bfScandump(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bfScandumpAndForget(List<String> args) { 
    bfScandump(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Asynchronously rewrite the append-only file.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgrewriteaof/">BGREWRITEAOF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bgrewriteaof() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bgrewriteaof(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bgrewriteaofAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) bgrewriteaof().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bgrewriteaofAndForget() { 
    bgrewriteaof().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Asynchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/bgsave/">BGSAVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bgsave(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bgsave(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bgsaveAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bgsave(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bgsaveAndForget(List<String> args) { 
    bgsave(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Count set bits in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitcount/">BITCOUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitcount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitcount(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitcountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitcount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitcountAndForget(List<String> args) { 
    bitcount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield/">BITFIELD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitfield(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitfield(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitfieldAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitfield(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitfieldAndForget(List<String> args) { 
    bitfield(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings. Read-only variant of BITFIELD.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitfield_ro/">BITFIELD_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitfieldRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitfieldRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitfieldRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitfieldRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitfieldRoAndForget(List<String> args) { 
    bitfieldRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Perform bitwise operations between strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitop/">BITOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitopAndForget(List<String> args) { 
    bitop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find first bit set or clear in a string.
   * <p>
   * Redis command <a href="https://redis.io/commands/bitpos/">BITPOS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitpos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitpos(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitpos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitposAndForget(List<String> args) { 
    bitpos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmove/">BLMOVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> blmove(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blmove(arg0, arg1, arg2, arg3, arg4, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response blmoveAndAwait(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    return (io.vertx.mutiny.redis.client.Response) blmove(arg0, arg1, arg2, arg3, arg4).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI blmoveAndForget(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    blmove(arg0, arg1, arg2, arg3, arg4).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Pop elements from a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blmpop/">BLMPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> blmpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blmpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response blmpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) blmpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#blmpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#blmpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI blmpopAndForget(List<String> args) { 
    blmpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and get the first element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/blpop/">BLPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> blpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response blpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) blpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI blpopAndForget(List<String> args) { 
    blpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and get the last element in a list, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpop/">BRPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> brpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.brpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response brpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) brpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI brpopAndForget(List<String> args) { 
    brpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it; or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/brpoplpush/">BRPOPLPUSH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> brpoplpush(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.brpoplpush(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response brpoplpushAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) brpoplpush(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI brpoplpushAndForget(String arg0, String arg1, String arg2) { 
    brpoplpush(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return members with scores in a sorted set or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzmpop/">BZMPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bzmpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bzmpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzmpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bzmpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bzmpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzmpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bzmpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bzmpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bzmpopAndForget(List<String> args) { 
    bzmpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return the member with the highest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmax/">BZPOPMAX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bzpopmax(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bzpopmax(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bzpopmaxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bzpopmax(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bzpopmaxAndForget(List<String> args) { 
    bzpopmax(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return the member with the lowest score from one or more sorted sets, or block until one is available.
   * <p>
   * Redis command <a href="https://redis.io/commands/bzpopmin/">BZPOPMIN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bzpopmin(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bzpopmin(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bzpopminAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bzpopmin(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bzpopminAndForget(List<String> args) { 
    bzpopmin(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add/">CF.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfAddAndForget(List<String> args) { 
    cfAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx/">CF.ADDNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfAddnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfAddnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAddnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfAddnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfAddnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAddnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfAddnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfAddnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfAddnxAndForget(List<String> args) { 
    cfAddnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact/">CF.COMPACT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfCompact(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfCompact(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCompact(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfCompactAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfCompact(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCompact(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCompact(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfCompact(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfCompactAndForget(List<String> args) { 
    cfCompact(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count/">CF.COUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfCount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfCount(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCount(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfCountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfCount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCount(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfCount(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfCount(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfCountAndForget(List<String> args) { 
    cfCount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug/">CF.DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfDebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfDebug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDebug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfDebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfDebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDebug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDebug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfDebug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfDebugAndForget(List<String> args) { 
    cfDebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del/">CF.DEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfDel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfDel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfDelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfDel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfDel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfDel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfDelAndForget(List<String> args) { 
    cfDel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists/">CF.EXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfExists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfExists(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfExists(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfExistsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfExists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfExists(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfExists(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfExists(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfExistsAndForget(List<String> args) { 
    cfExists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info/">CF.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfInfoAndForget(List<String> args) { 
    cfInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert/">CF.INSERT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfInsert(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfInsert(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsert(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfInsertAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfInsert(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsert(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsert(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsert(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfInsertAndForget(List<String> args) { 
    cfInsert(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx/">CF.INSERTNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfInsertnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfInsertnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsertnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfInsertnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfInsertnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsertnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsertnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfInsertnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfInsertnxAndForget(List<String> args) { 
    cfInsertnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk/">CF.LOADCHUNK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfLoadchunk(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfLoadchunk(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfLoadchunk(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfLoadchunkAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfLoadchunk(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfLoadchunk(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfLoadchunk(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfLoadchunk(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfLoadchunkAndForget(List<String> args) { 
    cfLoadchunk(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists/">CF.MEXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfMexists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfMexists(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfMexists(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfMexistsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfMexists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfMexists(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfMexists(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfMexists(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfMexistsAndForget(List<String> args) { 
    cfMexists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve/">CF.RESERVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfReserve(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfReserve(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfReserve(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfReserveAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfReserve(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfReserve(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfReserve(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfReserve(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfReserveAndForget(List<String> args) { 
    cfReserve(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump/">CF.SCANDUMP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cfScandump(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cfScandump(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfScandump(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cfScandumpAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cfScandump(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cfScandump(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cfScandump(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cfScandump(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cfScandumpAndForget(List<String> args) { 
    cfScandump(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for client connection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/client/">CLIENT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> client(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.client(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response clientAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) client(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#client(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI clientAndForget(List<String> args) { 
    client(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for cluster commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/cluster/">CLUSTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cluster(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cluster(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response clusterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cluster(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI clusterAndForget(List<String> args) { 
    cluster(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby/">CMS.INCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsIncrby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsIncrby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsIncrby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsIncrbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsIncrby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsIncrby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsIncrby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsIncrby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsIncrbyAndForget(List<String> args) { 
    cmsIncrby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info/">CMS.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsInfoAndForget(List<String> args) { 
    cmsInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim/">CMS.INITBYDIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsInitbydim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsInitbydim(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbydim(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsInitbydimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsInitbydim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbydim(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbydim(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbydim(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsInitbydimAndForget(List<String> args) { 
    cmsInitbydim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob/">CMS.INITBYPROB</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsInitbyprob(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsInitbyprob(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbyprob(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsInitbyprobAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsInitbyprob(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbyprob(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbyprob(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsInitbyprob(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsInitbyprobAndForget(List<String> args) { 
    cmsInitbyprob(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge/">CMS.MERGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsMerge(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsMerge(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsMerge(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsMergeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsMerge(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsMerge(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsMerge(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsMerge(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsMergeAndForget(List<String> args) { 
    cmsMerge(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query/">CMS.QUERY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cmsQuery(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cmsQuery(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsQuery(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response cmsQueryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cmsQuery(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsQuery(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cmsQuery(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cmsQuery(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI cmsQueryAndForget(List<String> args) { 
    cmsQuery(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get array of Redis command details.
   * <p>
   * Redis command <a href="https://redis.io/commands/command/">COMMAND</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> command(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.command(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response commandAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) command(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#command(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI commandAndForget(List<String> args) { 
    command(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for server configuration commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/config/">CONFIG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> config(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.config(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response configAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) config(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#config(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI configAndForget(List<String> args) { 
    config(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Copy a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/copy/">COPY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> copy(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.copy(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response copyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) copy(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI copyAndForget(List<String> args) { 
    copy(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the number of keys in the selected database.
   * <p>
   * Redis command <a href="https://redis.io/commands/dbsize/">DBSIZE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> dbsize() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.dbsize(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response dbsizeAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) dbsize().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI dbsizeAndForget() { 
    dbsize().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for debugging commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/debug/">DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> debug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.debug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response debugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) debug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI debugAndForget(List<String> args) { 
    debug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Decrement the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/decr/">DECR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> decr(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.decr(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response decrAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) decr(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI decrAndForget(String arg0) { 
    decr(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Decrement the integer value of a key by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/decrby/">DECRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> decrby(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.decrby(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response decrbyAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) decrby(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI decrbyAndForget(String arg0, String arg1) { 
    decrby(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Delete a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/del/">DEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> del(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.del(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response delAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) del(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#del(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI delAndForget(List<String> args) { 
    del(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Discard all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/discard/">DISCARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> discard() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.discard(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#discard}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response discardAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) discard().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#discard} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#discard}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#discard} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI discardAndForget() { 
    discard().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * <p>
   * Redis command <a href="https://redis.io/commands/dump/">DUMP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> dump(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.dump(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response dumpAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) dump(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI dumpAndForget(String arg0) { 
    dump(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Echo the given string.
   * <p>
   * Redis command <a href="https://redis.io/commands/echo/">ECHO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> echo(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.echo(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response echoAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) echo(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI echoAndForget(String arg0) { 
    echo(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval/">EVAL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> eval(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.eval(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) eval(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalAndForget(List<String> args) { 
    eval(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/eval_ro/">EVAL_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> evalRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.evalRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) evalRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#evalRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#evalRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalRoAndForget(List<String> args) { 
    evalRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha/">EVALSHA</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> evalsha(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.evalsha(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalshaAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) evalsha(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalshaAndForget(List<String> args) { 
    evalsha(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute a read-only Lua script server side.
   * <p>
   * Redis command <a href="https://redis.io/commands/evalsha_ro/">EVALSHA_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> evalshaRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.evalshaRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalshaRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalshaRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) evalshaRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalshaRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#evalshaRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#evalshaRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalshaRoAndForget(List<String> args) { 
    evalshaRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute all commands issued after MULTI.
   * <p>
   * Redis command <a href="https://redis.io/commands/exec/">EXEC</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> exec() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.exec(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exec}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response execAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) exec().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exec} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#exec}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#exec} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI execAndForget() { 
    exec().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine if a key exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/exists/">EXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> exists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.exists(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response existsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) exists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI existsAndForget(List<String> args) { 
    exists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set a key&#x27;s time to live in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/expire/">EXPIRE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> expire(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.expire(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response expireAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) expire(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#expire(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI expireAndForget(List<String> args) { 
    expire(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp.
   * <p>
   * Redis command <a href="https://redis.io/commands/expireat/">EXPIREAT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> expireat(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.expireat(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response expireatAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) expireat(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI expireatAndForget(List<String> args) { 
    expireat(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the expiration Unix timestamp for a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/expiretime/">EXPIRETIME</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> expiretime(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.expiretime(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expiretime(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response expiretimeAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) expiretime(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expiretime(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#expiretime(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#expiretime(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI expiretimeAndForget(String arg0) { 
    expiretime(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Start a coordinated failover between this server and one of its replicas.
   * <p>
   * Redis command <a href="https://redis.io/commands/failover/">FAILOVER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> failover(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.failover(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response failoverAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) failover(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI failoverAndForget(List<String> args) { 
    failover(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Invoke a function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall/">FCALL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> fcall(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.fcall(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#fcall(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response fcallAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) fcall(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#fcall(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#fcall(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#fcall(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI fcallAndForget(List<String> args) { 
    fcall(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Invoke a read-only function.
   * <p>
   * Redis command <a href="https://redis.io/commands/fcall_ro/">FCALL_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> fcallRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.fcallRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#fcallRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response fcallRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) fcallRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#fcallRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#fcallRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#fcallRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI fcallRoAndForget(List<String> args) { 
    fcallRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all keys from all databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushall/">FLUSHALL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> flushall(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.flushall(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response flushallAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) flushall(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI flushallAndForget(List<String> args) { 
    flushall(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all keys from the current database.
   * <p>
   * Redis command <a href="https://redis.io/commands/flushdb/">FLUSHDB</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> flushdb(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.flushdb(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response flushdbAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) flushdb(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI flushdbAndForget(List<String> args) { 
    flushdb(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for function commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/function/">FUNCTION</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> function(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.function(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#function(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response functionAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) function(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#function(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#function(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#function(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI functionAndForget(List<String> args) { 
    function(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/geoadd/">GEOADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geoadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geoadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geoaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geoadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geoaddAndForget(List<String> args) { 
    geoadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the distance between two members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geodist/">GEODIST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geodist(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geodist(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geodistAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geodist(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geodistAndForget(List<String> args) { 
    geodist(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns members of a geospatial index as standard geohash strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/geohash/">GEOHASH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geohash(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geohash(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geohashAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geohash(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geohashAndForget(List<String> args) { 
    geohash(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns longitude and latitude of members of a geospatial index.
   * <p>
   * Redis command <a href="https://redis.io/commands/geopos/">GEOPOS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geopos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geopos(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geoposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geopos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geoposAndForget(List<String> args) { 
    geopos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius/">GEORADIUS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadius(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadius(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadius(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusAndForget(List<String> args) { 
    georadius(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A read-only variant for GEORADIUS.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadius_ro/">GEORADIUS_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusRoAndForget(List<String> args) { 
    georadiusRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember/">GEORADIUSBYMEMBER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusbymember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusbymember(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusbymemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusbymember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusbymemberAndForget(List<String> args) { 
    georadiusbymember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A read-only variant for GEORADIUSBYMEMBER.
   * <p>
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro/">GEORADIUSBYMEMBER_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusbymemberRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusbymemberRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusbymemberRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusbymemberRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusbymemberRoAndForget(List<String> args) { 
    georadiusbymemberRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearch/">GEOSEARCH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geosearch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geosearch(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geosearchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geosearch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geosearchAndForget(List<String> args) { 
    geosearch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Query a sorted set representing a geospatial index to fetch members inside an area of a box or a circle, and store the result in another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/geosearchstore/">GEOSEARCHSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geosearchstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geosearchstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geosearchstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geosearchstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geosearchstoreAndForget(List<String> args) { 
    geosearchstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/get/">GET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> get(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.get(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) get(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getAndForget(String arg0) { 
    get(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the bit value at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getbit/">GETBIT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getbit(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getbit(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getbitAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) getbit(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getbitAndForget(String arg0, String arg1) { 
    getbit(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the value of a key and delete the key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getdel/">GETDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getdel(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getdel(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getdelAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) getdel(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getdelAndForget(String arg0) { 
    getdel(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the value of a key and optionally set its expiration.
   * <p>
   * Redis command <a href="https://redis.io/commands/getex/">GETEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) getex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getexAndForget(List<String> args) { 
    getex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/getrange/">GETRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getrange(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) getrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getrangeAndForget(String arg0, String arg1, String arg2) { 
    getrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the string value of a key and return its old value.
   * <p>
   * Redis command <a href="https://redis.io/commands/getset/">GETSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getset(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getset(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getsetAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) getset(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getsetAndForget(String arg0, String arg1) { 
    getset(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.bulk/">GRAPH.BULK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphBulk(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphBulk(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphBulk(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphBulkAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphBulk(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphBulk(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphBulk(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphBulk(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphBulkAndForget(List<String> args) { 
    graphBulk(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.config/">GRAPH.CONFIG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphConfig(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphConfig(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphConfig(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphConfigAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphConfig(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphConfig(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphConfig(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphConfig(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphConfigAndForget(List<String> args) { 
    graphConfig(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.debug/">GRAPH.DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphDebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphDebug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDebug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphDebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphDebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDebug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDebug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphDebug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphDebugAndForget(List<String> args) { 
    graphDebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.delete/">GRAPH.DELETE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphDelete(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphDelete(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDelete(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphDeleteAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphDelete(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDelete(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphDelete(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphDelete(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphDeleteAndForget(List<String> args) { 
    graphDelete(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.explain/">GRAPH.EXPLAIN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphExplain(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphExplain(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphExplain(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphExplainAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphExplain(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphExplain(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphExplain(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphExplain(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphExplainAndForget(List<String> args) { 
    graphExplain(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.list/">GRAPH.LIST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphList(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphList(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphList(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphListAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphList(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphList(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphList(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphList(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphListAndForget(List<String> args) { 
    graphList(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.profile/">GRAPH.PROFILE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphProfile(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphProfile(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphProfile(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphProfileAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphProfile(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphProfile(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphProfile(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphProfile(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphProfileAndForget(List<String> args) { 
    graphProfile(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.query/">GRAPH.QUERY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphQuery(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphQuery(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphQuery(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphQueryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphQuery(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphQuery(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphQuery(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphQuery(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphQueryAndForget(List<String> args) { 
    graphQuery(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.ro_query/">GRAPH.RO_QUERY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphRoQuery(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphRoQuery(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphRoQuery(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphRoQueryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphRoQuery(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphRoQuery(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphRoQuery(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphRoQuery(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphRoQueryAndForget(List<String> args) { 
    graphRoQuery(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.slowlog/">GRAPH.SLOWLOG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> graphSlowlog(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.graphSlowlog(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphSlowlog(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response graphSlowlogAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) graphSlowlog(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#graphSlowlog(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#graphSlowlog(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#graphSlowlog(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI graphSlowlogAndForget(List<String> args) { 
    graphSlowlog(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Delete one or more hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hdel/">HDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hdel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hdelAndForget(List<String> args) { 
    hdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Handshake with Redis.
   * <p>
   * Redis command <a href="https://redis.io/commands/hello/">HELLO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hello(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hello(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response helloAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hello(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI helloAndForget(List<String> args) { 
    hello(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine if a hash field exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/hexists/">HEXISTS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hexists(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hexists(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hexistsAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hexists(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hexistsAndForget(String arg0, String arg1) { 
    hexists(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hget/">HGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hget(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hget(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hgetAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hget(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hgetAndForget(String arg0, String arg1) { 
    hget(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get all the fields and values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hgetall/">HGETALL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hgetall(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hgetall(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hgetallAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hgetall(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hgetallAndForget(String arg0) { 
    hgetall(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the integer value of a hash field by the given number.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrby/">HINCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hincrby(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hincrby(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hincrbyAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hincrby(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hincrbyAndForget(String arg0, String arg1, String arg2) { 
    hincrby(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the float value of a hash field by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/hincrbyfloat/">HINCRBYFLOAT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hincrbyfloat(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hincrbyfloat(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hincrbyfloatAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hincrbyfloat(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hincrbyfloatAndForget(String arg0, String arg1, String arg2) { 
    hincrbyfloat(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get all the fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hkeys/">HKEYS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hkeys(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hkeys(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hkeysAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hkeys(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hkeysAndForget(String arg0) { 
    hkeys(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the number of fields in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hlen/">HLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hlen(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hlenAndForget(String arg0) { 
    hlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the values of all the given hash fields.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmget/">HMGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hmget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hmget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hmgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hmget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hmgetAndForget(List<String> args) { 
    hmget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set multiple hash fields to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hmset/">HMSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hmset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hmset(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hmsetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hmset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hmsetAndForget(List<String> args) { 
    hmset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get one or multiple random fields from a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hrandfield/">HRANDFIELD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hrandfield(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hrandfield(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hrandfieldAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hrandfield(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hrandfieldAndForget(List<String> args) { 
    hrandfield(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Incrementally iterate hash fields and associated values.
   * <p>
   * Redis command <a href="https://redis.io/commands/hscan/">HSCAN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hscan(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hscanAndForget(List<String> args) { 
    hscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the string value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hset/">HSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hset(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hsetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hsetAndForget(List<String> args) { 
    hset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the value of a hash field, only if the field does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/hsetnx/">HSETNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hsetnx(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hsetnx(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hsetnxAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hsetnx(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hsetnxAndForget(String arg0, String arg1, String arg2) { 
    hsetnx(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the length of the value of a hash field.
   * <p>
   * Redis command <a href="https://redis.io/commands/hstrlen/">HSTRLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hstrlen(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hstrlen(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hstrlenAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hstrlen(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hstrlenAndForget(String arg0, String arg1) { 
    hstrlen(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get all the values in a hash.
   * <p>
   * Redis command <a href="https://redis.io/commands/hvals/">HVALS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hvals(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hvals(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hvalsAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hvals(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hvalsAndForget(String arg0) { 
    hvals(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the integer value of a key by one.
   * <p>
   * Redis command <a href="https://redis.io/commands/incr/">INCR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incr(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incr(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) incr(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrAndForget(String arg0) { 
    incr(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the integer value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrby/">INCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incrby(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incrby(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrbyAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) incrby(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrbyAndForget(String arg0, String arg1) { 
    incrby(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the float value of a key by the given amount.
   * <p>
   * Redis command <a href="https://redis.io/commands/incrbyfloat/">INCRBYFLOAT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incrbyfloat(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incrbyfloat(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrbyfloatAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) incrbyfloat(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrbyfloatAndForget(String arg0, String arg1) { 
    incrbyfloat(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get information and statistics about the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/info/">INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> info(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.info(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response infoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) info(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#info(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI infoAndForget(List<String> args) { 
    info(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend/">JSON.ARRAPPEND</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrappend(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrappend(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrappend(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrappendAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrappend(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrappend(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrappend(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrappend(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrappendAndForget(List<String> args) { 
    jsonArrappend(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex/">JSON.ARRINDEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrindex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrindex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrindex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrindexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrindex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrindex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrindex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrindex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrindexAndForget(List<String> args) { 
    jsonArrindex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert/">JSON.ARRINSERT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrinsert(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrinsert(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrinsert(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrinsertAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrinsert(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrinsert(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrinsert(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrinsert(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrinsertAndForget(List<String> args) { 
    jsonArrinsert(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen/">JSON.ARRLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrlen(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrlen(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrlen(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrlenAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrlen(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrlen(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrlen(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrlen(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrlenAndForget(List<String> args) { 
    jsonArrlen(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop/">JSON.ARRPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrpopAndForget(List<String> args) { 
    jsonArrpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim/">JSON.ARRTRIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonArrtrim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonArrtrim(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrtrim(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonArrtrimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonArrtrim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrtrim(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrtrim(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonArrtrim(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonArrtrimAndForget(List<String> args) { 
    jsonArrtrim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear/">JSON.CLEAR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonClear(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonClear(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonClear(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonClearAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonClear(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonClear(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonClear(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonClear(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonClearAndForget(List<String> args) { 
    jsonClear(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug/">JSON.DEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonDebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonDebug(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDebug(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonDebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonDebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDebug(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDebug(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDebug(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonDebugAndForget(List<String> args) { 
    jsonDebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del/">JSON.DEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonDel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonDel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonDelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonDel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonDel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonDelAndForget(List<String> args) { 
    jsonDel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget/">JSON.FORGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonForget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonForget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonForget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonForgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonForget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonForget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonForget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonForget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonForgetAndForget(List<String> args) { 
    jsonForget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get/">JSON.GET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonGet(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonGet(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonGet(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonGetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonGet(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonGet(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonGet(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonGet(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonGetAndForget(List<String> args) { 
    jsonGet(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget/">JSON.MGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonMget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonMget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonMget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonMgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonMget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonMget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonMget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonMget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonMgetAndForget(List<String> args) { 
    jsonMget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby/">JSON.NUMINCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonNumincrby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonNumincrby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumincrby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonNumincrbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonNumincrby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumincrby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumincrby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumincrby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonNumincrbyAndForget(List<String> args) { 
    jsonNumincrby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby/">JSON.NUMMULTBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonNummultby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonNummultby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNummultby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonNummultbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonNummultby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNummultby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNummultby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNummultby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonNummultbyAndForget(List<String> args) { 
    jsonNummultby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby/">JSON.NUMPOWBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonNumpowby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonNumpowby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumpowby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonNumpowbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonNumpowby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumpowby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumpowby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonNumpowby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonNumpowbyAndForget(List<String> args) { 
    jsonNumpowby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys/">JSON.OBJKEYS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonObjkeys(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonObjkeys(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjkeys(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonObjkeysAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonObjkeys(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjkeys(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjkeys(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjkeys(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonObjkeysAndForget(List<String> args) { 
    jsonObjkeys(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen/">JSON.OBJLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonObjlen(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonObjlen(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjlen(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonObjlenAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonObjlen(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjlen(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjlen(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonObjlen(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonObjlenAndForget(List<String> args) { 
    jsonObjlen(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp/">JSON.RESP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonResp(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonResp(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonResp(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonRespAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonResp(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonResp(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonResp(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonResp(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonRespAndForget(List<String> args) { 
    jsonResp(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set/">JSON.SET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonSet(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonSet(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonSet(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonSetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonSet(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonSet(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonSet(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonSet(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonSetAndForget(List<String> args) { 
    jsonSet(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend/">JSON.STRAPPEND</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonStrappend(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonStrappend(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrappend(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonStrappendAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonStrappend(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrappend(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrappend(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrappend(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonStrappendAndForget(List<String> args) { 
    jsonStrappend(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen/">JSON.STRLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonStrlen(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonStrlen(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrlen(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonStrlenAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonStrlen(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrlen(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrlen(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonStrlen(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonStrlenAndForget(List<String> args) { 
    jsonStrlen(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle/">JSON.TOGGLE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonToggle(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonToggle(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonToggle(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonToggleAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonToggle(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonToggle(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonToggle(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonToggle(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonToggleAndForget(List<String> args) { 
    jsonToggle(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type/">JSON.TYPE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> jsonType(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jsonType(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonType(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response jsonTypeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) jsonType(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonType(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#jsonType(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#jsonType(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI jsonTypeAndForget(List<String> args) { 
    jsonType(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find all keys matching the given pattern.
   * <p>
   * Redis command <a href="https://redis.io/commands/keys/">KEYS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> keys(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.keys(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response keysAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) keys(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI keysAndForget(String arg0) { 
    keys(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/lastsave/">LASTSAVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lastsave() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lastsave(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lastsaveAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) lastsave().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lastsaveAndForget() { 
    lastsave().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for latency diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/latency/">LATENCY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> latency(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.latency(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response latencyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) latency(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI latencyAndForget(List<String> args) { 
    latency(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Find longest common substring.
   * <p>
   * Redis command <a href="https://redis.io/commands/lcs/">LCS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lcs(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lcs(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lcs(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lcsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lcs(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lcs(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lcs(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lcs(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lcsAndForget(List<String> args) { 
    lcs(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get an element from a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lindex/">LINDEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lindex(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lindex(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lindexAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) lindex(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lindexAndForget(String arg0, String arg1) { 
    lindex(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert an element before or after another element in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/linsert/">LINSERT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> linsert(String arg0, String arg1, String arg2, String arg3) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.linsert(arg0, arg1, arg2, arg3, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response linsertAndAwait(String arg0, String arg1, String arg2, String arg3) { 
    return (io.vertx.mutiny.redis.client.Response) linsert(arg0, arg1, arg2, arg3).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI linsertAndForget(String arg0, String arg1, String arg2, String arg3) { 
    linsert(arg0, arg1, arg2, arg3).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the length of a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/llen/">LLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> llen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.llen(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response llenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) llen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI llenAndForget(String arg0) { 
    llen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Pop an element from a list, push it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmove/">LMOVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lmove(String arg0, String arg1, String arg2, String arg3) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lmove(arg0, arg1, arg2, arg3, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lmoveAndAwait(String arg0, String arg1, String arg2, String arg3) { 
    return (io.vertx.mutiny.redis.client.Response) lmove(arg0, arg1, arg2, arg3).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lmoveAndForget(String arg0, String arg1, String arg2, String arg3) { 
    lmove(arg0, arg1, arg2, arg3).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Pop elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lmpop/">LMPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lmpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lmpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lmpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lmpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lmpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lmpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lmpopAndForget(List<String> args) { 
    lmpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Display some computer art and the Redis version.
   * <p>
   * Redis command <a href="https://redis.io/commands/lolwut/">LOLWUT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lolwut(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lolwut(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lolwutAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lolwut(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lolwutAndForget(List<String> args) { 
    lolwut(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and get the first elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpop/">LPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpopAndForget(List<String> args) { 
    lpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the index of matching elements on a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpos/">LPOS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpos(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lposAndForget(List<String> args) { 
    lpos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Prepend one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpush/">LPUSH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpush(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpush(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpushAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpush(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpushAndForget(List<String> args) { 
    lpush(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Prepend an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/lpushx/">LPUSHX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpushx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpushx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpushxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpushx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpushxAndForget(List<String> args) { 
    lpushx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get a range of elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrange/">LRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lrange(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lrangeAndForget(String arg0, String arg1, String arg2) { 
    lrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove elements from a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/lrem/">LREM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lrem(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lrem(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lremAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lrem(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lremAndForget(String arg0, String arg1, String arg2) { 
    lrem(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the value of an element in a list by its index.
   * <p>
   * Redis command <a href="https://redis.io/commands/lset/">LSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lset(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lset(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lsetAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lset(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lsetAndForget(String arg0, String arg1, String arg2) { 
    lset(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Trim a list to the specified range.
   * <p>
   * Redis command <a href="https://redis.io/commands/ltrim/">LTRIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ltrim(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ltrim(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ltrimAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) ltrim(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ltrimAndForget(String arg0, String arg1, String arg2) { 
    ltrim(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for memory diagnostics commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/memory/">MEMORY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> memory(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.memory(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response memoryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) memory(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI memoryAndForget(List<String> args) { 
    memory(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the values of all the given keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/mget/">MGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> mget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.mget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response mgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) mget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI mgetAndForget(List<String> args) { 
    mget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * <p>
   * Redis command <a href="https://redis.io/commands/migrate/">MIGRATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> migrate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.migrate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response migrateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) migrate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI migrateAndForget(List<String> args) { 
    migrate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for module commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/module/">MODULE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> module(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.module(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response moduleAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) module(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#module(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI moduleAndForget(List<String> args) { 
    module(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Listen for all requests received by the server in real time.
   * <p>
   * Redis command <a href="https://redis.io/commands/monitor/">MONITOR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> monitor() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.monitor(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response monitorAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) monitor().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#monitor} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI monitorAndForget() { 
    monitor().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Move a key to another database.
   * <p>
   * Redis command <a href="https://redis.io/commands/move/">MOVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> move(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.move(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response moveAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) move(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI moveAndForget(String arg0, String arg1) { 
    move(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set multiple keys to multiple values.
   * <p>
   * Redis command <a href="https://redis.io/commands/mset/">MSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> mset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.mset(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response msetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) mset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI msetAndForget(List<String> args) { 
    mset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/msetnx/">MSETNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> msetnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.msetnx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response msetnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) msetnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI msetnxAndForget(List<String> args) { 
    msetnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Mark the start of a transaction block.
   * <p>
   * Redis command <a href="https://redis.io/commands/multi/">MULTI</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> multi() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.multi(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#multi}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response multiAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) multi().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#multi} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#multi}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#multi} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI multiAndForget() { 
    multi().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for object introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/object/">OBJECT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> object(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.object(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response objectAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) object(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#object(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI objectAndForget(List<String> args) { 
    object(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove the expiration from a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/persist/">PERSIST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> persist(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.persist(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response persistAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) persist(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI persistAndForget(String arg0) { 
    persist(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set a key&#x27;s time to live in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpire/">PEXPIRE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pexpire(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pexpire(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pexpireAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pexpire(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pexpireAndForget(List<String> args) { 
    pexpire(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpireat/">PEXPIREAT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pexpireat(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pexpireat(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pexpireatAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pexpireat(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pexpireatAndForget(List<String> args) { 
    pexpireat(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the expiration Unix timestamp for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pexpiretime/">PEXPIRETIME</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pexpiretime(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pexpiretime(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpiretime(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pexpiretimeAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) pexpiretime(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpiretime(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpiretime(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pexpiretime(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pexpiretimeAndForget(String arg0) { 
    pexpiretime(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfadd/">PFADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfaddAndForget(List<String> args) { 
    pfadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * <p>
   * Redis command <a href="https://redis.io/commands/pfcount/">PFCOUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfcount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfcount(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfcountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfcount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfcountAndForget(List<String> args) { 
    pfcount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Internal commands for debugging HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfdebug/">PFDEBUG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfdebug(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfdebug(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfdebugAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) pfdebug(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfdebugAndForget(String arg0, String arg1) { 
    pfdebug(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfmerge/">PFMERGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfmerge(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfmerge(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfmergeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfmerge(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfmergeAndForget(List<String> args) { 
    pfmerge(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * An internal command for testing HyperLogLog values.
   * <p>
   * Redis command <a href="https://redis.io/commands/pfselftest/">PFSELFTEST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfselftest() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfselftest(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfselftestAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) pfselftest().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfselftestAndForget() { 
    pfselftest().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Ping the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/ping/">PING</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ping(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ping(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ping(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pingAndForget(List<String> args) { 
    ping(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the value and expiration in milliseconds of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/psetex/">PSETEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psetex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psetex(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psetexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) psetex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psetexAndForget(String arg0, String arg1, String arg2) { 
    psetex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Listen for messages published to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/psubscribe/">PSUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psubscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) psubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psubscribeAndForget(List<String> args) { 
    psubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/psync/">PSYNC</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psync(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psync(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psyncAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) psync(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psyncAndForget(List<String> args) { 
    psync(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the time to live for a key in milliseconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/pttl/">PTTL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pttl(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pttl(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pttlAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) pttl(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pttlAndForget(String arg0) { 
    pttl(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Post a message to a channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/publish/">PUBLISH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> publish(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.publish(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response publishAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) publish(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI publishAndForget(String arg0, String arg1) { 
    publish(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for Pub/Sub commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/pubsub/">PUBSUB</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pubsub(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pubsub(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pubsubAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pubsub(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pubsubAndForget(List<String> args) { 
    pubsub(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns.
   * <p>
   * Redis command <a href="https://redis.io/commands/punsubscribe/">PUNSUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> punsubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.punsubscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response punsubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) punsubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI punsubscribeAndForget(List<String> args) { 
    punsubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/quit/">QUIT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> quit(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.quit(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#quit(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response quitAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) quit(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#quit(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#quit(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#quit(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI quitAndForget(List<String> args) { 
    quit(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a random key from the keyspace.
   * <p>
   * Redis command <a href="https://redis.io/commands/randomkey/">RANDOMKEY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> randomkey() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.randomkey(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response randomkeyAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) randomkey().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI randomkeyAndForget() { 
    randomkey().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Enables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readonly/">READONLY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> readonly() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.readonly(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response readonlyAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) readonly().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#readonly} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI readonlyAndForget() { 
    readonly().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Disables read queries for a connection to a cluster replica node.
   * <p>
   * Redis command <a href="https://redis.io/commands/readwrite/">READWRITE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> readwrite() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.readwrite(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response readwriteAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) readwrite().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI readwriteAndForget() { 
    readwrite().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Rename a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/rename/">RENAME</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rename(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rename(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response renameAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) rename(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI renameAndForget(String arg0, String arg1) { 
    rename(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Rename a key, only if the new key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/renamenx/">RENAMENX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> renamenx(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.renamenx(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response renamenxAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) renamenx(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI renamenxAndForget(String arg0, String arg1) { 
    renamenx(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * An internal command for configuring the replication stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/replconf/">REPLCONF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> replconf(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.replconf(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response replconfAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) replconf(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI replconfAndForget(List<String> args) { 
    replconf(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/replicaof/">REPLICAOF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> replicaof(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.replicaof(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response replicaofAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) replicaof(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI replicaofAndForget(String arg0, String arg1) { 
    replicaof(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Reset the connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/reset/">RESET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> reset() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.reset(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#reset}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response resetAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) reset().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#reset} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#reset}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#reset} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI resetAndForget() { 
    reset().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore/">RESTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> restore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.restore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response restoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) restore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI restoreAndForget(List<String> args) { 
    restore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * An internal command for migrating keys in a cluster.
   * <p>
   * Redis command <a href="https://redis.io/commands/restore asking/">RESTORE-ASKING</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> restoreAsking(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.restoreAsking(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response restoreAskingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) restoreAsking(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI restoreAskingAndForget(List<String> args) { 
    restoreAsking(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the role of the instance in the context of replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/role/">ROLE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> role() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.role(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#role}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response roleAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) role().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#role} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#role}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#role} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI roleAndForget() { 
    role().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and get the last elements in a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpop/">RPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpopAndForget(List<String> args) { 
    rpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove the last element in a list, prepend it to another list and return it.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpoplpush/">RPOPLPUSH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpoplpush(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpoplpush(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpoplpushAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) rpoplpush(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpoplpushAndForget(String arg0, String arg1) { 
    rpoplpush(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Append one or multiple elements to a list.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpush/">RPUSH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpush(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpush(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpushAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpush(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpushAndForget(List<String> args) { 
    rpush(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Append an element to a list, only if the list exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/rpushx/">RPUSHX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpushx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpushx(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpushxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpushx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpushxAndForget(List<String> args) { 
    rpushx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add one or more members to a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sadd/">SADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response saddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI saddAndForget(List<String> args) { 
    sadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Synchronously save the dataset to disk.
   * <p>
   * Redis command <a href="https://redis.io/commands/save/">SAVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> save() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.save(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#save}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response saveAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) save().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#save} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#save}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#save} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI saveAndForget() { 
    save().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Incrementally iterate the keys space.
   * <p>
   * Redis command <a href="https://redis.io/commands/scan/">SCAN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> scan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.scan(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) scan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scanAndForget(List<String> args) { 
    scan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the number of members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/scard/">SCARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> scard(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.scard(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scardAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) scard(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scardAndForget(String arg0) { 
    scard(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for Lua scripts management commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/script/">SCRIPT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> script(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.script(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scriptAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) script(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#script(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scriptAndForget(List<String> args) { 
    script(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subtract multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiff/">SDIFF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sdiff(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sdiff(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sdiffAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sdiff(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sdiffAndForget(List<String> args) { 
    sdiff(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sdiffstore/">SDIFFSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sdiffstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sdiffstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sdiffstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sdiffstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sdiffstoreAndForget(List<String> args) { 
    sdiffstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Change the selected database for the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/select/">SELECT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> select(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.select(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response selectAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) select(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI selectAndForget(String arg0) { 
    select(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the string value of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/set/">SET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> set(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.set(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) set(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#set(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setAndForget(List<String> args) { 
    set(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setbit/">SETBIT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setbit(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setbit(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setbitAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setbit(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setbitAndForget(String arg0, String arg1, String arg2) { 
    setbit(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the value and expiration of a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/setex/">SETEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setex(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setexAndForget(String arg0, String arg1, String arg2) { 
    setex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set the value of a key, only if the key does not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/setnx/">SETNX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setnx(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setnx(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setnxAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) setnx(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setnxAndForget(String arg0, String arg1) { 
    setnx(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset.
   * <p>
   * Redis command <a href="https://redis.io/commands/setrange/">SETRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setrange(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setrangeAndForget(String arg0, String arg1, String arg2) { 
    setrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Synchronously save the dataset to disk and then shut down the server.
   * <p>
   * Redis command <a href="https://redis.io/commands/shutdown/">SHUTDOWN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> shutdown(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.shutdown(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response shutdownAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) shutdown(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI shutdownAndForget(List<String> args) { 
    shutdown(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinter/">SINTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sinter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sinter(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sinterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sinter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sinterAndForget(List<String> args) { 
    sinter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/sintercard/">SINTERCARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sintercard(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sintercard(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sintercard(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sintercardAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sintercard(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sintercard(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sintercard(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sintercard(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sintercardAndForget(List<String> args) { 
    sintercard(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sinterstore/">SINTERSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sinterstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sinterstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sinterstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sinterstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sinterstoreAndForget(List<String> args) { 
    sinterstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine if a given value is a member of a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sismember/">SISMEMBER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sismember(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sismember(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sismemberAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) sismember(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sismemberAndForget(String arg0, String arg1) { 
    sismember(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Make the server a replica of another instance, or promote it as master.
   * <p>
   * Redis command <a href="https://redis.io/commands/slaveof/">SLAVEOF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> slaveof(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.slaveof(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response slaveofAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) slaveof(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI slaveofAndForget(String arg0, String arg1) { 
    slaveof(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for slow log commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/slowlog/">SLOWLOG</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> slowlog(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.slowlog(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response slowlogAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) slowlog(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI slowlogAndForget(List<String> args) { 
    slowlog(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get all the members in a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smembers/">SMEMBERS</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smembers(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smembers(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smembersAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) smembers(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smembersAndForget(String arg0) { 
    smembers(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the membership associated with the given elements for a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/smismember/">SMISMEMBER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smismember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smismember(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smismemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) smismember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smismemberAndForget(List<String> args) { 
    smismember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Move a member from one set to another.
   * <p>
   * Redis command <a href="https://redis.io/commands/smove/">SMOVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smove(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smove(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smoveAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) smove(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smoveAndForget(String arg0, String arg1, String arg2) { 
    smove(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort/">SORT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sort(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sort(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sortAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sort(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sortAndForget(List<String> args) { 
    sort(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set. Read-only variant of SORT.
   * <p>
   * Redis command <a href="https://redis.io/commands/sort_ro/">SORT_RO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sortRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sortRo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sortRo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sortRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sortRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sortRo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sortRo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sortRo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sortRoAndForget(List<String> args) { 
    sortRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/spop/">SPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> spop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.spop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response spopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) spop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI spopAndForget(List<String> args) { 
    spop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Post a message to a shard channel.
   * <p>
   * Redis command <a href="https://redis.io/commands/spublish/">SPUBLISH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> spublish(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.spublish(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spublish(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response spublishAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) spublish(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spublish(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#spublish(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#spublish(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI spublishAndForget(String arg0, String arg1) { 
    spublish(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get one or multiple random members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srandmember/">SRANDMEMBER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> srandmember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.srandmember(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response srandmemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) srandmember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI srandmemberAndForget(List<String> args) { 
    srandmember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove one or more members from a set.
   * <p>
   * Redis command <a href="https://redis.io/commands/srem/">SREM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> srem(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.srem(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sremAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) srem(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sremAndForget(List<String> args) { 
    srem(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Incrementally iterate Set elements.
   * <p>
   * Redis command <a href="https://redis.io/commands/sscan/">SSCAN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sscan(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sscanAndForget(List<String> args) { 
    sscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Listen for messages published to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/ssubscribe/">SSUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ssubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ssubscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ssubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ssubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ssubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ssubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ssubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ssubscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ssubscribeAndForget(List<String> args) { 
    ssubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the length of the value stored in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/strlen/">STRLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> strlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.strlen(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response strlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) strlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI strlenAndForget(String arg0) { 
    strlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Listen for messages published to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/subscribe/">SUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> subscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.subscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response subscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) subscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI subscribeAndForget(List<String> args) { 
    subscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get a substring of the string stored at a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/substr/">SUBSTR</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> substr(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.substr(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response substrAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) substr(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI substrAndForget(String arg0, String arg1, String arg2) { 
    substr(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add multiple sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunion/">SUNION</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sunion(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sunion(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sunionAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sunion(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sunionAndForget(List<String> args) { 
    sunion(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add multiple sets and store the resulting set in a key.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunionstore/">SUNIONSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sunionstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sunionstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sunionstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sunionstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sunionstoreAndForget(List<String> args) { 
    sunionstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Stop listening for messages posted to the given shard channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/sunsubscribe/">SUNSUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sunsubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sunsubscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunsubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sunsubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sunsubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunsubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sunsubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sunsubscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sunsubscribeAndForget(List<String> args) { 
    sunsubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Swaps two Redis databases.
   * <p>
   * Redis command <a href="https://redis.io/commands/swapdb/">SWAPDB</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> swapdb(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.swapdb(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response swapdbAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) swapdb(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI swapdbAndForget(String arg0, String arg1) { 
    swapdb(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Internal command used for replication.
   * <p>
   * Redis command <a href="https://redis.io/commands/sync/">SYNC</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sync() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sync(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sync}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response syncAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) sync().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sync} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sync}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sync} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI syncAndForget() { 
    sync().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.add/">TDIGEST.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestAddAndForget(List<String> args) { 
    tdigestAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrank/">TDIGEST.BYRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestByrank(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestByrank(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrank(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestByrankAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestByrank(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrank(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrank(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrank(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestByrankAndForget(List<String> args) { 
    tdigestByrank(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.byrevrank/">TDIGEST.BYREVRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestByrevrank(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestByrevrank(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrevrank(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestByrevrankAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestByrevrank(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrevrank(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrevrank(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestByrevrank(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestByrevrankAndForget(List<String> args) { 
    tdigestByrevrank(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.cdf/">TDIGEST.CDF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestCdf(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestCdf(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCdf(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestCdfAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestCdf(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCdf(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCdf(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCdf(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestCdfAndForget(List<String> args) { 
    tdigestCdf(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.create/">TDIGEST.CREATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestCreate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestCreate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCreate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestCreateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestCreate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCreate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCreate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestCreate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestCreateAndForget(List<String> args) { 
    tdigestCreate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.info/">TDIGEST.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestInfoAndForget(List<String> args) { 
    tdigestInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.max/">TDIGEST.MAX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestMax(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestMax(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMax(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestMaxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestMax(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMax(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMax(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMax(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestMaxAndForget(List<String> args) { 
    tdigestMax(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.merge/">TDIGEST.MERGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestMerge(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestMerge(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMerge(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestMergeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestMerge(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMerge(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMerge(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMerge(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestMergeAndForget(List<String> args) { 
    tdigestMerge(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.min/">TDIGEST.MIN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestMin(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestMin(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMin(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestMinAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestMin(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMin(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMin(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestMin(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestMinAndForget(List<String> args) { 
    tdigestMin(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.quantile/">TDIGEST.QUANTILE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestQuantile(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestQuantile(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestQuantile(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestQuantileAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestQuantile(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestQuantile(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestQuantile(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestQuantile(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestQuantileAndForget(List<String> args) { 
    tdigestQuantile(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.rank/">TDIGEST.RANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestRank(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestRank(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRank(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestRankAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestRank(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRank(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRank(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRank(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestRankAndForget(List<String> args) { 
    tdigestRank(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.reset/">TDIGEST.RESET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestReset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestReset(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestReset(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestResetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestReset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestReset(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestReset(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestReset(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestResetAndForget(List<String> args) { 
    tdigestReset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.revrank/">TDIGEST.REVRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestRevrank(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestRevrank(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRevrank(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestRevrankAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestRevrank(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRevrank(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRevrank(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestRevrank(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestRevrankAndForget(List<String> args) { 
    tdigestRevrank(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/tdigest.trimmed_mean/">TDIGEST.TRIMMED_MEAN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tdigestTrimmedMean(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tdigestTrimmedMean(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestTrimmedMean(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tdigestTrimmedMeanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tdigestTrimmedMean(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestTrimmedMean(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestTrimmedMean(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tdigestTrimmedMean(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tdigestTrimmedMeanAndForget(List<String> args) { 
    tdigestTrimmedMean(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the current server time.
   * <p>
   * Redis command <a href="https://redis.io/commands/time/">TIME</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> time() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.time(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#time}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) time().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#time} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#time}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#time} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeAndForget() { 
    time().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clusterset/">TIMESERIES.CLUSTERSET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesClusterset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesClusterset(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClusterset(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesClustersetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesClusterset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClusterset(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClusterset(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClusterset(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesClustersetAndForget(List<String> args) { 
    timeseriesClusterset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.clustersetfromshard/">TIMESERIES.CLUSTERSETFROMSHARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesClustersetfromshard(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesClustersetfromshard(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClustersetfromshard(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesClustersetfromshardAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesClustersetfromshard(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClustersetfromshard(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClustersetfromshard(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesClustersetfromshard(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesClustersetfromshardAndForget(List<String> args) { 
    timeseriesClustersetfromshard(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.hello/">TIMESERIES.HELLO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesHello(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesHello(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesHello(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesHelloAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesHello(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesHello(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesHello(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesHello(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesHelloAndForget(List<String> args) { 
    timeseriesHello(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.infocluster/">TIMESERIES.INFOCLUSTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesInfocluster(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesInfocluster(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInfocluster(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesInfoclusterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesInfocluster(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInfocluster(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInfocluster(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInfocluster(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesInfoclusterAndForget(List<String> args) { 
    timeseriesInfocluster(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.innercommunication/">TIMESERIES.INNERCOMMUNICATION</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesInnercommunication(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesInnercommunication(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInnercommunication(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesInnercommunicationAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesInnercommunication(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInnercommunication(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInnercommunication(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesInnercommunication(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesInnercommunicationAndForget(List<String> args) { 
    timeseriesInnercommunication(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.networktest/">TIMESERIES.NETWORKTEST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesNetworktest(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesNetworktest(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesNetworktest(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesNetworktestAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesNetworktest(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesNetworktest(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesNetworktest(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesNetworktest(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesNetworktestAndForget(List<String> args) { 
    timeseriesNetworktest(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.refreshcluster/">TIMESERIES.REFRESHCLUSTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> timeseriesRefreshcluster(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.timeseriesRefreshcluster(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesRefreshcluster(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeseriesRefreshclusterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) timeseriesRefreshcluster(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesRefreshcluster(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesRefreshcluster(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#timeseriesRefreshcluster(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeseriesRefreshclusterAndForget(List<String> args) { 
    timeseriesRefreshcluster(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add/">TOPK.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkAddAndForget(List<String> args) { 
    topkAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count/">TOPK.COUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkCount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkCount(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkCount(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkCountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkCount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkCount(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkCount(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkCount(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkCountAndForget(List<String> args) { 
    topkCount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby/">TOPK.INCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkIncrby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkIncrby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkIncrby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkIncrbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkIncrby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkIncrby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkIncrby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkIncrby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkIncrbyAndForget(List<String> args) { 
    topkIncrby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info/">TOPK.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkInfoAndForget(List<String> args) { 
    topkInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list/">TOPK.LIST</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkList(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkList(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkList(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkListAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkList(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkList(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkList(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkList(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkListAndForget(List<String> args) { 
    topkList(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query/">TOPK.QUERY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkQuery(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkQuery(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkQuery(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkQueryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkQuery(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkQuery(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkQuery(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkQuery(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkQueryAndForget(List<String> args) { 
    topkQuery(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve/">TOPK.RESERVE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> topkReserve(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.topkReserve(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkReserve(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response topkReserveAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) topkReserve(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#topkReserve(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#topkReserve(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#topkReserve(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI topkReserveAndForget(List<String> args) { 
    topkReserve(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * <p>
   * Redis command <a href="https://redis.io/commands/touch/">TOUCH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> touch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.touch(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response touchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) touch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI touchAndForget(List<String> args) { 
    touch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add/">TS.ADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsAdd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsAdd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAdd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsAddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsAdd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAdd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAdd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsAdd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsAddAndForget(List<String> args) { 
    tsAdd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter/">TS.ALTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsAlter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsAlter(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAlter(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsAlterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsAlter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAlter(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsAlter(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsAlter(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsAlterAndForget(List<String> args) { 
    tsAlter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create/">TS.CREATE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsCreate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsCreate(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreate(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsCreateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsCreate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreate(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreate(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreate(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsCreateAndForget(List<String> args) { 
    tsCreate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule/">TS.CREATERULE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsCreaterule(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsCreaterule(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreaterule(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsCreateruleAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsCreaterule(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreaterule(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreaterule(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsCreaterule(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsCreateruleAndForget(List<String> args) { 
    tsCreaterule(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby/">TS.DECRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsDecrby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsDecrby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDecrby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsDecrbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsDecrby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDecrby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDecrby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsDecrby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsDecrbyAndForget(List<String> args) { 
    tsDecrby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del/">TS.DEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsDel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsDel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsDelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsDel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsDel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsDelAndForget(List<String> args) { 
    tsDel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule/">TS.DELETERULE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsDeleterule(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsDeleterule(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDeleterule(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsDeleteruleAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsDeleterule(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDeleterule(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsDeleterule(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsDeleterule(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsDeleteruleAndForget(List<String> args) { 
    tsDeleterule(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get/">TS.GET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsGet(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsGet(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsGet(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsGetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsGet(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsGet(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsGet(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsGet(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsGetAndForget(List<String> args) { 
    tsGet(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby/">TS.INCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsIncrby(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsIncrby(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsIncrby(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsIncrbyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsIncrby(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsIncrby(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsIncrby(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsIncrby(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsIncrbyAndForget(List<String> args) { 
    tsIncrby(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info/">TS.INFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsInfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsInfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsInfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsInfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsInfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsInfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsInfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsInfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsInfoAndForget(List<String> args) { 
    tsInfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd/">TS.MADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsMadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsMadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsMaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsMadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsMadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsMaddAndForget(List<String> args) { 
    tsMadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget/">TS.MGET</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsMget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsMget(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMget(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsMgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsMget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMget(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMget(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsMget(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsMgetAndForget(List<String> args) { 
    tsMget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange/">TS.MRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsMrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsMrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsMrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsMrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsMrangeAndForget(List<String> args) { 
    tsMrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange/">TS.MREVRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsMrevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsMrevrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrevrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsMrevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsMrevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrevrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrevrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsMrevrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsMrevrangeAndForget(List<String> args) { 
    tsMrevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex/">TS.QUERYINDEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsQueryindex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsQueryindex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsQueryindex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsQueryindexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsQueryindex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsQueryindex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsQueryindex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsQueryindex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsQueryindexAndForget(List<String> args) { 
    tsQueryindex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range/">TS.RANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsRange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsRange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsRangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsRange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsRange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsRangeAndForget(List<String> args) { 
    tsRange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange/">TS.REVRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> tsRevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.tsRevrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRevrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response tsRevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) tsRevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRevrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#tsRevrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#tsRevrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI tsRevrangeAndForget(List<String> args) { 
    tsRevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the time to live for a key in seconds.
   * <p>
   * Redis command <a href="https://redis.io/commands/ttl/">TTL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ttl(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ttl(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ttlAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) ttl(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ttlAndForget(String arg0) { 
    ttl(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine the type stored at key.
   * <p>
   * Redis command <a href="https://redis.io/commands/type/">TYPE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> type(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.type(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response typeAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) type(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI typeAndForget(String arg0) { 
    type(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * <p>
   * Redis command <a href="https://redis.io/commands/unlink/">UNLINK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unlink(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unlink(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unlinkAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) unlink(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unlinkAndForget(List<String> args) { 
    unlink(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Stop listening for messages posted to the given channels.
   * <p>
   * Redis command <a href="https://redis.io/commands/unsubscribe/">UNSUBSCRIBE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unsubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unsubscribe(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unsubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) unsubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unsubscribeAndForget(List<String> args) { 
    unsubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Forget about all watched keys.
   * <p>
   * Redis command <a href="https://redis.io/commands/unwatch/">UNWATCH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unwatch() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unwatch(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unwatchAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) unwatch().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unwatchAndForget() { 
    unwatch().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * <p>
   * Redis command <a href="https://redis.io/commands/wait/">WAIT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> wait(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.wait(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response waitAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) wait(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI waitAndForget(String arg0, String arg1) { 
    wait(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block.
   * <p>
   * Redis command <a href="https://redis.io/commands/watch/">WATCH</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> watch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.watch(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response watchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) watch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI watchAndForget(List<String> args) { 
    watch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Marks a pending message as correctly processed, effectively removing it from the pending entries list of the consumer group. Return value of the command is the number of messages successfully acknowledged, that is, the IDs we were actually able to resolve in the PEL.
   * <p>
   * Redis command <a href="https://redis.io/commands/xack/">XACK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xack(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xack(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xackAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xack(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xackAndForget(List<String> args) { 
    xack(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Appends a new entry to a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xadd/">XADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xaddAndForget(List<String> args) { 
    xadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Changes (or acquires) ownership of messages in a consumer group, as if the messages were delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xautoclaim/">XAUTOCLAIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xautoclaim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xautoclaim(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xautoclaimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xautoclaim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xautoclaimAndForget(List<String> args) { 
    xautoclaim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Changes (or acquires) ownership of a message in a consumer group, as if the message was delivered to the specified consumer.
   * <p>
   * Redis command <a href="https://redis.io/commands/xclaim/">XCLAIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xclaim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xclaim(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xclaimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xclaim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xclaimAndForget(List<String> args) { 
    xclaim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Removes the specified entries from the stream. Returns the number of items actually deleted, that may be different from the number of IDs passed in case certain IDs do not exist.
   * <p>
   * Redis command <a href="https://redis.io/commands/xdel/">XDEL</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xdel(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xdelAndForget(List<String> args) { 
    xdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for consumer groups commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xgroup/">XGROUP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xgroup(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xgroup(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xgroupAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xgroup(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xgroupAndForget(List<String> args) { 
    xgroup(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * A container for stream introspection commands.
   * <p>
   * Redis command <a href="https://redis.io/commands/xinfo/">XINFO</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xinfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xinfo(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xinfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xinfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xinfoAndForget(List<String> args) { 
    xinfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return the number of entries in a stream.
   * <p>
   * Redis command <a href="https://redis.io/commands/xlen/">XLEN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xlen(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) xlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xlenAndForget(String arg0) { 
    xlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return information and entries from a stream consumer group pending entries list, that are messages fetched but never acknowledged.
   * <p>
   * Redis command <a href="https://redis.io/commands/xpending/">XPENDING</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xpending(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xpending(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xpendingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xpending(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xpendingAndForget(List<String> args) { 
    xpending(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrange/">XRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xrangeAndForget(List<String> args) { 
    xrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return never seen elements in multiple streams, with IDs greater than the ones reported by the caller for each stream. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xread/">XREAD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xread(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xread(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xreadAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xread(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xreadAndForget(List<String> args) { 
    xread(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return new entries from a stream using a consumer group, or access the history of the pending entries for a given consumer. Can block.
   * <p>
   * Redis command <a href="https://redis.io/commands/xreadgroup/">XREADGROUP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xreadgroup(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xreadgroup(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xreadgroupAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xreadgroup(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xreadgroupAndForget(List<String> args) { 
    xreadgroup(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of elements in a stream, with IDs matching the specified IDs interval, in reverse order (from greater to smaller IDs) compared to XRANGE.
   * <p>
   * Redis command <a href="https://redis.io/commands/xrevrange/">XREVRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xrevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xrevrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xrevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xrevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xrevrangeAndForget(List<String> args) { 
    xrevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * An internal command for replicating stream values.
   * <p>
   * Redis command <a href="https://redis.io/commands/xsetid/">XSETID</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xsetid(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xsetid(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xsetidAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xsetid(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xsetidAndForget(List<String> args) { 
    xsetid(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Trims the stream to (approximately if &#x27;~&#x27; is passed) a certain size.
   * <p>
   * Redis command <a href="https://redis.io/commands/xtrim/">XTRIM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xtrim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xtrim(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xtrimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xtrim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xtrimAndForget(List<String> args) { 
    xtrim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists.
   * <p>
   * Redis command <a href="https://redis.io/commands/zadd/">ZADD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zadd(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zaddAndForget(List<String> args) { 
    zadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the number of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcard/">ZCARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zcard(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zcard(arg0, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zcardAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) zcard(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zcardAndForget(String arg0) { 
    zcard(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Count the members in a sorted set with scores within the given values.
   * <p>
   * Redis command <a href="https://redis.io/commands/zcount/">ZCOUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zcount(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zcount(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zcountAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zcount(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zcountAndForget(String arg0, String arg1, String arg2) { 
    zcount(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subtract multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiff/">ZDIFF</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zdiff(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zdiff(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zdiffAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zdiff(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zdiffAndForget(List<String> args) { 
    zdiff(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subtract multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zdiffstore/">ZDIFFSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zdiffstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zdiffstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zdiffstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zdiffstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zdiffstoreAndForget(List<String> args) { 
    zdiffstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Increment the score of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zincrby/">ZINCRBY</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zincrby(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zincrby(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zincrbyAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zincrby(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zincrbyAndForget(String arg0, String arg1, String arg2) { 
    zincrby(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinter/">ZINTER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zinter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zinter(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zinterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zinter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zinterAndForget(List<String> args) { 
    zinter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sorted sets and return the cardinality of the result.
   * <p>
   * Redis command <a href="https://redis.io/commands/zintercard/">ZINTERCARD</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zintercard(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zintercard(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zintercard(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zintercardAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zintercard(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zintercard(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zintercard(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zintercard(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zintercardAndForget(List<String> args) { 
    zintercard(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zinterstore/">ZINTERSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zinterstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zinterstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zinterstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zinterstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zinterstoreAndForget(List<String> args) { 
    zinterstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zlexcount/">ZLEXCOUNT</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zlexcount(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zlexcount(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zlexcountAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zlexcount(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zlexcountAndForget(String arg0, String arg1, String arg2) { 
    zlexcount(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return members with scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmpop/">ZMPOP</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zmpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zmpop(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmpop(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zmpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zmpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmpop(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zmpop(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zmpop(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zmpopAndForget(List<String> args) { 
    zmpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the score associated with the given members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zmscore/">ZMSCORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zmscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zmscore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zmscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zmscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zmscoreAndForget(List<String> args) { 
    zmscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return members with the highest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmax/">ZPOPMAX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zpopmax(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zpopmax(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zpopmaxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zpopmax(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zpopmaxAndForget(List<String> args) { 
    zpopmax(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove and return members with the lowest scores in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zpopmin/">ZPOPMIN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zpopmin(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zpopmin(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zpopminAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zpopmin(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zpopminAndForget(List<String> args) { 
    zpopmin(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get one or multiple random elements from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrandmember/">ZRANDMEMBER</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrandmember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrandmember(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrandmemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrandmember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrandmemberAndForget(List<String> args) { 
    zrandmember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrange/">ZRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangeAndForget(List<String> args) { 
    zrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebylex/">ZRANGEBYLEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangebylex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangebylex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangebylexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangebylex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangebylexAndForget(List<String> args) { 
    zrangebylex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangebyscore/">ZRANGEBYSCORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangebyscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangebyscore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangebyscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangebyscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangebyscoreAndForget(List<String> args) { 
    zrangebyscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Store a range of members from sorted set into another key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrangestore/">ZRANGESTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangestore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangestore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangestoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangestore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangestoreAndForget(List<String> args) { 
    zrangestore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrank/">ZRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrank(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrank(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrankAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zrank(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrankAndForget(String arg0, String arg1) { 
    zrank(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove one or more members from a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrem/">ZREM</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrem(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrem(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrem(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremAndForget(List<String> args) { 
    zrem(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebylex/">ZREMRANGEBYLEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebylex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebylex(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebylexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebylex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebylexAndForget(String arg0, String arg1, String arg2) { 
    zremrangebylex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given indexes.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyrank/">ZREMRANGEBYRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebyrank(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebyrank(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebyrankAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebyrank(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebyrankAndForget(String arg0, String arg1, String arg2) { 
    zremrangebyrank(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zremrangebyscore/">ZREMRANGEBYSCORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebyscore(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebyscore(arg0, arg1, arg2, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebyscoreAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebyscore(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebyscoreAndForget(String arg0, String arg1, String arg2) { 
    zremrangebyscore(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrange/">ZREVRANGE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrange(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangeAndForget(List<String> args) { 
    zrevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebylex/">ZREVRANGEBYLEX</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrangebylex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrangebylex(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangebylexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrangebylex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangebylexAndForget(List<String> args) { 
    zrevrangebylex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore/">ZREVRANGEBYSCORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrangebyscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrangebyscore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangebyscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrangebyscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangebyscoreAndForget(List<String> args) { 
    zrevrangebyscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low.
   * <p>
   * Redis command <a href="https://redis.io/commands/zrevrank/">ZREVRANK</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrank(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrank(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrankAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrank(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrankAndForget(String arg0, String arg1) { 
    zrevrank(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscan/">ZSCAN</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zscan(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zscanAndForget(List<String> args) { 
    zscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the score associated with the given member in a sorted set.
   * <p>
   * Redis command <a href="https://redis.io/commands/zscore/">ZSCORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zscore(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zscore(arg0, arg1, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zscoreAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zscore(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zscoreAndForget(String arg0, String arg1) { 
    zscore(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add multiple sorted sets.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunion/">ZUNION</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zunion(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zunion(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zunionAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zunion(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zunionAndForget(List<String> args) { 
    zunion(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key.
   * <p>
   * Redis command <a href="https://redis.io/commands/zunionstore/">ZUNIONSTORE</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zunionstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zunionstore(args, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zunionstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zunionstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zunionstoreAndForget(List<String> args) { 
    zunionstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static io.vertx.mutiny.redis.client.RedisAPI api(io.vertx.mutiny.redis.client.Redis client) { 
    io.vertx.mutiny.redis.client.RedisAPI ret = io.vertx.mutiny.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.mutiny.redis.client.RedisAPI api(io.vertx.mutiny.redis.client.RedisConnection connection) { 
    io.vertx.mutiny.redis.client.RedisAPI ret = io.vertx.mutiny.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static  RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
