package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

/**
 * Builder for REDIS requests that will be encoded according to the RESP protocol was introduced in Redis 1.2.
 * Which became the standard way for talking with the Redis server in Redis 2.0.
 *
 * Redis <a href="https://redis.io/topics/protocol">protocol documentation</a> states:
 *
 * <blockquote>
 *     Clients send commands to a Redis server as a RESP Array of Bulk Strings.
 * </blockquote>
 *
 * So all non String/Bulk types will be encoded to Bulk for convenience.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Request original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.Request.class)
public class Request implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Request> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Request((io.vertx.redis.client.Request) obj),
    Request::getDelegate
  );

  private final io.vertx.redis.client.Request delegate;
  
  public Request(io.vertx.redis.client.Request delegate) {
    this.delegate = delegate;
  }

  public Request(Object delegate) {
    this.delegate = (io.vertx.redis.client.Request)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Request() {
    this.delegate = null;
  }

  @Override
  public io.vertx.redis.client.Request getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Request that = (Request) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param command the command to use
   * @return a new request instance
   */
  public static io.vertx.mutiny.redis.client.Request cmd(io.vertx.mutiny.redis.client.Command command) { 
    io.vertx.mutiny.redis.client.Request ret = io.vertx.mutiny.redis.client.Request.newInstance((io.vertx.redis.client.Request)io.vertx.redis.client.Request.cmd(command.getDelegate()));
    return ret;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(String arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @param enc 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(String arg, String enc) { 
    delegate.arg(arg, enc);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(io.vertx.mutiny.core.buffer.Buffer arg) { 
    delegate.arg(arg.getDelegate());
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(long arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(boolean arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(JsonObject arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(JsonArray arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @return self
   * @deprecated REDIS does not support {@code null} as a parameter, only as response. This was a deviation from the official protocol which should be avoided. Other clients explicitly do not allow this. Adds a {@code null} encoded string. Redis does not allow storing the {@code null} value by itself. This method will encode any null value as the four character long string {@code "null"}. As a recommendation, this method should not be used directly unless this is the intented behavior. It is present to handle special cases such as encoding of {@link JsonObject} and {@link JsonArray} which may contain null values.   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.redis.client.Request nullArg() { 
    delegate.nullArg();
    return this;
  }

  /**
   * @return the command.
   */
  public io.vertx.mutiny.redis.client.Command command() { 
    io.vertx.mutiny.redis.client.Command ret = io.vertx.mutiny.redis.client.Command.newInstance((io.vertx.redis.client.Command)delegate.command());
    return ret;
  }

  /**
   * @param command the command to use
   * @param args the fixed list of arguments
   * @return a new request instance
   */
  public static io.vertx.mutiny.redis.client.Request cmd(io.vertx.mutiny.redis.client.Command command, java.lang.Object[] args) { 
    io.vertx.mutiny.redis.client.Request ret = io.vertx.mutiny.redis.client.Request.newInstance((io.vertx.redis.client.Request)io.vertx.redis.client.Request.cmd(command.getDelegate(), args));
    return ret;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(byte[] arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(int arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(short arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(byte arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(float arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @param arg 
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.redis.client.Request arg(double arg) { 
    delegate.arg(arg);
    return this;
  }

  public static  Request newInstance(io.vertx.redis.client.Request arg) {
    return arg != null ? new Request(arg) : null;
  }

}
