package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Set;
import io.vertx.redis.client.ResponseType;
import java.nio.charset.Charset;
import java.util.Map;
import java.math.BigInteger;

/**
 * The response received from the REDIS server. Redis responses can have several representations:
 *
 * <ul>
 *     <li>simple string - C string</li>
 *     <li>integer - 64bit integer value</li>
 *     <li>bulk - byte array</li>
 *     <li>multi - list</li>
 * </ul>
 *
 * Due to the dynamic nature the response object will try to cast the received response to the desired type. A special
 * case should be noted that multi responses are also handled by the response object as it implements the iterable
 * interface. So in this case constructs like for loops on the response will give you access to the underlying elements.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Response original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.Response.class)
public class Response implements io.smallrye.mutiny.vertx.MutinyDelegate, java.lang.Iterable<io.vertx.mutiny.redis.client.Response> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Response> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Response((io.vertx.redis.client.Response) obj),
    Response::getDelegate
  );

  private final io.vertx.redis.client.Response delegate;
  
  public Response(io.vertx.redis.client.Response delegate) {
    this.delegate = delegate;
  }

  public Response(Object delegate) {
    this.delegate = (io.vertx.redis.client.Response)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Response() {
    this.delegate = null;
  }

  @Override
  public io.vertx.redis.client.Response getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.redis.client.Response> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.redis.client.Response>(o1 -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Response that = (Response) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public java.util.Iterator<io.vertx.mutiny.redis.client.Response> iterator() {
    java.util.function.Function<io.vertx.redis.client.Response, io.vertx.mutiny.redis.client.Response> conv = io.vertx.mutiny.redis.client.Response::newInstance;
    return new io.smallrye.mutiny.vertx.impl.MappingIterator<>(delegate.iterator(), conv);
  }

  @CheckReturnValue
  public Multi<io.vertx.mutiny.redis.client.Response> toMulti() {
    return Multi.createFrom().iterable(this);
  }

  /**
   * @return the type.
   */
  public io.vertx.redis.client.ResponseType type() { 
    io.vertx.redis.client.ResponseType ret = delegate.type();
    return ret;
  }

  /**
   * @return the a key value map of attributes to this response.
   */
  public java.util.Map<String, io.vertx.mutiny.redis.client.Response> attributes() { 
    java.util.Map<String, io.vertx.mutiny.redis.client.Response> ret = delegate.attributes().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)_e.getValue())));
    return ret;
  }

  /**
   * @return string value
   */
  public String toString() { 
    String ret = delegate.toString();
    return ret;
  }

  /**
   * @return 
   */
  public String format() { 
    String ret = delegate.format();
    return ret;
  }

  /**
   * @return double value.
   */
  public Double toDouble() { 
    Double ret = delegate.toDouble();
    return ret;
  }

  /**
   * @return double value.
   */
  public Float toFloat() { 
    Float ret = delegate.toFloat();
    return ret;
  }

  /**
   * @return long value.
   */
  public Long toLong() { 
    Long ret = delegate.toLong();
    return ret;
  }

  /**
   * @return int value.
   */
  public Integer toInteger() { 
    Integer ret = delegate.toInteger();
    return ret;
  }

  /**
   * @return short value.
   */
  public Short toShort() { 
    Short ret = delegate.toShort();
    return ret;
  }

  /**
   * @return byte value.
   */
  public Byte toByte() { 
    Byte ret = delegate.toByte();
    return ret;
  }

  /**
   * @return boolean value.
   */
  public Boolean toBoolean() { 
    Boolean ret = delegate.toBoolean();
    return ret;
  }

  /**
   * @return buffer value.
   */
  public io.vertx.mutiny.core.buffer.Buffer toBuffer() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.toBuffer());
    return ret;
  }

  /**
   * @param index the required index.
   * @return Response value.
   */
  public io.vertx.mutiny.redis.client.Response get(int index) { 
    io.vertx.mutiny.redis.client.Response ret = io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)delegate.get(index));
    return ret;
  }

  /**
   * @param key the required key.
   * @return Response value.
   */
  public io.vertx.mutiny.redis.client.Response get(String key) { 
    io.vertx.mutiny.redis.client.Response ret = io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)delegate.get(key));
    return ret;
  }

  /**
   * @param key the required key.
   * @return Response value.
   */
  public boolean containsKey(String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * @return the set of keys.
   */
  public Set<String> getKeys() { 
    Set<String> ret = delegate.getKeys();
    return ret;
  }

  /**
   * @return the size of the multi.
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * @return whether this multi response is an array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return whether this multi response is a map
   */
  public boolean isMap() { 
    boolean ret = delegate.isMap();
    return ret;
  }

  /**
   * @return number value
   */
  public java.lang.Number toNumber() { 
    java.lang.Number ret = delegate.toNumber();
    return ret;
  }

  /**
   * @return long value.
   */
  public java.math.BigInteger toBigInteger() { 
    java.math.BigInteger ret = delegate.toBigInteger();
    return ret;
  }

  /**
   * @param encoding 
   * @return String value.
   */
  public String toString(java.nio.charset.Charset encoding) { 
    String ret = delegate.toString(encoding);
    return ret;
  }

  /**
   * @return byte[] value.
   */
  public byte[] toBytes() { 
    byte[] ret = delegate.toBytes();
    return ret;
  }

  public static  Response newInstance(io.vertx.redis.client.Response arg) {
    return arg != null ? new Response(arg) : null;
  }

}
