package io.vertx.mutiny.servicediscovery;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Set;
import io.vertx.servicediscovery.Record;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Service Discovery main entry point.
 * <p>
 * The service discovery is an infrastructure that let you publish and find `services`. A `service` is a discoverable
 * functionality. It can be qualified by its type, metadata, and location. So a `service` can be a database, a
 * service proxy, a HTTP endpoint. It does not have to be a vert.x entity, but can be anything. Each service is
 * described by a {@link io.vertx.servicediscovery.Record}.
 * <p>
 * The service discovery implements the interactions defined in the service-oriented computing. And to some extend,
 * also provides the dynamic service-oriented computing interaction. So, application can react to arrival and
 * departure of services.
 * <p>
 * A service provider can:
 * <p>
 * * publish a service record
 * * un-publish a published record
 * * update the status of a published service (down, out of service...)
 * <p>
 * A service consumer can:
 * <p>
 * * lookup for services
 * * bind to a selected service (it gets a {@link io.vertx.mutiny.servicediscovery.ServiceReference}) and use it
 * * release the service once the consumer is done with it
 * * listen for arrival, departure and modification of services.
 * <p>
 * Consumer would 1) lookup for service record matching their need, 2) retrieve the {@link io.vertx.mutiny.servicediscovery.ServiceReference} that give access
 * to the service, 3) get a service object to access the service, 4) release the service object once done.
 * <p>
 * A state above, the central piece of information shared by the providers and consumers are {@link io.vertx.servicediscovery.Record}.
 * <p>
 * Providers and consumers must create their own {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery} instance. These instances are collaborating
 * in background (distributed structure) to keep the set of services in sync.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.ServiceDiscovery original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServiceDiscovery> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery) obj),
    ServiceDiscovery::getDelegate
  );

  private final io.vertx.servicediscovery.ServiceDiscovery delegate;
  
  public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
    this.delegate = delegate;
  }

  public ServiceDiscovery(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServiceDiscovery() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.servicediscovery.ServiceReference> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.servicediscovery.ServiceReference>(o1 -> io.vertx.mutiny.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceDiscovery that = (ServiceDiscovery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance
   * @param options the discovery options
   * @return the created service discovery instance.
   */
  public static io.vertx.mutiny.servicediscovery.ServiceDiscovery create(io.vertx.mutiny.core.Vertx vertx, io.vertx.servicediscovery.ServiceDiscoveryOptions options) { 
    io.vertx.mutiny.servicediscovery.ServiceDiscovery ret = io.vertx.mutiny.servicediscovery.ServiceDiscovery.newInstance((io.vertx.servicediscovery.ServiceDiscovery)io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vert.x instance
   * @return the created instance
   */
  public static io.vertx.mutiny.servicediscovery.ServiceDiscovery create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.servicediscovery.ServiceDiscovery ret = io.vertx.mutiny.servicediscovery.ServiceDiscovery.newInstance((io.vertx.servicediscovery.ServiceDiscovery)io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param record the chosen record
   * @return the service reference, that allows retrieving the service object. Once called the service reference is cached, and need to be released.
   */
  public io.vertx.mutiny.servicediscovery.ServiceReference getReference(io.vertx.servicediscovery.Record record) { 
    io.vertx.mutiny.servicediscovery.ServiceReference ret = io.vertx.mutiny.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)delegate.getReference(record));
    return ret;
  }

  /**
   * @param record the chosen record
   * @param configuration the configuration
   * @return the service reference, that allows retrieving the service object. Once called the service reference is cached, and need to be released.
   */
  public io.vertx.mutiny.servicediscovery.ServiceReference getReferenceWithConfiguration(io.vertx.servicediscovery.Record record, JsonObject configuration) { 
    io.vertx.mutiny.servicediscovery.ServiceReference ret = io.vertx.mutiny.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)delegate.getReferenceWithConfiguration(record, configuration));
    return ret;
  }

  /**
   * @param reference the reference to release, must not be <code>null</code>
   * @return whether or not the reference has been released.
   */
  public boolean release(io.vertx.mutiny.servicediscovery.ServiceReference reference) { 
    boolean ret = delegate.release(reference.getDelegate());
    return ret;
  }

  /**
   * Registers a discovery service importer. Importers let you integrate other discovery technologies in this service
   * discovery.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param importer the service importer
   * @param configuration the optional configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> registerServiceImporter(io.vertx.mutiny.servicediscovery.spi.ServiceImporter importer, JsonObject configuration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.registerServiceImporter(importer.getDelegate(), configuration, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceImporter(io.vertx.mutiny.servicediscovery.spi.ServiceImporter,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param importer the service importer
   * @param configuration the optional configuration
   * @return the Void instance produced by the operation.
   */
  public Void registerServiceImporterAndAwait(io.vertx.mutiny.servicediscovery.spi.ServiceImporter importer, JsonObject configuration) { 
    return (Void) registerServiceImporter(importer, configuration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceImporter(io.vertx.mutiny.servicediscovery.spi.ServiceImporter,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceImporter(io.vertx.mutiny.servicediscovery.spi.ServiceImporter,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceImporter(io.vertx.mutiny.servicediscovery.spi.ServiceImporter,JsonObject)} but you don't need to compose it with other operations.
   * @param importer the service importer
   * @param configuration the optional configuration
   * @return the instance of ServiceDiscovery to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.servicediscovery.ServiceDiscovery registerServiceImporterAndForget(io.vertx.mutiny.servicediscovery.spi.ServiceImporter importer, JsonObject configuration) { 
    registerServiceImporter(importer, configuration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Registers a discovery bridge. Exporters let you integrate other discovery technologies in this service
   * discovery.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param exporter the service exporter
   * @param configuration the optional configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> registerServiceExporter(io.vertx.mutiny.servicediscovery.spi.ServiceExporter exporter, JsonObject configuration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.registerServiceExporter(exporter.getDelegate(), configuration, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceExporter(io.vertx.mutiny.servicediscovery.spi.ServiceExporter,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param exporter the service exporter
   * @param configuration the optional configuration
   * @return the Void instance produced by the operation.
   */
  public Void registerServiceExporterAndAwait(io.vertx.mutiny.servicediscovery.spi.ServiceExporter exporter, JsonObject configuration) { 
    return (Void) registerServiceExporter(exporter, configuration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceExporter(io.vertx.mutiny.servicediscovery.spi.ServiceExporter,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceExporter(io.vertx.mutiny.servicediscovery.spi.ServiceExporter,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#registerServiceExporter(io.vertx.mutiny.servicediscovery.spi.ServiceExporter,JsonObject)} but you don't need to compose it with other operations.
   * @param exporter the service exporter
   * @param configuration the optional configuration
   * @return the instance of ServiceDiscovery to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.servicediscovery.ServiceDiscovery registerServiceExporterAndForget(io.vertx.mutiny.servicediscovery.spi.ServiceExporter exporter, JsonObject configuration) { 
    registerServiceExporter(exporter, configuration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Publishes a record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record the record
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> publish(io.vertx.servicediscovery.Record record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.publish(record, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#publish(Record)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record the record
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record publishAndAwait(io.vertx.servicediscovery.Record record) { 
    return (io.vertx.servicediscovery.Record) publish(record).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#publish(Record)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#publish(Record)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#publish(Record)} but you don't need to compose it with other operations.
   * @param record the record
   */
  public void publishAndForget(io.vertx.servicediscovery.Record record) { 
    publish(record).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Un-publishes a record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the registration id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unpublish(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.unpublish(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#unpublish(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the registration id
   * @return the Void instance produced by the operation.
   */
  public Void unpublishAndAwait(String id) { 
    return (Void) unpublish(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#unpublish(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#unpublish(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#unpublish(String)} but you don't need to compose it with other operations.
   * @param id the registration id
   */
  public void unpublishAndForget(String id) { 
    unpublish(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a single record.
   * <p>
   * Filters are expressed using a Json object. Each entry of the given filter will be checked against the record.
   * All entry must match exactly the record. The entry can use the special "*" value to denotes a requirement on the
   * key, but not on the value.
   * <p>
   * Let's take some example:
   * <pre>
   *   { "name" = "a" } => matches records with name set fo "a"
   *   { "color" = "*" } => matches records with "color" set
   *   { "color" = "red" } => only matches records with "color" set to "red"
   *   { "color" = "red", "name" = "a"} => only matches records with name set to "a", and color set to "red"
   * </pre>
   * <p>
   * If the filter is not set (<code>null</code> or empty), it accepts all records.
   * <p>
   * This method returns the first matching record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> getRecord(JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecord(filter, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter.
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record getRecordAndAwait(JsonObject filter) { 
    return (io.vertx.servicediscovery.Record) getRecord(filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(JsonObject)} but you don't need to compose it with other operations.
   * @param filter the filter.
   */
  public void getRecordAndForget(JsonObject filter) { 
    getRecord(filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Looks up for a single record by its registration <code>id</code>.
   * <p>
   * When there are no matching record, the operation succeeds, but the async result has no result (<code>null</code>).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the registration id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> getRecord(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecord(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the registration id
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record getRecordAndAwait(String id) { 
    return (io.vertx.servicediscovery.Record) getRecord(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(String)} but you don't need to compose it with other operations.
   * @param id the registration id
   */
  public void getRecordAndForget(String id) { 
    getRecord(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> getRecord(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecord(filter, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record getRecordAndAwait(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.servicediscovery.Record) getRecord(filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function)} but you don't need to compose it with other operations.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   */
  public void getRecordAndForget(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getRecord(filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a single record.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> getRecord(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecord(filter, includeOutOfService, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record getRecordAndAwait(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    return (io.vertx.servicediscovery.Record) getRecord(filter, includeOutOfService).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord(Function,boolean)} but you don't need to compose it with other operations.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   */
  public void getRecordAndForget(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    getRecord(filter, includeOutOfService).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter - see {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.servicediscovery.Record>> getRecords(JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecords(filter, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter - see {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}
   * @return the List<Record> instance produced by the operation.
   */
  public List<io.vertx.servicediscovery.Record> getRecordsAndAwait(JsonObject filter) { 
    return (List<io.vertx.servicediscovery.Record>) getRecords(filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(JsonObject)} but you don't need to compose it with other operations.
   * @param filter the filter - see {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}
   */
  public void getRecordsAndForget(JsonObject filter) { 
    getRecords(filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * This method only looks for records with a <code>UP</code> status.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.servicediscovery.Record>> getRecords(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecords(filter, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @return the List<Record> instance produced by the operation.
   */
  public List<io.vertx.servicediscovery.Record> getRecordsAndAwait(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (List<io.vertx.servicediscovery.Record>) getRecords(filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function)} but you don't need to compose it with other operations.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   */
  public void getRecordsAndForget(Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getRecords(filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookups for a set of records. Unlike {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecord}, this method returns all matching
   * records.
   * <p>
   * The filter is a  taking a {@link io.vertx.servicediscovery.Record} as argument and returning a boolean. You should see it
   * as an <code>accept</code> method of a filter. This method return a record passing the filter.
   * <p>
   * Unlike {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords}, this method may accept records with a <code>OUT OF SERVICE</code>
   * status, if the <code>includeOutOfService</code> parameter is set to <code>true</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.servicediscovery.Record>> getRecords(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getRecords(filter, includeOutOfService, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   * @return the List<Record> instance produced by the operation.
   */
  public List<io.vertx.servicediscovery.Record> getRecordsAndAwait(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    return (List<io.vertx.servicediscovery.Record>) getRecords(filter, includeOutOfService).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#getRecords(Function,boolean)} but you don't need to compose it with other operations.
   * @param filter the filter, must not be <code>null</code>. To return all records, use a function accepting all records
   * @param includeOutOfService whether or not the filter accepts <code>OUT OF SERVICE</code> records
   */
  public void getRecordsAndForget(Function<io.vertx.servicediscovery.Record, Boolean> filter, boolean includeOutOfService) { 
    getRecords(filter, includeOutOfService).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Updates the given record. The record must has been published, and has it's registration id set.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record the updated record
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> update(io.vertx.servicediscovery.Record record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.update(record, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#update(Record)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record the updated record
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record updateAndAwait(io.vertx.servicediscovery.Record record) { 
    return (io.vertx.servicediscovery.Record) update(record).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#update(Record)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#update(Record)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.ServiceDiscovery#update(Record)} but you don't need to compose it with other operations.
   * @param record the updated record
   */
  public void updateAndForget(io.vertx.servicediscovery.Record record) { 
    update(record).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the set of service references retrieved by this service discovery.
   */
  public Set<io.vertx.mutiny.servicediscovery.ServiceReference> bindings() { 
    Set<io.vertx.mutiny.servicediscovery.ServiceReference> ret = delegate.bindings().stream().map(elt -> io.vertx.mutiny.servicediscovery.ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  /**
   * @return the discovery options. Modifying the returned object would not update the discovery service configuration. This object should be considered as read-only.
   */
  public io.vertx.servicediscovery.ServiceDiscoveryOptions options() { 
    io.vertx.servicediscovery.ServiceDiscoveryOptions ret = delegate.options();
    return ret;
  }

  /**
   * @param discovery the service discovery
   * @param svcObject the service object
   */
  public static void releaseServiceObject(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, java.lang.Object svcObject) { 
    io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject(discovery.getDelegate(), svcObject);
  }

  public static  ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
    return arg != null ? new ServiceDiscovery(arg) : null;
  }

}
