package io.vertx.mutiny.servicediscovery.spi;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * The publisher is used by the importer to publish or unpublish records.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.spi.ServicePublisher original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.spi.ServicePublisher.class)
public class ServicePublisher {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServicePublisher> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServicePublisher((io.vertx.servicediscovery.spi.ServicePublisher) obj),
    ServicePublisher::getDelegate
  );

  private final io.vertx.servicediscovery.spi.ServicePublisher delegate;
  
  public ServicePublisher(io.vertx.servicediscovery.spi.ServicePublisher delegate) {
    this.delegate = delegate;
  }

  public ServicePublisher(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.spi.ServicePublisher)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServicePublisher() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.spi.ServicePublisher getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServicePublisher that = (ServicePublisher) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Publishes a record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record the record
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> publish(io.vertx.servicediscovery.Record record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.publish(record, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#publish(Record)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record the record
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record publishAndAwait(io.vertx.servicediscovery.Record record) { 
    return (io.vertx.servicediscovery.Record) publish(record).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#publish(Record)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#publish(Record)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#publish(Record)} but you don't need to compose it with other operations.
   * @param record the record
   */
  public void publishAndForget(io.vertx.servicediscovery.Record record) { 
    publish(record).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Un-publishes a record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the registration id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unpublish(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.unpublish(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#unpublish(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the registration id
   * @return the Void instance produced by the operation.
   */
  public Void unpublishAndAwait(String id) { 
    return (Void) unpublish(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#unpublish(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#unpublish(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#unpublish(String)} but you don't need to compose it with other operations.
   * @param id the registration id
   */
  public void unpublishAndForget(String id) { 
    unpublish(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Updates an existing record.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record the record
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.servicediscovery.Record> update(io.vertx.servicediscovery.Record record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.update(record, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#update(Record)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record the record
   * @return the Record instance produced by the operation.
   */
  public io.vertx.servicediscovery.Record updateAndAwait(io.vertx.servicediscovery.Record record) { 
    return (io.vertx.servicediscovery.Record) update(record).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#update(Record)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#update(Record)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.spi.ServicePublisher#update(Record)} but you don't need to compose it with other operations.
   * @param record the record
   */
  public void updateAndForget(io.vertx.servicediscovery.Record record) { 
    update(record).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  ServicePublisher newInstance(io.vertx.servicediscovery.spi.ServicePublisher arg) {
    return arg != null ? new ServicePublisher(arg) : null;
  }

}
