package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 *  for event bus services (service proxies).
 * Consumers receive a service proxy to use the service.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.EventBusService original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.EventBusService.class)
public class EventBusService {

  public static final io.smallrye.mutiny.vertx.TypeArg<EventBusService> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new EventBusService((io.vertx.servicediscovery.types.EventBusService) obj),
    EventBusService::getDelegate
  );

  private final io.vertx.servicediscovery.types.EventBusService delegate;
  
  public EventBusService(io.vertx.servicediscovery.types.EventBusService delegate) {
    this.delegate = delegate;
  }

  public EventBusService(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.EventBusService)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  EventBusService() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.EventBusService getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBusService that = (EventBusService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name of the service.
   * @param address the event bus address on which the service available
   * @param itf the Java interface (name)
   * @param metadata the metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String address, String itf, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, itf, metadata);
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<T> getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.EventBusService.getServiceProxy(discovery.getDelegate(), filter, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clientClass), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.smallrye.mutiny.vertx.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @return the T instance produced by the operation.
   */
  public static <T> T getServiceProxyAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass) { 
    return (T) getServiceProxy(discovery, filter, clientClass).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class)} but you don't need to compose it with other operations.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   */
  public static <T> void getServiceProxyAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass) { 
    getServiceProxy(discovery, filter, clientClass).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<T> getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.EventBusService.getServiceProxy(discovery.getDelegate(), filter, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clientClass), conf, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.smallrye.mutiny.vertx.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @return the T instance produced by the operation.
   */
  public static <T> T getServiceProxyAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    return (T) getServiceProxy(discovery, filter, clientClass, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxy(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,Class,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   */
  public static <T> void getServiceProxyAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    getServiceProxy(discovery, filter, clientClass, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<T> getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.EventBusService.getServiceProxyWithJsonFilter(discovery.getDelegate(), filter, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clientClass), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.smallrye.mutiny.vertx.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @return the T instance produced by the operation.
   */
  public static <T> T getServiceProxyWithJsonFilterAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass) { 
    return (T) getServiceProxyWithJsonFilter(discovery, filter, clientClass).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class)} but you don't need to compose it with other operations.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   */
  public static <T> void getServiceProxyWithJsonFilterAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass) { 
    getServiceProxyWithJsonFilter(discovery, filter, clientClass).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<T> getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.EventBusService.getServiceProxyWithJsonFilter(discovery.getDelegate(), filter, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(clientClass), conf, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.smallrye.mutiny.vertx.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @return the T instance produced by the operation.
   */
  public static <T> T getServiceProxyWithJsonFilterAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    return (T) getServiceProxyWithJsonFilter(discovery, filter, clientClass, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.EventBusService#getServiceProxyWithJsonFilter(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,Class,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   */
  public static <T> void getServiceProxyWithJsonFilterAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, java.lang.Class<T> clientClass, JsonObject conf) { 
    getServiceProxyWithJsonFilter(discovery, filter, clientClass, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param name the service name
   * @param address the address
   * @param classname the payload class
   * @return the record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String address, String classname) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, classname);
    return ret;
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.EventBusService.UNKNOWN;
  /**
   * Name of the type.
   */
  public static final String TYPE = io.vertx.servicediscovery.types.EventBusService.TYPE;
  public static  EventBusService newInstance(io.vertx.servicediscovery.types.EventBusService arg) {
    return arg != null ? new EventBusService(arg) : null;
  }

}
