package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 * Service type for Redis data source.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.RedisDataSource original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.RedisDataSource.class)
public class RedisDataSource {

  public static final io.smallrye.mutiny.vertx.TypeArg<RedisDataSource> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RedisDataSource((io.vertx.servicediscovery.types.RedisDataSource) obj),
    RedisDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.RedisDataSource delegate;
  
  public RedisDataSource(io.vertx.servicediscovery.types.RedisDataSource delegate) {
    this.delegate = delegate;
  }

  public RedisDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.RedisDataSource)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RedisDataSource() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.RedisDataSource getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisDataSource that = (RedisDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.RedisDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.mutiny.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Redis> getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.redis.client.Redis>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the Redis instance produced by the operation.
   */
  public static io.vertx.mutiny.redis.client.Redis getRedisClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.redis.client.Redis) getRedisClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getRedisClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getRedisClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.mutiny.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Redis> getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.redis.client.Redis>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @return the Redis instance produced by the operation.
   */
  public static io.vertx.mutiny.redis.client.Redis getRedisClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.redis.client.Redis) getRedisClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   */
  public static void getRedisClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getRedisClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.mutiny.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Redis> getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.client.Redis>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @return the Redis instance produced by the operation.
   */
  public static io.vertx.mutiny.redis.client.Redis getRedisClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return (io.vertx.mutiny.redis.client.Redis) getRedisClient(discovery, filter, consumerConfiguration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   */
  public static void getRedisClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    getRedisClient(discovery, filter, consumerConfiguration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.mutiny.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Redis> getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.client.Redis>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @return the Redis instance produced by the operation.
   */
  public static io.vertx.mutiny.redis.client.Redis getRedisClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return (io.vertx.mutiny.redis.client.Redis) getRedisClient(discovery, filter, consumerConfiguration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.RedisDataSource#getRedisClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   */
  public static void getRedisClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    getRedisClient(discovery, filter, consumerConfiguration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.RedisDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.RedisDataSource.TYPE;
  public static  RedisDataSource newInstance(io.vertx.servicediscovery.types.RedisDataSource arg) {
    return arg != null ? new RedisDataSource(arg) : null;
  }

}
