/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.servicediscovery;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.servicediscovery.ServiceReference;
import io.vertx.mutiny.servicediscovery.spi.ServiceExporter;
import io.vertx.mutiny.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {
    public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg(obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery)obj), ServiceDiscovery::getDelegate);
    private final io.vertx.servicediscovery.ServiceDiscovery delegate;
    static final TypeArg<ServiceReference> TYPE_ARG_0 = new TypeArg(o1 -> ServiceReference.newInstance((io.vertx.servicediscovery.ServiceReference)o1), o1 -> o1.getDelegate());

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public ServiceDiscovery(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.ServiceDiscovery)delegate;
    }

    ServiceDiscovery() {
        this.delegate = null;
    }

    public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDiscovery that = (ServiceDiscovery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static ServiceDiscovery create(io.vertx.mutiny.core.Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate(), (ServiceDiscoveryOptions)options));
        return ret;
    }

    public static ServiceDiscovery create(io.vertx.mutiny.core.Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release(reference.getDelegate());
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.registerServiceImporter(importer.getDelegate(), configuration, completionHandler));
    }

    public Void registerServiceImporterAndAwait(ServiceImporter importer, JsonObject configuration) {
        return (Void)this.registerServiceImporter(importer, configuration).await().indefinitely();
    }

    @Fluent
    public ServiceDiscovery registerServiceImporterAndForget(ServiceImporter importer, JsonObject configuration) {
        this.registerServiceImporter(importer, configuration).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.registerServiceExporter(exporter.getDelegate(), configuration, completionHandler));
    }

    public Void registerServiceExporterAndAwait(ServiceExporter exporter, JsonObject configuration) {
        return (Void)this.registerServiceExporter(exporter, configuration).await().indefinitely();
    }

    @Fluent
    public ServiceDiscovery registerServiceExporterAndForget(ServiceExporter exporter, JsonObject configuration) {
        this.registerServiceExporter(exporter, configuration).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    @CheckReturnValue
    public Uni<Record> publish(Record record) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.publish(record, resultHandler));
    }

    public Record publishAndAwait(Record record) {
        return (Record)this.publish(record).await().indefinitely();
    }

    public void publishAndForget(Record record) {
        this.publish(record).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> unpublish(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.unpublish(id, resultHandler));
    }

    public Void unpublishAndAwait(String id) {
        return (Void)this.unpublish(id).await().indefinitely();
    }

    public void unpublishAndForget(String id) {
        this.unpublish(id).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> getRecord(JsonObject filter) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecord(filter, resultHandler));
    }

    public Record getRecordAndAwait(JsonObject filter) {
        return (Record)this.getRecord(filter).await().indefinitely();
    }

    public void getRecordAndForget(JsonObject filter) {
        this.getRecord(filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> getRecord(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecord(id, resultHandler));
    }

    public Record getRecordAndAwait(String id) {
        return (Record)this.getRecord(id).await().indefinitely();
    }

    public void getRecordAndForget(String id) {
        this.getRecord(id).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> getRecord(Function<Record, Boolean> filter) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecord(filter, resultHandler));
    }

    public Record getRecordAndAwait(Function<Record, Boolean> filter) {
        return (Record)this.getRecord(filter).await().indefinitely();
    }

    public void getRecordAndForget(Function<Record, Boolean> filter) {
        this.getRecord(filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> getRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecord(filter, includeOutOfService, resultHandler));
    }

    public Record getRecordAndAwait(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return (Record)this.getRecord(filter, includeOutOfService).await().indefinitely();
    }

    public void getRecordAndForget(Function<Record, Boolean> filter, boolean includeOutOfService) {
        this.getRecord(filter, includeOutOfService).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<List<Record>> getRecords(JsonObject filter) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecords(filter, resultHandler));
    }

    public List<Record> getRecordsAndAwait(JsonObject filter) {
        return (List)this.getRecords(filter).await().indefinitely();
    }

    public void getRecordsAndForget(JsonObject filter) {
        this.getRecords(filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<List<Record>> getRecords(Function<Record, Boolean> filter) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecords(filter, resultHandler));
    }

    public List<Record> getRecordsAndAwait(Function<Record, Boolean> filter) {
        return (List)this.getRecords(filter).await().indefinitely();
    }

    public void getRecordsAndForget(Function<Record, Boolean> filter) {
        this.getRecords(filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<List<Record>> getRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getRecords(filter, includeOutOfService, resultHandler));
    }

    public List<Record> getRecordsAndAwait(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return (List)this.getRecords(filter, includeOutOfService).await().indefinitely();
    }

    public void getRecordsAndForget(Function<Record, Boolean> filter, boolean includeOutOfService) {
        this.getRecords(filter, includeOutOfService).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> update(Record record) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.update(record, resultHandler));
    }

    public Record updateAndAwait(Record record) {
        return (Record)this.update(record).await().indefinitely();
    }

    public void updateAndForget(Record record) {
        this.update(record).subscribe().with(UniHelper.NOOP);
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public ServiceDiscoveryOptions options() {
        ServiceDiscoveryOptions ret = this.delegate.options();
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Object)svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

