/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.servicediscovery.types;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.Record;
import java.util.function.Function;

@MutinyGen(value=io.vertx.servicediscovery.types.RedisDataSource.class)
public class RedisDataSource {
    public static final TypeArg<RedisDataSource> __TYPE_ARG = new TypeArg(obj -> new RedisDataSource((io.vertx.servicediscovery.types.RedisDataSource)obj), RedisDataSource::getDelegate);
    private final io.vertx.servicediscovery.types.RedisDataSource delegate;
    public static final String UNKNOWN = "unknown";
    public static final String TYPE = "redis";

    public RedisDataSource(io.vertx.servicediscovery.types.RedisDataSource delegate) {
        this.delegate = delegate;
    }

    public RedisDataSource(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.types.RedisDataSource)delegate;
    }

    RedisDataSource() {
        this.delegate = null;
    }

    public io.vertx.servicediscovery.types.RedisDataSource getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisDataSource that = (RedisDataSource)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Record ret = io.vertx.servicediscovery.types.RedisDataSource.createRecord((String)name, (JsonObject)location, (JsonObject)metadata);
        return ret;
    }

    @CheckReturnValue
    public static Uni<Redis> getRedisClient(ServiceDiscovery discovery, JsonObject filter) {
        return AsyncResultUni.toUni(resultHandler -> io.vertx.servicediscovery.types.RedisDataSource.getRedisClient((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (JsonObject)filter, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)((io.vertx.redis.client.Redis)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Redis getRedisClientAndAwait(ServiceDiscovery discovery, JsonObject filter) {
        return (Redis)RedisDataSource.getRedisClient(discovery, filter).await().indefinitely();
    }

    public static void getRedisClientAndForget(ServiceDiscovery discovery, JsonObject filter) {
        RedisDataSource.getRedisClient(discovery, filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public static Uni<Redis> getRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return AsyncResultUni.toUni(resultHandler -> io.vertx.servicediscovery.types.RedisDataSource.getRedisClient((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Function)filter, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)((io.vertx.redis.client.Redis)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Redis getRedisClientAndAwait(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return (Redis)RedisDataSource.getRedisClient(discovery, filter).await().indefinitely();
    }

    public static void getRedisClientAndForget(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        RedisDataSource.getRedisClient(discovery, filter).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public static Uni<Redis> getRedisClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        return AsyncResultUni.toUni(resultHandler -> io.vertx.servicediscovery.types.RedisDataSource.getRedisClient((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (JsonObject)filter, (JsonObject)consumerConfiguration, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)((io.vertx.redis.client.Redis)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Redis getRedisClientAndAwait(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        return (Redis)RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration).await().indefinitely();
    }

    public static void getRedisClientAndForget(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public static Uni<Redis> getRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        return AsyncResultUni.toUni(resultHandler -> io.vertx.servicediscovery.types.RedisDataSource.getRedisClient((io.vertx.servicediscovery.ServiceDiscovery)discovery.getDelegate(), (Function)filter, (JsonObject)consumerConfiguration, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)((io.vertx.redis.client.Redis)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Redis getRedisClientAndAwait(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        return (Redis)RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration).await().indefinitely();
    }

    public static void getRedisClientAndForget(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        RedisDataSource.getRedisClient(discovery, filter, consumerConfiguration).subscribe().with(UniHelper.NOOP);
    }

    public static RedisDataSource newInstance(io.vertx.servicediscovery.types.RedisDataSource arg) {
        return arg != null ? new RedisDataSource(arg) : null;
    }
}

