package io.vertx.mutiny.servicediscovery;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.Record;

/**
 * Once a consumer has chosen a service, it builds a {@link io.vertx.mutiny.servicediscovery.ServiceReference} managing the binding with the chosen
 * service provider.
 * <p>
 * The reference lets the consumer:
 * * access the service (via a proxy or a client) with the {@link io.vertx.mutiny.servicediscovery.ServiceReference#get} method
 * * release the reference - so the binding between the consumer and the provider is removed
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.ServiceReference original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.ServiceReference.class)
public class ServiceReference {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServiceReference> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServiceReference((io.vertx.servicediscovery.ServiceReference) obj),
    ServiceReference::getDelegate
  );

  private final io.vertx.servicediscovery.ServiceReference delegate;
  
  public ServiceReference(io.vertx.servicediscovery.ServiceReference delegate) {
    this.delegate = delegate;
  }

  public ServiceReference(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.ServiceReference)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServiceReference() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.ServiceReference getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceReference that = (ServiceReference) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the service record.
   */
  public io.vertx.servicediscovery.Record record() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.servicediscovery.Record ret = delegate.record();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the object to access the service
   */
  public <T> T get() { 
    T ret = (T) delegate.get();
    return ret;
  }

  /**
   * @param x the type of object
   * @return the object to access the service wrapped to the given type
   */
  public <X> X getAs(java.lang.Class<X> x) { 
    X ret = (X)io.smallrye.mutiny.vertx.TypeArg.of(x).wrap(delegate.getAs(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(x)));
    return ret;
  }

  /**
   * @param x the type of object
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <X> X cachedAs(java.lang.Class<X> x) { 
    X ret = (X)io.smallrye.mutiny.vertx.TypeArg.of(x).wrap(delegate.cachedAs(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(x)));
    return ret;
  }

  /**
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <T> T cached() { 
    T ret = (T) delegate.cached();
    return ret;
  }

  /**
   */
  public void release() { 
    delegate.release();
  }

  /**
   * @param object the service object, must not be <code>null</code>
   * @return <code>true</code> if the service reference service object is equal to the given object, <code>false</code> otherwise.
   */
  public boolean isHolding(java.lang.Object object) { 
    boolean ret = delegate.isHolding(object);
    return ret;
  }

  private io.vertx.servicediscovery.Record cached_0;
  public static  ServiceReference newInstance(io.vertx.servicediscovery.ServiceReference arg) {
    return arg != null ? new ServiceReference(arg) : null;
  }

}
