package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.JDBCDataSource original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.JDBCDataSource.class)
public class JDBCDataSource {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCDataSource> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCDataSource((io.vertx.servicediscovery.types.JDBCDataSource) obj),
    JDBCDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.JDBCDataSource delegate;
  
  public JDBCDataSource(io.vertx.servicediscovery.types.JDBCDataSource delegate) {
    this.delegate = delegate;
  }

  public JDBCDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.JDBCDataSource)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCDataSource() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.JDBCDataSource getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCDataSource that = (JDBCDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static io.vertx.servicediscovery.Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.JDBCDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.mutiny.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.jdbc.JDBCClient> getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the JDBCClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient getJDBCClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.ext.jdbc.JDBCClient) getJDBCClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getJDBCClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getJDBCClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.mutiny.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.jdbc.JDBCClient> getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @return the JDBCClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient getJDBCClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.ext.jdbc.JDBCClient) getJDBCClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   */
  public static void getJDBCClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getJDBCClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.mutiny.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.jdbc.JDBCClient> getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return the JDBCClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient getJDBCClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return (io.vertx.mutiny.ext.jdbc.JDBCClient) getJDBCClient(discovery, filter, consumerConfiguration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   */
  public static void getJDBCClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    getJDBCClient(discovery, filter, consumerConfiguration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.mutiny.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.jdbc.JDBCClient> getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @return the JDBCClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.jdbc.JDBCClient getJDBCClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return (io.vertx.mutiny.ext.jdbc.JDBCClient) getJDBCClient(discovery, filter, consumerConfiguration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.JDBCDataSource#getJDBCClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   */
  public static void getJDBCClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    getJDBCClient(discovery, filter, consumerConfiguration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.JDBCDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.JDBCDataSource.TYPE;
  public static  JDBCDataSource newInstance(io.vertx.servicediscovery.types.JDBCDataSource arg) {
    return arg != null ? new JDBCDataSource(arg) : null;
  }

}
