/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.servicediscovery.spi;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.servicediscovery.Record;

@MutinyGen(value=io.vertx.servicediscovery.spi.ServicePublisher.class)
public class ServicePublisher {
    public static final TypeArg<ServicePublisher> __TYPE_ARG = new TypeArg(obj -> new ServicePublisher((io.vertx.servicediscovery.spi.ServicePublisher)obj), ServicePublisher::getDelegate);
    private final io.vertx.servicediscovery.spi.ServicePublisher delegate;

    public ServicePublisher(io.vertx.servicediscovery.spi.ServicePublisher delegate) {
        this.delegate = delegate;
    }

    public ServicePublisher(Object delegate) {
        this.delegate = (io.vertx.servicediscovery.spi.ServicePublisher)delegate;
    }

    ServicePublisher() {
        this.delegate = null;
    }

    public io.vertx.servicediscovery.spi.ServicePublisher getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePublisher that = (ServicePublisher)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<Record> publish(Record record) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.publish(record, resultHandler));
    }

    public Record publishAndAwait(Record record) {
        return (Record)this.publish(record).await().indefinitely();
    }

    public void publishAndForget(Record record) {
        this.publish(record).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> unpublish(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.unpublish(id, resultHandler));
    }

    public Void unpublishAndAwait(String id) {
        return (Void)this.unpublish(id).await().indefinitely();
    }

    public void unpublishAndForget(String id) {
        this.unpublish(id).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Record> update(Record record) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.update(record, resultHandler));
    }

    public Record updateAndAwait(Record record) {
        return (Record)this.update(record).await().indefinitely();
    }

    public void updateAndForget(Record record) {
        this.update(record).subscribe().with(UniHelper.NOOP);
    }

    public static ServicePublisher newInstance(io.vertx.servicediscovery.spi.ServicePublisher arg) {
        return arg != null ? new ServicePublisher(arg) : null;
    }
}

