package io.vertx.mutiny.sqlclient.spi;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Contains static metadata about the backend database server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.spi.DatabaseMetadata original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.spi.DatabaseMetadata.class)
public class DatabaseMetadata {

  public static final io.smallrye.mutiny.vertx.TypeArg<DatabaseMetadata> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DatabaseMetadata((io.vertx.sqlclient.spi.DatabaseMetadata) obj),
    DatabaseMetadata::getDelegate
  );

  private final io.vertx.sqlclient.spi.DatabaseMetadata delegate;
  
  public DatabaseMetadata(io.vertx.sqlclient.spi.DatabaseMetadata delegate) {
    this.delegate = delegate;
  }

  public DatabaseMetadata(Object delegate) {
    this.delegate = (io.vertx.sqlclient.spi.DatabaseMetadata)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DatabaseMetadata() {
    this.delegate = null;
  }

  public io.vertx.sqlclient.spi.DatabaseMetadata getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatabaseMetadata that = (DatabaseMetadata) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return The product name of the backend database server
   */
  public String productName() { 
    String ret = delegate.productName();
    return ret;
  }

  /**
   * @return The full version string for the backend database server. This may be useful for for parsing more subtle aspects of the version string. For simple information like database major and minor version, use {@link io.vertx.mutiny.sqlclient.spi.DatabaseMetadata#majorVersion} and {@link io.vertx.mutiny.sqlclient.spi.DatabaseMetadata#minorVersion} instead.
   */
  public String fullVersion() { 
    String ret = delegate.fullVersion();
    return ret;
  }

  /**
   * @return The major version of the backend database server
   */
  public int majorVersion() { 
    int ret = delegate.majorVersion();
    return ret;
  }

  /**
   * @return The minor version of the backend database server
   */
  public int minorVersion() { 
    int ret = delegate.minorVersion();
    return ret;
  }

  public static  DatabaseMetadata newInstance(io.vertx.sqlclient.spi.DatabaseMetadata arg) {
    return arg != null ? new DatabaseMetadata(arg) : null;
  }

}
