package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A cursor that reads progressively rows from the database, it is useful for reading very large result sets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Cursor original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Cursor.class)
public class Cursor {

  public static final io.smallrye.mutiny.vertx.TypeArg<Cursor> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Cursor((io.vertx.sqlclient.Cursor) obj),
    Cursor::getDelegate
  );

  private final io.vertx.sqlclient.Cursor delegate;
  
  public Cursor(io.vertx.sqlclient.Cursor delegate) {
    this.delegate = delegate;
  }

  public Cursor(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Cursor)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Cursor() {
    this.delegate = null;
  }

  public io.vertx.sqlclient.Cursor getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Cursor that = (Cursor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param count the amount of rows to read
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> read(int count) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.read(count, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)event, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o0 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate())))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Cursor#read(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param count the amount of rows to read
   * @return the RowSet<Row> instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row> readAndAwait(int count) { 
    return (io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>) read(count).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Cursor#read(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Cursor#read(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Cursor#read(int)} but you don't need to compose it with other operations.
   * @param count the amount of rows to read
   */
  public void readAndForget(int count) { 
    read(count).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return whether the cursor has more results,
   */
  public boolean hasMore() { 
    boolean ret = delegate.hasMore();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.Cursor#close} but with a <code>completionHandler</code> called when the cursor has been released.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Cursor#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Cursor#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Cursor#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Cursor#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return whether the cursor is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public static  Cursor newInstance(io.vertx.sqlclient.Cursor arg) {
    return arg != null ? new Cursor(arg) : null;
  }

}
