package io.vertx.mutiny.sqlclient.desc;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.sql.JDBCType;

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.desc.ColumnDescriptor.class)
public class ColumnDescriptor {

  public static final io.smallrye.mutiny.vertx.TypeArg<ColumnDescriptor> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ColumnDescriptor((io.vertx.sqlclient.desc.ColumnDescriptor) obj),
    ColumnDescriptor::getDelegate
  );

  private final io.vertx.sqlclient.desc.ColumnDescriptor delegate;
  
  public ColumnDescriptor(io.vertx.sqlclient.desc.ColumnDescriptor delegate) {
    this.delegate = delegate;
  }

  public ColumnDescriptor(Object delegate) {
    this.delegate = (io.vertx.sqlclient.desc.ColumnDescriptor)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ColumnDescriptor() {
    this.delegate = null;
  }

  public io.vertx.sqlclient.desc.ColumnDescriptor getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ColumnDescriptor that = (ColumnDescriptor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the column name
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return whether the column is an array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return vendor-specific name of the column type, or <code>null</code> if unknown
   */
  public String typeName() { 
    String ret = delegate.typeName();
    return ret;
  }

  /**
   * @return the most appropriate <code>JDBCType</code>
   */
  public java.sql.JDBCType jdbcType() { 
    java.sql.JDBCType ret = delegate.jdbcType();
    return ret;
  }

  public static  ColumnDescriptor newInstance(io.vertx.sqlclient.desc.ColumnDescriptor arg) {
    return arg != null ? new ColumnDescriptor(arg) : null;
  }

}
