package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A prepared statement, the statement is pre-compiled and it's more efficient to execute the statement for multiple times.
 * In addition, this kind of statement provides protection against SQL injection attacks.
 *
 * <p>From a prepared statement you can
 *
 * <ul>
 *   <li>use {@link io.vertx.mutiny.sqlclient.PreparedStatement#query} to create and execute a {@link io.vertx.mutiny.sqlclient.PreparedQuery}</li>
 *   <li>use {@link io.vertx.mutiny.sqlclient.PreparedStatement#cursor} to create a {@link io.vertx.mutiny.sqlclient.Cursor}</li>
 *   <li>use {@link io.vertx.mutiny.sqlclient.PreparedStatement#createStream} to create a {@link io.vertx.mutiny.sqlclient.RowStream}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedStatement original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.PreparedStatement.class)
public class PreparedStatement {

  public static final io.smallrye.mutiny.vertx.TypeArg<PreparedStatement> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PreparedStatement((io.vertx.sqlclient.PreparedStatement) obj),
    PreparedStatement::getDelegate
  );

  private final io.vertx.sqlclient.PreparedStatement delegate;
  
  public PreparedStatement(io.vertx.sqlclient.PreparedStatement delegate) {
    this.delegate = delegate;
  }

  public PreparedStatement(Object delegate) {
    this.delegate = (io.vertx.sqlclient.PreparedStatement)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PreparedStatement() {
    this.delegate = null;
  }

  public io.vertx.sqlclient.PreparedStatement getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.Row> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.sqlclient.Row>(o1 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.Row> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.sqlclient.Row>(o1 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedStatement that = (PreparedStatement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the prepared query
   */
  public io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> query() { 
    io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.query(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.mutiny.sqlclient.Cursor cursor() { 
    io.vertx.mutiny.sqlclient.Cursor ret = io.vertx.mutiny.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor());
    return ret;
  }

  /**
   * @param args the list of arguments
   * @return the query
   */
  public io.vertx.mutiny.sqlclient.Cursor cursor(io.vertx.mutiny.sqlclient.Tuple args) { 
    io.vertx.mutiny.sqlclient.Cursor ret = io.vertx.mutiny.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor(args.getDelegate()));
    return ret;
  }

  /**
   * @param fetch 
   * @return 
   */
  public io.vertx.mutiny.sqlclient.RowStream<io.vertx.mutiny.sqlclient.Row> createStream(int fetch) { 
    io.vertx.mutiny.sqlclient.RowStream<io.vertx.mutiny.sqlclient.Row> ret = io.vertx.mutiny.sqlclient.RowStream.newInstance((io.vertx.sqlclient.RowStream)delegate.createStream(fetch), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param fetch the cursor fetch size
   * @param args the prepared query arguments
   * @return the createStream
   */
  public io.vertx.mutiny.sqlclient.RowStream<io.vertx.mutiny.sqlclient.Row> createStream(int fetch, io.vertx.mutiny.sqlclient.Tuple args) { 
    io.vertx.mutiny.sqlclient.RowStream<io.vertx.mutiny.sqlclient.Row> ret = io.vertx.mutiny.sqlclient.RowStream.newInstance((io.vertx.sqlclient.RowStream)delegate.createStream(fetch, args.getDelegate()), TYPE_ARG_2);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.PreparedStatement#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.PreparedStatement#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.PreparedStatement#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.PreparedStatement#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  PreparedStatement newInstance(io.vertx.sqlclient.PreparedStatement arg) {
    return arg != null ? new PreparedStatement(arg) : null;
  }

}
