package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Defines common SQL client operations with a database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.SqlClient.class)
public class SqlClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<SqlClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SqlClient((io.vertx.sqlclient.SqlClient) obj),
    SqlClient::getDelegate
  );

  private final io.vertx.sqlclient.SqlClient delegate;
  
  public SqlClient(io.vertx.sqlclient.SqlClient delegate) {
    this.delegate = delegate;
  }

  public SqlClient(Object delegate) {
    this.delegate = (io.vertx.sqlclient.SqlClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SqlClient() {
    this.delegate = null;
  }

  public io.vertx.sqlclient.SqlClient getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlClient that = (SqlClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param sql 
   * @return the query
   */
  public io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> query(String sql) { 
    io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param sql 
   * @return the prepared query
   */
  public io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> preparedQuery(String sql) { 
    io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param sql 
   * @param options 
   * @return the prepared query
   */
  public io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> preparedQuery(String sql, io.vertx.sqlclient.PrepareOptions options) { 
    io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql, options), TYPE_ARG_2);
    return ret;
  }

  /**
   * Close the client and release the associated resources.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.SqlClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.SqlClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.SqlClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.SqlClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  SqlClient newInstance(io.vertx.sqlclient.SqlClient arg) {
    return arg != null ? new SqlClient(arg) : null;
  }

}
