package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.time.OffsetTime;
import java.time.LocalDateTime;
import java.util.UUID;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.core.json.JsonArray;
import java.math.BigDecimal;
import java.util.List;
import java.time.OffsetDateTime;
import java.time.LocalDate;
import java.time.LocalTime;
import io.vertx.core.json.JsonObject;
import java.time.temporal.Temporal;

/**
 * A general purpose tuple.
 * <p>
 * <em>CAUTION:</em> indexes start at 0, not at 1.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Tuple original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Tuple.class)
public class Tuple implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Tuple> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Tuple((io.vertx.sqlclient.Tuple) obj),
    Tuple::getDelegate
  );

  private final io.vertx.sqlclient.Tuple delegate;
  
  public Tuple(io.vertx.sqlclient.Tuple delegate) {
    this.delegate = delegate;
  }

  public Tuple(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Tuple)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Tuple() {
    this.delegate = null;
  }

  @Override
  public io.vertx.sqlclient.Tuple getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Tuple that = (Tuple) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a new empty tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple tuple() { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.tuple());
    return ret;
  }

  /**
   * @param list 
   * @return the list wrapped as a tuple
   */
  public static <T> io.vertx.mutiny.sqlclient.Tuple from(List<T> list) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.from(list));
    return ret;
  }

  /**
   * @param list 
   * @return the list wrapped as a tuple
   */
  public static <T> io.vertx.mutiny.sqlclient.Tuple wrap(List<T> list) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.wrap(list));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @param elt2 the second value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4, java.lang.Object elt5) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5));
    return ret;
  }

  /**
   * @param elt1 the first value
   * @param elt2 the second valueg
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @param elt6 the sixth value
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4, java.lang.Object elt5, java.lang.Object elt6) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5, elt6));
    return ret;
  }

  /**
   * @param elements the list of elements
   * @return the tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple tuple(List<java.lang.Object> elements) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.tuple(elements));
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Object getValue(int pos) { 
    java.lang.Object ret = (Object) delegate.getValue(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Boolean getBoolean(int pos) { 
    Boolean ret = delegate.getBoolean(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Short getShort(int pos) { 
    Short ret = delegate.getShort(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Integer getInteger(int pos) { 
    Integer ret = delegate.getInteger(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Long getLong(int pos) { 
    Long ret = delegate.getLong(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Float getFloat(int pos) { 
    Float ret = delegate.getFloat(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public Double getDouble(int pos) { 
    Double ret = delegate.getDouble(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public String getString(int pos) { 
    String ret = delegate.getString(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public JsonObject getJsonObject(int pos) { 
    JsonObject ret = delegate.getJsonObject(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public JsonArray getJsonArray(int pos) { 
    JsonArray ret = delegate.getJsonArray(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Object getJson(int pos) { 
    java.lang.Object ret = (Object) delegate.getJson(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public io.vertx.mutiny.core.buffer.Buffer getBuffer(int pos) { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(pos));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addValue(java.lang.Object value) { 
    delegate.addValue(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addBoolean(Boolean value) { 
    delegate.addBoolean(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addShort(Short value) { 
    delegate.addShort(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addInteger(Integer value) { 
    delegate.addInteger(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addLong(Long value) { 
    delegate.addLong(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addFloat(Float value) { 
    delegate.addFloat(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addDouble(Double value) { 
    delegate.addDouble(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addString(String value) { 
    delegate.addString(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addJsonObject(JsonObject value) { 
    delegate.addJsonObject(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addJsonArray(JsonArray value) { 
    delegate.addJsonArray(value);
    return this;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.sqlclient.Tuple addBuffer(io.vertx.mutiny.core.buffer.Buffer value) { 
    delegate.addBuffer(value.getDelegate());
    return this;
  }

  /**
   * @param type the expected value type
   * @param position the value position
   * @return the value if the value is found or null.
   */
  public <T> T get(java.lang.Class<T> type, int position) { 
    T ret = (T)io.smallrye.mutiny.vertx.TypeArg.of(type).wrap(delegate.get(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type), position));
    return ret;
  }

  /**
   * @return the tuple size
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public void clear() { 
    delegate.clear();
  }

  /**
   * @return A String containing the {@link java.lang.Object} value of each element, separated by a comma (,) character
   */
  public String deepToString() { 
    String ret = delegate.deepToString();
    return ret;
  }

  /**
   * @param array 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple from(java.lang.Object[] array) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.from(array));
    return ret;
  }

  /**
   * @param array 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.mutiny.sqlclient.Tuple wrap(java.lang.Object[] array) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.wrap(array));
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public io.vertx.sqlclient.data.Numeric getNumeric(int pos) { 
    io.vertx.sqlclient.data.Numeric ret = delegate.getNumeric(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.temporal.Temporal getTemporal(int pos) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalDate getLocalDate(int pos) { 
    java.time.LocalDate ret = delegate.getLocalDate(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalTime getLocalTime(int pos) { 
    java.time.LocalTime ret = delegate.getLocalTime(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalDateTime getLocalDateTime(int pos) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.OffsetTime getOffsetTime(int pos) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.OffsetDateTime getOffsetDateTime(int pos) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.util.UUID getUUID(int pos) { 
    java.util.UUID ret = delegate.getUUID(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.math.BigDecimal getBigDecimal(int pos) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Boolean[] getArrayOfBooleans(int pos) { 
    java.lang.Boolean[] ret = delegate.getArrayOfBooleans(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Short[] getArrayOfShorts(int pos) { 
    java.lang.Short[] ret = delegate.getArrayOfShorts(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Integer[] getArrayOfIntegers(int pos) { 
    java.lang.Integer[] ret = delegate.getArrayOfIntegers(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Long[] getArrayOfLongs(int pos) { 
    java.lang.Long[] ret = delegate.getArrayOfLongs(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Float[] getArrayOfFloats(int pos) { 
    java.lang.Float[] ret = delegate.getArrayOfFloats(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Double[] getArrayOfDoubles(int pos) { 
    java.lang.Double[] ret = delegate.getArrayOfDoubles(pos);
    return ret;
  }

  /**
   * @param pos the column
   * @return the value
   */
  public io.vertx.sqlclient.data.Numeric[] getArrayOfNumerics(int pos) { 
    io.vertx.sqlclient.data.Numeric[] ret = delegate.getArrayOfNumerics(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.String[] getArrayOfStrings(int pos) { 
    java.lang.String[] ret = delegate.getArrayOfStrings(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public io.vertx.core.json.JsonObject[] getArrayOfJsonObjects(int pos) { 
    io.vertx.core.json.JsonObject[] ret = delegate.getArrayOfJsonObjects(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public io.vertx.core.json.JsonArray[] getArrayOfJsonArrays(int pos) { 
    io.vertx.core.json.JsonArray[] ret = delegate.getArrayOfJsonArrays(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.lang.Object[] getArrayOfJsons(int pos) { 
    java.lang.Object[] ret = delegate.getArrayOfJsons(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.temporal.Temporal[] getArrayOfTemporals(int pos) { 
    java.time.temporal.Temporal[] ret = delegate.getArrayOfTemporals(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalDate[] getArrayOfLocalDates(int pos) { 
    java.time.LocalDate[] ret = delegate.getArrayOfLocalDates(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalTime[] getArrayOfLocalTimes(int pos) { 
    java.time.LocalTime[] ret = delegate.getArrayOfLocalTimes(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.LocalDateTime[] getArrayOfLocalDateTimes(int pos) { 
    java.time.LocalDateTime[] ret = delegate.getArrayOfLocalDateTimes(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.OffsetTime[] getArrayOfOffsetTimes(int pos) { 
    java.time.OffsetTime[] ret = delegate.getArrayOfOffsetTimes(pos);
    return ret;
  }

  /**
   * @param pos the position
   * @return the value
   */
  public java.time.OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) { 
    java.time.OffsetDateTime[] ret = delegate.getArrayOfOffsetDateTimes(pos);
    return ret;
  }

  /**
   * @param pos the column
   * @return the value
   */
  public java.util.UUID[] getArrayOfUUIDs(int pos) { 
    java.util.UUID[] ret = delegate.getArrayOfUUIDs(pos);
    return ret;
  }

  /**
   * @param pos the column
   * @return the value
   */
  public java.math.BigDecimal[] getArrayOfBigDecimals(int pos) { 
    java.math.BigDecimal[] ret = delegate.getArrayOfBigDecimals(pos);
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addTemporal(java.time.temporal.Temporal value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addTemporal(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addLocalDate(java.time.LocalDate value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDate(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addLocalTime(java.time.LocalTime value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addLocalDateTime(java.time.LocalDateTime value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDateTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addOffsetTime(java.time.OffsetTime value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addOffsetDateTime(java.time.OffsetDateTime value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetDateTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addUUID(java.util.UUID value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addUUID(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addBigDecimal(java.math.BigDecimal value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addBigDecimal(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfBoolean(java.lang.Boolean[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfBoolean(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfShort(java.lang.Short[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfShort(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfInteger(java.lang.Integer[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfInteger(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfLong(java.lang.Long[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfLong(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfFloat(java.lang.Float[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfFloat(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfDouble(java.lang.Double[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfDouble(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfString(java.lang.String[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfString(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfJsonObject(io.vertx.core.json.JsonObject[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfJsonObject(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfJsonArray(io.vertx.core.json.JsonArray[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfJsonArray(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfTemporal(java.time.temporal.Temporal[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfTemporal(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfLocalDate(java.time.LocalDate[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfLocalDate(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfLocalTime(java.time.LocalTime[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfLocalTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfLocalDateTime(java.time.LocalDateTime[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfLocalDateTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfOffsetTime(java.time.OffsetTime[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfOffsetTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfOffsetDateTime(java.time.OffsetDateTime[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfOffsetDateTime(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfUUID(java.util.UUID[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfUUID(value));
    return ret;
  }

  /**
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.sqlclient.Tuple addArrayOfBigDecimal(java.math.BigDecimal[] value) { 
    io.vertx.mutiny.sqlclient.Tuple ret = io.vertx.mutiny.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addArrayOfBigDecimal(value));
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final Object JSON_NULL = (Object) io.vertx.sqlclient.Tuple.JSON_NULL;
  public static  Tuple newInstance(io.vertx.sqlclient.Tuple arg) {
    return arg != null ? new Tuple(arg) : null;
  }

}
