package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Interface implemented to customize the destination creation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.DestinationFactory original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.DestinationFactory.class)
public class DestinationFactory {

  public static final io.smallrye.mutiny.vertx.TypeArg<DestinationFactory> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DestinationFactory((io.vertx.ext.stomp.DestinationFactory) obj),
    DestinationFactory::getDelegate
  );

  private final io.vertx.ext.stomp.DestinationFactory delegate;
  
  public DestinationFactory(io.vertx.ext.stomp.DestinationFactory delegate) {
    this.delegate = delegate;
  }

  public DestinationFactory(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.DestinationFactory)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DestinationFactory() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.DestinationFactory getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DestinationFactory that = (DestinationFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance used by the STOMP server.
   * @param name the destination name.
   * @return the destination, <code>null</code> to reject the creation.
   */
  public io.vertx.mutiny.ext.stomp.Destination create(io.vertx.mutiny.core.Vertx vertx, String name) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.create(vertx.getDelegate(), name));
    return ret;
  }

  public static  DestinationFactory newInstance(io.vertx.ext.stomp.DestinationFactory arg) {
    return arg != null ? new DestinationFactory(arg) : null;
  }

}
