package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.Frame;

/**
 * Structure passed to server handler when receiving a frame. It provides a reference on the received {@link io.vertx.ext.stomp.Frame}
 * but also on the {@link io.vertx.mutiny.ext.stomp.StompServerConnection}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.ServerFrame original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.ServerFrame.class)
public class ServerFrame {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServerFrame> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServerFrame((io.vertx.ext.stomp.ServerFrame) obj),
    ServerFrame::getDelegate
  );

  private final io.vertx.ext.stomp.ServerFrame delegate;
  
  public ServerFrame(io.vertx.ext.stomp.ServerFrame delegate) {
    this.delegate = delegate;
  }

  public ServerFrame(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.ServerFrame)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServerFrame() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.ServerFrame getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerFrame that = (ServerFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the received frame
   */
  public io.vertx.ext.stomp.Frame frame() { 
    io.vertx.ext.stomp.Frame ret = delegate.frame();
    return ret;
  }

  /**
   * @return the connection
   */
  public io.vertx.mutiny.ext.stomp.StompServerConnection connection() { 
    io.vertx.mutiny.ext.stomp.StompServerConnection ret = io.vertx.mutiny.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)delegate.connection());
    return ret;
  }

  public static  ServerFrame newInstance(io.vertx.ext.stomp.ServerFrame arg) {
    return arg != null ? new ServerFrame(arg) : null;
  }

}
