package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.Frame;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Once a connection to the STOMP server has been made, client receives a {@link io.vertx.mutiny.ext.stomp.StompClientConnection}, that let
 * send and receive STOMP frames.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompClientConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.StompClientConnection.class)
public class StompClientConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<StompClientConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new StompClientConnection((io.vertx.ext.stomp.StompClientConnection) obj),
    StompClientConnection::getDelegate
  );

  private final io.vertx.ext.stomp.StompClientConnection delegate;
  
  public StompClientConnection(io.vertx.ext.stomp.StompClientConnection delegate) {
    this.delegate = delegate;
  }

  public StompClientConnection(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompClientConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  StompClientConnection() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.StompClientConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompClientConnection that = (StompClientConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the session id.
   */
  public String session() { 
    String ret = delegate.session();
    return ret;
  }

  /**
   * @return the STOMP protocol version negotiated with the server.
   */
  public String version() { 
    String ret = delegate.version();
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the server name.
   */
  public String server() { 
    String ret = delegate.server();
    return ret;
  }

  /**
   * Sends a <code>SEND</code> frame to the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param headers the headers, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> send(java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.send(headers, body.getDelegate(), receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Map,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param headers the headers, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame sendAndAwait(java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (io.vertx.ext.stomp.Frame) send(headers, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Map,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Map,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Map,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param headers the headers, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection sendAndForget(java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    send(headers, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a <code>SEND</code> frame to the server to the given destination. The message does not have any other header.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> send(String destination, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.send(destination, body.getDelegate(), receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame sendAndAwait(String destination, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (io.vertx.ext.stomp.Frame) send(destination, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param destination the destination, must not be <code>null</code>
   * @param body the body, may be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection sendAndForget(String destination, io.vertx.mutiny.core.buffer.Buffer body) { 
    send(destination, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends the given frame to the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame the frame
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> send(io.vertx.ext.stomp.Frame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.send(frame, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Frame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame the frame
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame sendAndAwait(io.vertx.ext.stomp.Frame frame) { 
    return (io.vertx.ext.stomp.Frame) send(frame).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Frame)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Frame)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(Frame)} but you don't need to compose it with other operations.
   * @param frame the frame
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection sendAndForget(io.vertx.ext.stomp.Frame frame) { 
    send(frame).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a <code>SEND</code> frame to the server to the given destination.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination, must not be <code>null</code>
   * @param headers the header. The <code>destination</code> header is replaced by the value given to the <code>destination</code> parameter
   * @param body the body, may be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> send(String destination, java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.send(destination, headers, body.getDelegate(), receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,Map,io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination, must not be <code>null</code>
   * @param headers the header. The <code>destination</code> header is replaced by the value given to the <code>destination</code> parameter
   * @param body the body, may be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame sendAndAwait(String destination, java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    return (io.vertx.ext.stomp.Frame) send(destination, headers, body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,Map,io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,Map,io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#send(String,Map,io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param destination the destination, must not be <code>null</code>
   * @param headers the header. The <code>destination</code> header is replaced by the value given to the <code>destination</code> parameter
   * @param body the body, may be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection sendAndForget(String destination, java.util.Map<String, String> headers, io.vertx.mutiny.core.buffer.Buffer body) { 
    send(destination, headers, body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subscribes to the given destination. This destination is used as subscription id.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination, must not be <code>null</code>
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> subscribe(String destination, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.subscribe(destination, handler::accept, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Consumer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination, must not be <code>null</code>
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the String instance produced by the operation.
   */
  public String subscribeAndAwait(String destination, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    return (String) subscribe(destination, handler).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Consumer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Consumer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Consumer)} but you don't need to compose it with other operations.
   * @param destination the destination, must not be <code>null</code>
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection subscribeAndForget(String destination, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    subscribe(destination, handler).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subscribes to the given destination.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination, must not be <code>null</code>
   * @param headers the headers to configure the subscription. It may contain the <code>ack</code> header to configure the acknowledgment policy. If the given set of headers contains the <code>id</code> header, this value is used as subscription id.
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> subscribe(String destination, java.util.Map<String, String> headers, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.subscribe(destination, headers, handler::accept, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Map,Consumer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination, must not be <code>null</code>
   * @param headers the headers to configure the subscription. It may contain the <code>ack</code> header to configure the acknowledgment policy. If the given set of headers contains the <code>id</code> header, this value is used as subscription id.
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the String instance produced by the operation.
   */
  public String subscribeAndAwait(String destination, java.util.Map<String, String> headers, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    return (String) subscribe(destination, headers, handler).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Map,Consumer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Map,Consumer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#subscribe(String,Map,Consumer)} but you don't need to compose it with other operations.
   * @param destination the destination, must not be <code>null</code>
   * @param headers the headers to configure the subscription. It may contain the <code>ack</code> header to configure the acknowledgment policy. If the given set of headers contains the <code>id</code> header, this value is used as subscription id.
   * @param handler the handler invoked when a message is received on the given destination. Must not be <code>null</code>.
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection subscribeAndForget(String destination, java.util.Map<String, String> headers, java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) { 
    subscribe(destination, headers, handler).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Un-subscribes from the given destination. This method only works if the subscription did not specifies a
   * subscription id (using the <code>id</code> header).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> unsubscribe(String destination) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.unsubscribe(destination, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame unsubscribeAndAwait(String destination) { 
    return (io.vertx.ext.stomp.Frame) unsubscribe(destination).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String)} but you don't need to compose it with other operations.
   * @param destination the destination
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection unsubscribeAndForget(String destination) { 
    unsubscribe(destination).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Un-subscribes from the given destination. This method computes the subscription id as follows. If the given
   * headers contains the <code>id</code> header, the header value is used. Otherwise the destination is used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param destination the destination
   * @param headers the headers
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> unsubscribe(String destination, java.util.Map<String, String> headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.unsubscribe(destination, headers, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param destination the destination
   * @param headers the headers
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame unsubscribeAndAwait(String destination, java.util.Map<String, String> headers) { 
    return (io.vertx.ext.stomp.Frame) unsubscribe(destination, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#unsubscribe(String,Map)} but you don't need to compose it with other operations.
   * @param destination the destination
   * @param headers the headers
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection unsubscribeAndForget(String destination, java.util.Map<String, String> headers) { 
    unsubscribe(destination, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  private io.vertx.mutiny.ext.stomp.StompClientConnection __errorHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    io.vertx.mutiny.ext.stomp.StompClientConnection ret = io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)delegate.errorHandler(handler));
    return ret;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection errorHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __errorHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __closeHandler(Handler<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) { 
    delegate.closeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection closeHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) {
    return __closeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection} receiving the dropped connection.
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __connectionDroppedHandler(Handler<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) { 
    delegate.connectionDroppedHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection connectionDroppedHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) {
    return __connectionDroppedHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __pingHandler(Handler<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) { 
    delegate.pingHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection pingHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompClientConnection> handler) {
    return __pingHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * Begins a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> beginTX(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.beginTX(id, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame beginTXAndAwait(String id) { 
    return (io.vertx.ext.stomp.Frame) beginTX(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection beginTXAndForget(String id) { 
    beginTX(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Begins a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> beginTX(String id, java.util.Map<String, String> headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.beginTX(id, headers, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame beginTXAndAwait(String id, java.util.Map<String, String> headers) { 
    return (io.vertx.ext.stomp.Frame) beginTX(id, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#beginTX(String,Map)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection beginTXAndForget(String id, java.util.Map<String, String> headers) { 
    beginTX(id, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Commits a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> commit(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.commit(id, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame commitAndAwait(String id) { 
    return (io.vertx.ext.stomp.Frame) commit(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection commitAndForget(String id) { 
    commit(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Commits a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> commit(String id, java.util.Map<String, String> headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.commit(id, headers, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame commitAndAwait(String id, java.util.Map<String, String> headers) { 
    return (io.vertx.ext.stomp.Frame) commit(id, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#commit(String,Map)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection commitAndForget(String id, java.util.Map<String, String> headers) { 
    commit(id, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Aborts a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> abort(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.abort(id, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame abortAndAwait(String id) { 
    return (io.vertx.ext.stomp.Frame) abort(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection abortAndForget(String id) { 
    abort(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Aborts a transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> abort(String id, java.util.Map<String, String> headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.abort(id, headers, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String,Map)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame abortAndAwait(String id, java.util.Map<String, String> headers) { 
    return (io.vertx.ext.stomp.Frame) abort(id, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String,Map)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String,Map)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#abort(String,Map)} but you don't need to compose it with other operations.
   * @param id the transaction id, must not be <code>null</code>
   * @param headers additional headers to send to the server. The <code>transaction</code> header is replaced by the value passed in the @{code id} parameter
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection abortAndForget(String id, java.util.Map<String, String> headers) { 
    abort(id, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Disconnects the client. Unlike the {@link io.vertx.mutiny.ext.stomp.StompClientConnection#close} method, this method send the <code>DISCONNECT</code> frame to the
   * server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> disconnect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.disconnect(receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame disconnectAndAwait() { 
    return (io.vertx.ext.stomp.Frame) disconnect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect} but you don't need to compose it with other operations.
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection disconnectAndForget() { 
    disconnect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Disconnects the client. Unlike the {@link io.vertx.mutiny.ext.stomp.StompClientConnection#close} method, this method send the <code>DISCONNECT</code> frame to the
   * server. This method lets you customize the <code>DISCONNECT</code> frame.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param frame the <code>DISCONNECT</code> frame.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> disconnect(io.vertx.ext.stomp.Frame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.disconnect(frame, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect(Frame)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param frame the <code>DISCONNECT</code> frame.
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame disconnectAndAwait(io.vertx.ext.stomp.Frame frame) { 
    return (io.vertx.ext.stomp.Frame) disconnect(frame).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect(Frame)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect(Frame)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#disconnect(Frame)} but you don't need to compose it with other operations.
   * @param frame the <code>DISCONNECT</code> frame.
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection disconnectAndForget(io.vertx.ext.stomp.Frame frame) { 
    disconnect(frame).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends an acknowledgement for a specific message. It means that the message has been handled and processed by the
   * client. The <code>id</code> parameter is the message id received in the frame.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the message id of the message to acknowledge
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> ack(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.ack(id, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the message id of the message to acknowledge
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame ackAndAwait(String id) { 
    return (io.vertx.ext.stomp.Frame) ack(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String)} but you don't need to compose it with other operations.
   * @param id the message id of the message to acknowledge
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection ackAndForget(String id) { 
    ack(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a non-acknowledgement for the given message. It means that the message has not been handled by the client.
   * The <code>id</code> parameter is the message id received in the frame.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the message id of the message to acknowledge
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> nack(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.nack(id, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the message id of the message to acknowledge
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame nackAndAwait(String id) { 
    return (io.vertx.ext.stomp.Frame) nack(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String)} but you don't need to compose it with other operations.
   * @param id the message id of the message to acknowledge
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection nackAndForget(String id) { 
    nack(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends an acknowledgement for the given frame. It means that the frame has been handled and processed by the
   * client. The sent acknowledgement is part of the transaction identified by the given id.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> ack(String id, String txId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.ack(id, txId, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame ackAndAwait(String id, String txId) { 
    return (io.vertx.ext.stomp.Frame) ack(id, txId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#ack(String,String)} but you don't need to compose it with other operations.
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection ackAndForget(String id, String txId) { 
    ack(id, txId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a non-acknowledgement for the given frame. It means that the frame has not been handled by the client.
   * The sent non-acknowledgement is part of the transaction identified by the given id.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.stomp.Frame> nack(String id, String txId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(receiptHandler -> {
        delegate.nack(id, txId, receiptHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the Frame instance produced by the operation.
   */
  public io.vertx.ext.stomp.Frame nackAndAwait(String id, String txId) { 
    return (io.vertx.ext.stomp.Frame) nack(id, txId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClientConnection#nack(String,String)} but you don't need to compose it with other operations.
   * @param id the message id of the message to acknowledge
   * @param txId the transaction id
   * @return the instance of StompClientConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClientConnection nackAndForget(String id, String txId) { 
    nack(id, txId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __receivedFrameHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.receivedFrameHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection receivedFrameHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __receivedFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __writingFrameHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.writingFrameHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection writingFrameHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __writingFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param exceptionHandler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClientConnection}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClientConnection __exceptionHandler(Handler<java.lang.Throwable> exceptionHandler) { 
    delegate.exceptionHandler(exceptionHandler);
    return this;
  }

  /**
   * @param exceptionHandler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> exceptionHandler) {
    return __exceptionHandler(exceptionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(exceptionHandler) : null);
  }

  /**
   * @return <code>true</code> if the connection is established, <code>false</code> otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  public static  StompClientConnection newInstance(io.vertx.ext.stomp.StompClientConnection arg) {
    return arg != null ? new StompClientConnection(arg) : null;
  }

}
