package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.StompServerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Defines a STOMP server. STOMP servers delegates to a {@link io.vertx.mutiny.ext.stomp.StompServerHandler} that let customize the behavior of
 * the server. By default, it uses a handler compliant with the STOMP specification, but let you change anything.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.StompServer.class)
public class StompServer {

  public static final io.smallrye.mutiny.vertx.TypeArg<StompServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new StompServer((io.vertx.ext.stomp.StompServer) obj),
    StompServer::getDelegate
  );

  private final io.vertx.ext.stomp.StompServer delegate;
  
  public StompServer(io.vertx.ext.stomp.StompServer delegate) {
    this.delegate = delegate;
  }

  public StompServer(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompServer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  StompServer() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.StompServer getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.ServerWebSocket> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.http.ServerWebSocket>(o1 -> io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompServer that = (StompServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance to use
   * @param options the server options
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  public static io.vertx.mutiny.ext.stomp.StompServer create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.stomp.StompServerOptions options) { 
    io.vertx.mutiny.ext.stomp.StompServer ret = io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)io.vertx.ext.stomp.StompServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vert.x instance to use
   * @param netServer the Net server used by the STOMP server
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  public static io.vertx.mutiny.ext.stomp.StompServer create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.core.net.NetServer netServer) { 
    io.vertx.mutiny.ext.stomp.StompServer ret = io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)io.vertx.ext.stomp.StompServer.create(vertx.getDelegate(), netServer.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vert.x instance to use
   * @param net the Net server used by the STOMP server
   * @param options the server options
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  public static io.vertx.mutiny.ext.stomp.StompServer create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.core.net.NetServer net, io.vertx.ext.stomp.StompServerOptions options) { 
    io.vertx.mutiny.ext.stomp.StompServer ret = io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)io.vertx.ext.stomp.StompServer.create(vertx.getDelegate(), net.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vert.x instance to use
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  public static io.vertx.mutiny.ext.stomp.StompServer create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.stomp.StompServer ret = io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)io.vertx.ext.stomp.StompServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServer handler(io.vertx.mutiny.ext.stomp.StompServerHandler handler) { 
    delegate.handler(handler.getDelegate());
    return this;
  }

  /**
   * Connects the STOMP server default port (61613) and network interface (<code>0.0.0.0</code>). Once the socket
   * it bounds calls the given handler with the result. The result may be a failure if the socket is already used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listen(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the StompServer instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompServer listenAndAwait() { 
    return (io.vertx.mutiny.ext.stomp.StompServer) listen().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompServer#listen} but you don't need to compose it with other operations.
   * @return the instance of StompServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServer listenAndForget() { 
    listen().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects the STOMP server to the given port. This method use the default host (<code>0.0.0.0</code>). Once the socket
   * it bounds calls the given handler with the result. The result may be a failure if the socket is already used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listen(port, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @return the StompServer instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.ext.stomp.StompServer) listen(port).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int)} but you don't need to compose it with other operations.
   * @param port the port
   * @return the instance of StompServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServer listenAndForget(int port) { 
    listen(port).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects the STOMP server to the given port / interface. Once the socket it bounds calls the given handler with
   * the result. The result may be a failure if the socket is already used.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host / interface
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listen(port, host, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host / interface
   * @return the StompServer instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.ext.stomp.StompServer) listen(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompServer#listen(int,String)} but you don't need to compose it with other operations.
   * @param port the port
   * @param host the host / interface
   * @return the instance of StompServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServer listenAndForget(int port, String host) { 
    listen(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> if the server is listening, <code>false</code> otherwise
   */
  public boolean isListening() { 
    boolean ret = delegate.isListening();
    return ret;
  }

  /**
   * @return the port
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * @return the server options
   */
  public io.vertx.ext.stomp.StompServerOptions options() { 
    io.vertx.ext.stomp.StompServerOptions ret = delegate.options();
    return ret;
  }

  /**
   * @return the instance of vert.x used by the server.
   */
  public io.vertx.mutiny.core.Vertx vertx() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return the {@link io.vertx.mutiny.ext.stomp.StompServerHandler} used by this server.
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler stompHandler() { 
    io.vertx.mutiny.ext.stomp.StompServerHandler ret = io.vertx.mutiny.ext.stomp.StompServerHandler.newInstance((io.vertx.ext.stomp.StompServerHandler)delegate.stompHandler());
    return ret;
  }

  /**
   * @return the handler that can be passed to {@link io.vertx.mutiny.core.http.HttpServer#webSocketHandler}.
   */
  public Handler<io.vertx.mutiny.core.http.ServerWebSocket> webSocketHandler() { 
    Handler<io.vertx.mutiny.core.http.ServerWebSocket> ret = new Handler<io.vertx.mutiny.core.http.ServerWebSocket>() {
      public void handle(io.vertx.mutiny.core.http.ServerWebSocket event) {
          delegate.webSocketHandler().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServer}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServer __writingFrameHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.writingFrameHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServer writingFrameHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __writingFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  public static  StompServer newInstance(io.vertx.ext.stomp.StompServer arg) {
    return arg != null ? new StompServer(arg) : null;
  }

}
