package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import io.vertx.ext.stomp.BridgeOptions;
import java.util.List;
import io.vertx.ext.stomp.Frame;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * STOMP server handler implements the behavior of the STOMP server when a specific event occurs. For instance, if
 * let customize the behavior when specific STOMP frames arrives or when a connection is closed. This class has been
 * designed to let you customize the server behavior. The default implementation is compliant with the STOMP
 * specification. In this default implementation, not acknowledge frames are dropped.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompServerHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.stomp.ServerFrame>, java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> {

  public static final io.smallrye.mutiny.vertx.TypeArg<StompServerHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler) obj),
    StompServerHandler::getDelegate
  );

  private final io.vertx.ext.stomp.StompServerHandler delegate;
  
  public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
    this.delegate = delegate;
  }

  public StompServerHandler(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompServerHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  StompServerHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.StompServerHandler getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.stomp.Destination> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.stomp.Destination>(o1 -> io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompServerHandler that = (StompServerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.stomp.ServerFrame arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx the vert.x instance to use
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  public static io.vertx.mutiny.ext.stomp.StompServerHandler create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.stomp.StompServerHandler ret = io.vertx.mutiny.ext.stomp.StompServerHandler.newInstance((io.vertx.ext.stomp.StompServerHandler)io.vertx.ext.stomp.StompServerHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __receivedFrameHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.receivedFrameHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler receivedFrameHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __receivedFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __connectHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.connectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler connectHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __connectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __stompHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.stompHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler stompHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __stompHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __subscribeHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.subscribeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler subscribeHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __subscribeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __unsubscribeHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.unsubscribeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler unsubscribeHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __unsubscribeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __sendHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.sendHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler sendHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __sendHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __closeHandler(Handler<io.vertx.mutiny.ext.stomp.StompServerConnection> handler) { 
    delegate.closeHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler closeHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompServerConnection> handler) {
    return __closeHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param connection the connection
   */
  public void onClose(io.vertx.mutiny.ext.stomp.StompServerConnection connection) { 
    delegate.onClose(connection.getDelegate());
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __commitHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.commitHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler commitHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __commitHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __abortHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.abortHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler abortHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __abortHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __beginHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.beginHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler beginHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __beginHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __disconnectHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.disconnectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler disconnectHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __disconnectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __ackHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.ackHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler ackHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __ackHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __nackHandler(Handler<io.vertx.mutiny.ext.stomp.ServerFrame> handler) { 
    delegate.nackHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler nackHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.ServerFrame> handler) {
    return __nackHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * Called when the client connects to a server requiring authentication. It invokes the  configured
   * using {@link io.vertx.mutiny.ext.stomp.StompServerHandler#authProvider}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param connection server connection that contains session ID
   * @param login the login
   * @param passcode the password
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> onAuthenticationRequest(io.vertx.mutiny.ext.stomp.StompServerConnection connection, String login, String passcode) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompServerHandler#onAuthenticationRequest(io.vertx.mutiny.ext.stomp.StompServerConnection,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param connection server connection that contains session ID
   * @param login the login
   * @param passcode the password
   * @return the Boolean instance produced by the operation.
   */
  public Boolean onAuthenticationRequestAndAwait(io.vertx.mutiny.ext.stomp.StompServerConnection connection, String login, String passcode) { 
    return (Boolean) onAuthenticationRequest(connection, login, passcode).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompServerHandler#onAuthenticationRequest(io.vertx.mutiny.ext.stomp.StompServerConnection,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompServerHandler#onAuthenticationRequest(io.vertx.mutiny.ext.stomp.StompServerConnection,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompServerHandler#onAuthenticationRequest(io.vertx.mutiny.ext.stomp.StompServerConnection,String,String)} but you don't need to compose it with other operations.
   * @param connection server connection that contains session ID
   * @param login the login
   * @param passcode the password
   * @return the instance of StompServerHandler to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler onAuthenticationRequestAndForget(io.vertx.mutiny.ext.stomp.StompServerConnection connection, String login, String passcode) { 
    onAuthenticationRequest(connection, login, passcode).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param session session ID for the server connection.
   * @return null if not authenticated.
   */
  public io.vertx.mutiny.ext.auth.User getUserBySession(String session) { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.getUserBySession(session));
    return ret;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler authProvider(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider handler) { 
    delegate.authProvider(handler.getDelegate());
    return this;
  }

  /**
   * @return the list of destination managed by the STOMP server. Don't forget the STOMP interprets destination as opaque Strings.
   */
  public List<io.vertx.mutiny.ext.stomp.Destination> getDestinations() { 
    List<io.vertx.mutiny.ext.stomp.Destination> ret = delegate.getDestinations().stream().map(elt -> io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @param destination the destination
   * @return the {@link io.vertx.mutiny.ext.stomp.Destination}, <code>null</code> if not existing.
   */
  public io.vertx.mutiny.ext.stomp.Destination getDestination(String destination) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.getDestination(destination));
    return ret;
  }

  /**
   * @param connection the connection
   * @param subscribe the <code>SUBSCRIBE</code> frame
   * @param messages the acknowledge messages
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler onAck(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame subscribe, List<io.vertx.ext.stomp.Frame> messages) { 
    delegate.onAck(connection.getDelegate(), subscribe, messages);
    return this;
  }

  /**
   * @param connection the connection
   * @param subscribe the <code>SUBSCRIBE</code> frame
   * @param messages the acknowledge messages
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler onNack(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame subscribe, List<io.vertx.ext.stomp.Frame> messages) { 
    delegate.onNack(connection.getDelegate(), subscribe, messages);
    return this;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __onAckHandler(Handler<io.vertx.mutiny.ext.stomp.Acknowledgement> handler) { 
    delegate.onAckHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.Acknowledgement.newInstance((io.vertx.ext.stomp.Acknowledgement)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler onAckHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.Acknowledgement> handler) {
    return __onAckHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __onNackHandler(Handler<io.vertx.mutiny.ext.stomp.Acknowledgement> handler) { 
    delegate.onNackHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.Acknowledgement.newInstance((io.vertx.ext.stomp.Acknowledgement)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler onNackHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.Acknowledgement> handler) {
    return __onNackHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the action to execute when a `PING` needs to be sent.
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompServerHandler __pingHandler(Handler<io.vertx.mutiny.ext.stomp.StompServerConnection> handler) { 
    delegate.pingHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)event)));
    return this;
  }

  /**
   * @param handler the action to execute when a `PING` needs to be sent.
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler pingHandler(java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompServerConnection> handler) {
    return __pingHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param destination the destination
   * @return the {@link io.vertx.mutiny.ext.stomp.Destination} instance, may have been created.
   */
  public io.vertx.mutiny.ext.stomp.Destination getOrCreateDestination(String destination) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.getOrCreateDestination(destination));
    return ret;
  }

  /**
   * @param factory the factory
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler destinationFactory(io.vertx.mutiny.ext.stomp.DestinationFactory factory) { 
    delegate.destinationFactory(factory.getDelegate());
    return this;
  }

  /**
   * @param options the configuration options
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerHandler}.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerHandler bridge(io.vertx.ext.stomp.BridgeOptions options) { 
    delegate.bridge(options);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.stomp.ServerFrame item) {
    handle(item);
  }
  public static  StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
    return arg != null ? new StompServerHandler(arg) : null;
  }

}
