package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.ext.stomp.Frame;

/**
 * Structure passed to acknowledgement handler called when a <code>ACK</code> or <code>NACK</code> frame is received. The handler
 * receives an instance of {@link io.vertx.mutiny.ext.stomp.Acknowledgement} with the subscription {@link io.vertx.ext.stomp.Frame} and the impacted messages. The
 * list of messages depends on the type of acknowledgment used by the subscription.
 * <p/>
 * Subscriptions using the <code>client</code> mode receives all messages that were waiting for acknowledgment that were
 * sent before the acknowledged messages. The list also contains the acknowledged message. This is a cumulative
 * acknowledgement. Subscriptions using the <code>client-individual</code> mode receives a singleton list containing only
 * the acknowledged message.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Acknowledgement original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.Acknowledgement.class)
public class Acknowledgement {

  public static final io.smallrye.mutiny.vertx.TypeArg<Acknowledgement> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Acknowledgement((io.vertx.ext.stomp.Acknowledgement) obj),
    Acknowledgement::getDelegate
  );

  private final io.vertx.ext.stomp.Acknowledgement delegate;
  
  public Acknowledgement(io.vertx.ext.stomp.Acknowledgement delegate) {
    this.delegate = delegate;
  }

  public Acknowledgement(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Acknowledgement)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Acknowledgement() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.Acknowledgement getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Acknowledgement that = (Acknowledgement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the subscription frame
   */
  public io.vertx.ext.stomp.Frame subscription() { 
    io.vertx.ext.stomp.Frame ret = delegate.subscription();
    return ret;
  }

  /**
   * @return the list of frames that have been acknowledged / not-acknowledged. The content of the list depends on the type of subscription.
   */
  public List<io.vertx.ext.stomp.Frame> frames() { 
    List<io.vertx.ext.stomp.Frame> ret = delegate.frames();
    return ret;
  }

  public static  Acknowledgement newInstance(io.vertx.ext.stomp.Acknowledgement arg) {
    return arg != null ? new Acknowledgement(arg) : null;
  }

}
