package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.BridgeOptions;
import java.util.List;
import io.vertx.ext.stomp.Frame;
import io.vertx.core.shareddata.Shareable;

/**
 * Represents a STOMP destination.
 * Depending on the implementation, the message delivery is different. Queue are sending message to only one
 * subscribers, while topics are broadcasting the message to all subscribers.
 * <p/>
 * Implementations <strong>must</strong> be thread-safe.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Destination original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.Destination.class)
public class Destination {

  public static final io.smallrye.mutiny.vertx.TypeArg<Destination> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Destination((io.vertx.ext.stomp.Destination) obj),
    Destination::getDelegate
  );

  private final io.vertx.ext.stomp.Destination delegate;
  
  public Destination(io.vertx.ext.stomp.Destination delegate) {
    this.delegate = delegate;
  }

  public Destination(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Destination)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Destination() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.Destination getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Destination that = (Destination) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static io.vertx.mutiny.ext.stomp.Destination topic(io.vertx.mutiny.core.Vertx vertx, String destination) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.topic(vertx.getDelegate(), destination));
    return ret;
  }

  public static io.vertx.mutiny.ext.stomp.Destination queue(io.vertx.mutiny.core.Vertx vertx, String destination) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.queue(vertx.getDelegate(), destination));
    return ret;
  }

  public static io.vertx.mutiny.ext.stomp.Destination bridge(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.stomp.BridgeOptions options) { 
    io.vertx.mutiny.ext.stomp.Destination ret = io.vertx.mutiny.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.bridge(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @return the destination address.
   */
  public String destination() { 
    String ret = delegate.destination();
    return ret;
  }

  /**
   * @param connection the connection
   * @param frame the frame
   * @return the current instance of {@link io.vertx.mutiny.ext.stomp.Destination}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.Destination dispatch(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    delegate.dispatch(connection.getDelegate(), frame);
    return this;
  }

  /**
   * @param connection the connection
   * @param frame the <code>SUBSCRIBE</code> frame
   * @return the current instance of {@link io.vertx.mutiny.ext.stomp.Destination}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.Destination subscribe(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    delegate.subscribe(connection.getDelegate(), frame);
    return this;
  }

  /**
   * @param connection the connection
   * @param frame the <code>UNSUBSCRIBE</code> frame
   * @return <code>true</code> if the un-subscription has been handled, <code>false</code> otherwise.
   */
  public boolean unsubscribe(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.unsubscribe(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * @param connection the connection
   * @return the current instance of {@link io.vertx.mutiny.ext.stomp.Destination}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.Destination unsubscribeConnection(io.vertx.mutiny.ext.stomp.StompServerConnection connection) { 
    delegate.unsubscribeConnection(connection.getDelegate());
    return this;
  }

  /**
   * @param connection the connection
   * @param frame the <code>ACK</code> frame
   * @return <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
   */
  public boolean ack(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.ack(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * @param connection the connection
   * @param frame the <code>NACK</code> frame
   * @return <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
   */
  public boolean nack(io.vertx.mutiny.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.nack(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * @param connection the connection (client)
   * @return the list of subscription id, empty if none
   */
  public List<String> getSubscriptions(io.vertx.mutiny.ext.stomp.StompServerConnection connection) { 
    List<String> ret = delegate.getSubscriptions(connection.getDelegate());
    return ret;
  }

  /**
   * @return the number of subscriptions.
   */
  public int numberOfSubscriptions() { 
    int ret = delegate.numberOfSubscriptions();
    return ret;
  }

  /**
   * @param address the address
   * @return <code>true</code> if it matches, <code>false</code> otherwise.
   */
  public boolean matches(String address) { 
    boolean ret = delegate.matches(address);
    return ret;
  }

  public static  Destination newInstance(io.vertx.ext.stomp.Destination arg) {
    return arg != null ? new Destination(arg) : null;
  }

}
