package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.Frame;
import java.util.Map;

/**
 * Utility methods to build common {@link io.vertx.ext.stomp.Frame}s. It defines a non-STOMP frame (<code>PING</code>) that is used for
 * heartbeats. When such frame is written on the wire it is just the <code>0</code> byte.
 * <p/>
 * This class is thread-safe.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Frames original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.Frames.class)
public class Frames {

  public static final io.smallrye.mutiny.vertx.TypeArg<Frames> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Frames((io.vertx.ext.stomp.Frames) obj),
    Frames::getDelegate
  );

  private final io.vertx.ext.stomp.Frames delegate;
  
  public Frames(io.vertx.ext.stomp.Frames delegate) {
    this.delegate = delegate;
  }

  public Frames(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Frames)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Frames() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.Frames getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Frames that = (Frames) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static io.vertx.ext.stomp.Frame createErrorFrame(String message, java.util.Map<String, String> headers, String body) { 
    io.vertx.ext.stomp.Frame ret = io.vertx.ext.stomp.Frames.createErrorFrame(message, headers, body);
    return ret;
  }

  public static io.vertx.ext.stomp.Frame createReceiptFrame(String receiptId, java.util.Map<String, String> headers) { 
    io.vertx.ext.stomp.Frame ret = io.vertx.ext.stomp.Frames.createReceiptFrame(receiptId, headers);
    return ret;
  }

  public static void handleReceipt(io.vertx.ext.stomp.Frame frame, io.vertx.mutiny.ext.stomp.StompServerConnection connection) { 
    io.vertx.ext.stomp.Frames.handleReceipt(frame, connection.getDelegate());
  }

  public static io.vertx.ext.stomp.Frame ping() { 
    io.vertx.ext.stomp.Frame ret = io.vertx.ext.stomp.Frames.ping();
    return ret;
  }

  public static final Frame PING = io.vertx.ext.stomp.Frames.PING;
  public static  Frames newInstance(io.vertx.ext.stomp.Frames arg) {
    return arg != null ? new Frames(arg) : null;
  }

}
