package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.stomp.Frame;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import io.vertx.ext.stomp.StompClientOptions;

/**
 * Defines a STOMP client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.StompClient.class)
public class StompClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<StompClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new StompClient((io.vertx.ext.stomp.StompClient) obj),
    StompClient::getDelegate
  );

  private final io.vertx.ext.stomp.StompClient delegate;
  
  public StompClient(io.vertx.ext.stomp.StompClient delegate) {
    this.delegate = delegate;
  }

  public StompClient(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  StompClient() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.StompClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompClient that = (StompClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance to use
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  public static io.vertx.mutiny.ext.stomp.StompClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.stomp.StompClient ret = io.vertx.mutiny.ext.stomp.StompClient.newInstance((io.vertx.ext.stomp.StompClient)io.vertx.ext.stomp.StompClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vert.x instance to use
   * @param options the options
   * @return the created {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  public static io.vertx.mutiny.ext.stomp.StompClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.stomp.StompClientOptions options) { 
    io.vertx.mutiny.ext.stomp.StompClient ret = io.vertx.mutiny.ext.stomp.StompClient.newInstance((io.vertx.ext.stomp.StompClient)io.vertx.ext.stomp.StompClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the server port
   * @param host the server host
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompClientConnection> connect(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.connect(port, host, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the server port
   * @param host the server host
   * @return the StompClientConnection instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection connectAndAwait(int port, String host) { 
    return (io.vertx.mutiny.ext.stomp.StompClientConnection) connect(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String)} but you don't need to compose it with other operations.
   * @param port the server port
   * @param host the server host
   * @return the instance of StompClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClient connectAndForget(int port, String host) { 
    connect(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects to the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param net the NET client to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompClientConnection> connect(io.vertx.mutiny.core.net.NetClient net) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.connect(net.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(io.vertx.mutiny.core.net.NetClient)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param net the NET client to use
   * @return the StompClientConnection instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection connectAndAwait(io.vertx.mutiny.core.net.NetClient net) { 
    return (io.vertx.mutiny.ext.stomp.StompClientConnection) connect(net).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(io.vertx.mutiny.core.net.NetClient)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(io.vertx.mutiny.core.net.NetClient)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClient#connect(io.vertx.mutiny.core.net.NetClient)} but you don't need to compose it with other operations.
   * @param net the NET client to use
   * @return the instance of StompClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClient connectAndForget(io.vertx.mutiny.core.net.NetClient net) { 
    connect(net).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects to the server.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompClientConnection> connect(int port, String host, io.vertx.mutiny.core.net.NetClient net) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.connect(port, host, net.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String,io.vertx.mutiny.core.net.NetClient)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @return the StompClientConnection instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection connectAndAwait(int port, String host, io.vertx.mutiny.core.net.NetClient net) { 
    return (io.vertx.mutiny.ext.stomp.StompClientConnection) connect(port, host, net).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String,io.vertx.mutiny.core.net.NetClient)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String,io.vertx.mutiny.core.net.NetClient)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClient#connect(int,String,io.vertx.mutiny.core.net.NetClient)} but you don't need to compose it with other operations.
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @return the instance of StompClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClient connectAndForget(int port, String host, io.vertx.mutiny.core.net.NetClient net) { 
    connect(port, host, net).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Connects to the server using the host and port configured in the client's options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.stomp.StompClientConnection> connect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.connect(new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the StompClientConnection instance produced by the operation.
   */
  public io.vertx.mutiny.ext.stomp.StompClientConnection connectAndAwait() { 
    return (io.vertx.mutiny.ext.stomp.StompClientConnection) connect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.stomp.StompClient#connect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.stomp.StompClient#connect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.stomp.StompClient#connect} but you don't need to compose it with other operations.
   * @return the instance of StompClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompClient connectAndForget() { 
    connect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClient __receivedFrameHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.receivedFrameHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClient receivedFrameHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __receivedFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClient __writingFrameHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.writingFrameHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClient writingFrameHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __writingFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClient __errorFrameHandler(Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.errorFrameHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClient errorFrameHandler(java.util.function.Consumer<io.vertx.ext.stomp.Frame> handler) {
    return __errorFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompClient}
   */
  @Fluent
  private io.vertx.mutiny.ext.stomp.StompClient __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.stomp.StompClient exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the client's options.
   */
  public io.vertx.ext.stomp.StompClientOptions options() { 
    io.vertx.ext.stomp.StompClientOptions ret = delegate.options();
    return ret;
  }

  /**
   * @return the vert.x instance used by the client.
   */
  public io.vertx.mutiny.core.Vertx vertx() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return whether or not the client is connected to the server.
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public static  StompClient newInstance(io.vertx.ext.stomp.StompClient arg) {
    return arg != null ? new StompClient(arg) : null;
  }

}
