package io.vertx.mutiny.ext.stomp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import javax.net.ssl.SSLSession;
import io.vertx.ext.stomp.Frame;
import io.vertx.core.Handler;

/**
 * Class representing a connection between a STOMP client a the server. It keeps a references on the client socket,
 * so let write to this socket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompServerConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.stomp.StompServerConnection.class)
public class StompServerConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<StompServerConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new StompServerConnection((io.vertx.ext.stomp.StompServerConnection) obj),
    StompServerConnection::getDelegate
  );

  private final io.vertx.ext.stomp.StompServerConnection delegate;
  
  public StompServerConnection(io.vertx.ext.stomp.StompServerConnection delegate) {
    this.delegate = delegate;
  }

  public StompServerConnection(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompServerConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  StompServerConnection() {
    this.delegate = null;
  }

  public io.vertx.ext.stomp.StompServerConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompServerConnection that = (StompServerConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param frame the frame, must not be <code>null</code>.
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerConnection}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerConnection write(io.vertx.ext.stomp.Frame frame) { 
    delegate.write(frame);
    return this;
  }

  /**
   * @param buffer the buffer
   * @return the current {@link io.vertx.mutiny.ext.stomp.StompServerConnection}
   */
  @Fluent
  public io.vertx.mutiny.ext.stomp.StompServerConnection write(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  /**
   * @return the STOMP server serving this connection.
   */
  public io.vertx.mutiny.ext.stomp.StompServer server() { 
    io.vertx.mutiny.ext.stomp.StompServer ret = io.vertx.mutiny.ext.stomp.StompServer.newInstance((io.vertx.ext.stomp.StompServer)delegate.server());
    return ret;
  }

  /**
   * @return the STOMP server handler dealing with this connection
   */
  public io.vertx.mutiny.ext.stomp.StompServerHandler handler() { 
    io.vertx.mutiny.ext.stomp.StompServerHandler ret = io.vertx.mutiny.ext.stomp.StompServerHandler.newInstance((io.vertx.ext.stomp.StompServerHandler)delegate.handler());
    return ret;
  }

  /**
   * @return the STOMP session id computed when the client has established the connection to the server
   */
  public String session() { 
    String ret = delegate.session();
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   */
  public void ping() { 
    delegate.ping();
  }

  /**
   */
  public void onServerActivity() { 
    delegate.onServerActivity();
  }

  /**
   * @param ping ping time
   * @param pong pong time
   * @param pingHandler the ping handler
   */
  private void __configureHeartbeat(long ping, long pong, Handler<io.vertx.mutiny.ext.stomp.StompServerConnection> pingHandler) { 
    delegate.configureHeartbeat(ping, pong, new io.smallrye.mutiny.vertx.DelegatingHandler<>(pingHandler, event -> io.vertx.mutiny.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)event)));
  }

  /**
   * @param ping ping time
   * @param pong pong time
   * @param pingHandler the ping handler
   */
  public void configureHeartbeat(long ping, long pong, java.util.function.Consumer<io.vertx.mutiny.ext.stomp.StompServerConnection> pingHandler) {
    __configureHeartbeat(ping, pong, pingHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(pingHandler) : null);
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  public static  StompServerConnection newInstance(io.vertx.ext.stomp.StompServerConnection arg) {
    return arg != null ? new StompServerConnection(arg) : null;
  }

}
