package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.client.spi.CookieStore;

/**
 * An asynchronous sessions aware HTTP / HTTP/2 client called <code>WebClientSession</code>.
 * <p>
 * This client wraps a {@link io.vertx.mutiny.ext.web.client.WebClient} and makes it session aware adding features to it:
 * <ul>
 *   <li>Per client headers, to be send with every request</li>
 *   <li>Per client cookies, to be send with every request</li>
 *   <li>Automatic storage and sending of cookies received from the server(s)</li>
 * </ul>
 * <p>
 * The client honors the cookies attributes:
 * <ul>
 *  <li>domain</li>
 *  <li>path</li>
 *  <li>secure</li>
 *  <li>max-age and expires</li>
 * </ul>
 * <p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClientSession original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.WebClientSession.class)
public class WebClientSession extends io.vertx.mutiny.ext.web.client.WebClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebClientSession> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebClientSession((io.vertx.ext.web.client.WebClientSession) obj),
    WebClientSession::getDelegate
  );

  private final io.vertx.ext.web.client.WebClientSession delegate;
  
  public WebClientSession(io.vertx.ext.web.client.WebClientSession delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WebClientSession(Object delegate) {
    super((io.vertx.ext.web.client.WebClientSession)delegate);
    this.delegate = (io.vertx.ext.web.client.WebClientSession)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebClientSession() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.web.client.WebClientSession getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClientSession that = (WebClientSession) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param webClient the web client instance
   * @return the created client
   */
  public static io.vertx.mutiny.ext.web.client.WebClientSession create(io.vertx.mutiny.ext.web.client.WebClient webClient) { 
    io.vertx.mutiny.ext.web.client.WebClientSession ret = io.vertx.mutiny.ext.web.client.WebClientSession.newInstance((io.vertx.ext.web.client.WebClientSession)io.vertx.ext.web.client.WebClientSession.create(webClient.getDelegate()));
    return ret;
  }

  /**
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession addHeader(String name, String value) { 
    delegate.addHeader(name, value);
    return this;
  }

  /**
   * @param name the header name
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession removeHeader(String name) { 
    delegate.removeHeader(name);
    return this;
  }

  /**
   * @param webClient the web client instance
   * @param cookieStore 
   * @return the created client
   */
  public static io.vertx.mutiny.ext.web.client.WebClientSession create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.ext.web.client.spi.CookieStore cookieStore) { 
    io.vertx.mutiny.ext.web.client.WebClientSession ret = io.vertx.mutiny.ext.web.client.WebClientSession.newInstance((io.vertx.ext.web.client.WebClientSession)io.vertx.ext.web.client.WebClientSession.create(webClient.getDelegate(), cookieStore));
    return ret;
  }

  /**
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession addHeader(java.lang.CharSequence name, java.lang.CharSequence value) { 
    delegate.addHeader(name, value);
    return this;
  }

  /**
   * @param name the header name
   * @param values the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession addHeader(java.lang.CharSequence name, java.lang.Iterable<java.lang.CharSequence> values) { 
    delegate.addHeader(name, values);
    return this;
  }

  /**
   * @param name the header name
   * @param values the header value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession addHeader(String name, java.lang.Iterable<String> values) { 
    delegate.addHeader(name, values);
    return this;
  }

  /**
   * @param name the header name
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.WebClientSession removeHeader(java.lang.CharSequence name) { 
    delegate.removeHeader(name);
    return this;
  }

  /**
   * @return this client's cookie store
   */
  public io.vertx.ext.web.client.spi.CookieStore cookieStore() { 
    io.vertx.ext.web.client.spi.CookieStore ret = delegate.cookieStore();
    return ret;
  }

  public static  WebClientSession newInstance(io.vertx.ext.web.client.WebClientSession arg) {
    return arg != null ? new WebClientSession(arg) : null;
  }

}
