package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.client.OAuth2WebClientOptions;
import io.vertx.ext.auth.authentication.Credentials;

/**
 * An asynchronous OAuth2/OIDC aware HTTP / HTTP/2 client called <code>WebClientOAuth2</code>.
 * <p>
 * This client wraps a {@link io.vertx.mutiny.ext.web.client.WebClient} and makes it session aware adding features to it:
 * <ul>
 *   <li>Request an <code>access_token</code> if no user is created</li>
 *   <li>Refresh <code>access_token</code> if current user is expired</li>
 * </ul>
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.OAuth2WebClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.OAuth2WebClient.class)
public class OAuth2WebClient extends io.vertx.mutiny.ext.web.client.WebClient implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<OAuth2WebClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OAuth2WebClient((io.vertx.ext.web.client.OAuth2WebClient) obj),
    OAuth2WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.OAuth2WebClient delegate;
  
  public OAuth2WebClient(io.vertx.ext.web.client.OAuth2WebClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OAuth2WebClient(Object delegate) {
    super((io.vertx.ext.web.client.OAuth2WebClient)delegate);
    this.delegate = (io.vertx.ext.web.client.OAuth2WebClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OAuth2WebClient() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.client.OAuth2WebClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2WebClient that = (OAuth2WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param webClient the web client instance
   * @param oAuth2Auth Configured oAuth2Auth provider to be used when {@link io.vertx.mutiny.ext.web.client.OAuth2WebClient#withCredentials} used
   * @return the created client
   */
  public static io.vertx.mutiny.ext.web.client.OAuth2WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth oAuth2Auth) { 
    io.vertx.mutiny.ext.web.client.OAuth2WebClient ret = io.vertx.mutiny.ext.web.client.OAuth2WebClient.newInstance((io.vertx.ext.web.client.OAuth2WebClient)io.vertx.ext.web.client.OAuth2WebClient.create(webClient.getDelegate(), oAuth2Auth.getDelegate()));
    return ret;
  }

  /**
   * @param webClient the web client instance
   * @param oAuth2Auth Configured oAuth2Auth provider to be used when {@link io.vertx.mutiny.ext.web.client.OAuth2WebClient#withCredentials} used
   * @param options extra configuration for this object
   * @return the created client
   */
  public static io.vertx.mutiny.ext.web.client.OAuth2WebClient create(io.vertx.mutiny.ext.web.client.WebClient webClient, io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth oAuth2Auth, io.vertx.ext.web.client.OAuth2WebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.OAuth2WebClient ret = io.vertx.mutiny.ext.web.client.OAuth2WebClient.newInstance((io.vertx.ext.web.client.OAuth2WebClient)io.vertx.ext.web.client.OAuth2WebClient.create(webClient.getDelegate(), oAuth2Auth.getDelegate(), options));
    return ret;
  }

  /**
   * @return the current user associated with this client or null if no user is associated
   */
  public io.vertx.mutiny.ext.auth.User getUser() { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.getUser());
    return ret;
  }

  /**
   * @param credentials 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.client.OAuth2WebClient withCredentials(io.vertx.ext.auth.authentication.Credentials credentials) { 
    delegate.withCredentials(credentials);
    return this;
  }

  public static  OAuth2WebClient newInstance(io.vertx.ext.web.client.OAuth2WebClient arg) {
    return arg != null ? new OAuth2WebClient(arg) : null;
  }

}
