package io.vertx.mutiny.ext.web.common;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Utility API to verify which environment is the web application running.
 *
 * The utility will check initially for the existence of a system property under the name `vertx.mode`,
 * if there is no such property then it will look under the environment variables under the name `VERTX_MODE`.
 *
 * This value will be then used when the API is invoked. By itself this utility will not
 * affect the behavior of your application, however you can use it to simplify your handlers, e.g.:
 *
 * When the development mode is active you can log more information or disable caches.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.common.WebEnvironment original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.common.WebEnvironment.class)
public class WebEnvironment {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebEnvironment> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebEnvironment((io.vertx.ext.web.common.WebEnvironment) obj),
    WebEnvironment::getDelegate
  );

  private final io.vertx.ext.web.common.WebEnvironment delegate;
  
  public WebEnvironment(io.vertx.ext.web.common.WebEnvironment delegate) {
    this.delegate = delegate;
  }

  public WebEnvironment(Object delegate) {
    this.delegate = (io.vertx.ext.web.common.WebEnvironment)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebEnvironment() {
    this.delegate = null;
  }

  public io.vertx.ext.web.common.WebEnvironment getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebEnvironment that = (WebEnvironment) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return always boolean
   */
  public static boolean development() { 
    boolean ret = io.vertx.ext.web.common.WebEnvironment.development();
    return ret;
  }

  /**
   * @return String with mode value or null
   */
  public static String mode() { 
    String ret = io.vertx.ext.web.common.WebEnvironment.mode();
    return ret;
  }

  public static final String SYSTEM_PROPERTY_NAME = io.vertx.ext.web.common.WebEnvironment.SYSTEM_PROPERTY_NAME;
  public static final String ENV_VARIABLE_NAME = io.vertx.ext.web.common.WebEnvironment.ENV_VARIABLE_NAME;
  public static  WebEnvironment newInstance(io.vertx.ext.web.common.WebEnvironment arg) {
    return arg != null ? new WebEnvironment(arg) : null;
  }

}
