package io.vertx.mutiny.ext.web.handler.graphql.ws;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.handler.graphql.ws.MessageType;
import io.vertx.core.json.JsonObject;

/**
 * A <a href="https://github.com/enisdenjo/graphql-ws/blob/master/PROTOCOL.md">GraphQL over WebSocket Protocol</a> message.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ws.Message original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.graphql.ws.Message.class)
public class Message {

  public static final io.smallrye.mutiny.vertx.TypeArg<Message> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Message((io.vertx.ext.web.handler.graphql.ws.Message) obj),
    Message::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ws.Message delegate;
  
  public Message(io.vertx.ext.web.handler.graphql.ws.Message delegate) {
    this.delegate = delegate;
  }

  public Message(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ws.Message)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Message() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.graphql.ws.Message getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Message that = (Message) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the websocket that received the message
   */
  public io.vertx.mutiny.core.http.ServerWebSocket socket() { 
    io.vertx.mutiny.core.http.ServerWebSocket ret = io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)delegate.socket());
    return ret;
  }

  /**
   * @return the message type
   */
  public io.vertx.ext.web.handler.graphql.ws.MessageType type() { 
    io.vertx.ext.web.handler.graphql.ws.MessageType ret = delegate.type();
    return ret;
  }

  /**
   * @return the message content
   */
  public JsonObject message() { 
    JsonObject ret = delegate.message();
    return ret;
  }

  /**
   * @return the connection params
   */
  public java.lang.Object connectionParams() { 
    java.lang.Object ret = (Object) delegate.connectionParams();
    return ret;
  }

  public static  Message newInstance(io.vertx.ext.web.handler.graphql.ws.Message arg) {
    return arg != null ? new Message(arg) : null;
  }

}
