package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.http.HttpMethod;
import java.util.Set;
import io.vertx.core.Handler;

/**
 * A handler which implements server side http://www.w3.org/TR/cors/[CORS] support for Vert.x-Web.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CorsHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.CorsHandler.class)
public class CorsHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CorsHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CorsHandler((io.vertx.ext.web.handler.CorsHandler) obj),
    CorsHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CorsHandler delegate;
  
  public CorsHandler(io.vertx.ext.web.handler.CorsHandler delegate) {
    this.delegate = delegate;
  }

  public CorsHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CorsHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CorsHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.CorsHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CorsHandler that = (CorsHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param allowedOriginPattern the allowed origin pattern
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.CorsHandler create(String allowedOriginPattern) { 
    io.vertx.mutiny.ext.web.handler.CorsHandler ret = io.vertx.mutiny.ext.web.handler.CorsHandler.newInstance((io.vertx.ext.web.handler.CorsHandler)io.vertx.ext.web.handler.CorsHandler.create(allowedOriginPattern));
    return ret;
  }

  /**
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.CorsHandler create() { 
    io.vertx.mutiny.ext.web.handler.CorsHandler ret = io.vertx.mutiny.ext.web.handler.CorsHandler.newInstance((io.vertx.ext.web.handler.CorsHandler)io.vertx.ext.web.handler.CorsHandler.create());
    return ret;
  }

  /**
   * @param origin the well formatted static origin
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler addOrigin(String origin) { 
    delegate.addOrigin(origin);
    return this;
  }

  /**
   * @param origins the well formatted static origin list
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler addOrigins(List<String> origins) { 
    delegate.addOrigins(origins);
    return this;
  }

  /**
   * @param method the method to add
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler allowedMethod(io.vertx.core.http.HttpMethod method) { 
    delegate.allowedMethod(method);
    return this;
  }

  /**
   * @param methods the methods to add
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler allowedMethods(Set<io.vertx.core.http.HttpMethod> methods) { 
    delegate.allowedMethods(methods);
    return this;
  }

  /**
   * @param headerName the allowed header name
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler allowedHeader(String headerName) { 
    delegate.allowedHeader(headerName);
    return this;
  }

  /**
   * @param headerNames the allowed header names
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler allowedHeaders(Set<String> headerNames) { 
    delegate.allowedHeaders(headerNames);
    return this;
  }

  /**
   * @param headerName the exposed header name
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler exposedHeader(String headerName) { 
    delegate.exposedHeader(headerName);
    return this;
  }

  /**
   * @param headerNames the exposed header names
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler exposedHeaders(Set<String> headerNames) { 
    delegate.exposedHeaders(headerNames);
    return this;
  }

  /**
   * @param allow true if allowed
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler allowCredentials(boolean allow) { 
    delegate.allowCredentials(allow);
    return this;
  }

  /**
   * @param maxAgeSeconds max age in seconds
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CorsHandler maxAgeSeconds(int maxAgeSeconds) { 
    delegate.maxAgeSeconds(maxAgeSeconds);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  CorsHandler newInstance(io.vertx.ext.web.handler.CorsHandler arg) {
    return arg != null ? new CorsHandler(arg) : null;
  }

}
