package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * A handler which selectively executes another handler if a precondition is met.
 *
 * There are cases where applications are build as multi tenant, in this cases one of the
 * common tasks is to configure different authentication mechanisms for each tenant.
 *
 * This handler will allow registering any other handler and will only execute it if
 * the precondition is met. There are 2 way of defining a precondition:
 *
 * <ul>
 *     <li>A http header value for example <pre>X-Tenant</pre></li>
 *     <li>A custom extractor function that can return a String from the context</li>
 * </ul>
 *
 * Requests that pass the validation will contain a new key in the routing context with
 * the tenant id, for the case of being a default handler the value if this key will be "default".
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.MultiTenantHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.MultiTenantHandler.class)
public class MultiTenantHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MultiTenantHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MultiTenantHandler((io.vertx.ext.web.handler.MultiTenantHandler) obj),
    MultiTenantHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.MultiTenantHandler delegate;
  
  public MultiTenantHandler(io.vertx.ext.web.handler.MultiTenantHandler delegate) {
    this.delegate = delegate;
  }

  public MultiTenantHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.MultiTenantHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MultiTenantHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.MultiTenantHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiTenantHandler that = (MultiTenantHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param header the header to lookup (e.g.: "X-Tenant")
   * @return the new handler.
   */
  public static io.vertx.mutiny.ext.web.handler.MultiTenantHandler create(String header) { 
    io.vertx.mutiny.ext.web.handler.MultiTenantHandler ret = io.vertx.mutiny.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(header));
    return ret;
  }

  /**
   * @param tenantExtractor the function that extracts the tenant id from the request
   * @return the new handler.
   */
  public static io.vertx.mutiny.ext.web.handler.MultiTenantHandler create(Function<io.vertx.mutiny.ext.web.RoutingContext, String> tenantExtractor) { 
    io.vertx.mutiny.ext.web.handler.MultiTenantHandler ret = io.vertx.mutiny.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(new java.util.function.Function<io.vertx.ext.web.RoutingContext,java.lang.String>() {
      public String apply(io.vertx.ext.web.RoutingContext arg) {
        String ret = tenantExtractor.apply(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    }));
    return ret;
  }

  /**
   * @param tenantExtractor the function that extracts the tenant id from the request
   * @param contextKey the custom key to store the tenant id in the context
   * @return the new handler.
   */
  public static io.vertx.mutiny.ext.web.handler.MultiTenantHandler create(Function<io.vertx.mutiny.ext.web.RoutingContext, String> tenantExtractor, String contextKey) { 
    io.vertx.mutiny.ext.web.handler.MultiTenantHandler ret = io.vertx.mutiny.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(new java.util.function.Function<io.vertx.ext.web.RoutingContext,java.lang.String>() {
      public String apply(io.vertx.ext.web.RoutingContext arg) {
        String ret = tenantExtractor.apply(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    }, contextKey));
    return ret;
  }

  /**
   * @param tenant the tenant id
   * @param handler the handler to register.
   * @return a fluent reference to self.
   */
  @Fluent
  private io.vertx.mutiny.ext.web.handler.MultiTenantHandler __addTenantHandler(String tenant, Handler<io.vertx.mutiny.ext.web.RoutingContext> handler) { 
    delegate.addTenantHandler(tenant, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * @param tenant the tenant id
   * @param handler the handler to register.
   * @return 
   */
  public io.vertx.mutiny.ext.web.handler.MultiTenantHandler addTenantHandler(String tenant, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> handler) {
    return __addTenantHandler(tenant, handler != null ? handler::accept : null);
  }

  /**
   * @param tenant the tenant id
   * @return a fluent reference to self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.MultiTenantHandler removeTenant(String tenant) { 
    delegate.removeTenant(tenant);
    return this;
  }

  /**
   * @param handler the handler to register.
   * @return a fluent reference to self.
   */
  @Fluent
  private io.vertx.mutiny.ext.web.handler.MultiTenantHandler __addDefaultHandler(Handler<io.vertx.mutiny.ext.web.RoutingContext> handler) { 
    delegate.addDefaultHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler to register.
   * @return 
   */
  public io.vertx.mutiny.ext.web.handler.MultiTenantHandler addDefaultHandler(java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> handler) {
    return __addDefaultHandler(handler != null ? handler::accept : null);
  }

  /**
   * The default key used to identify a tenant in the context data.
   */
  public static final String TENANT = io.vertx.ext.web.handler.MultiTenantHandler.TENANT;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  MultiTenantHandler newInstance(io.vertx.ext.web.handler.MultiTenantHandler arg) {
    return arg != null ? new MultiTenantHandler(arg) : null;
  }

}
