package io.vertx.mutiny.ext.web.sstore;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A session store which is only available on a single node.
 * <p>
 * Can be used when sticky sessions are being used.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.LocalSessionStore original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.sstore.LocalSessionStore.class)
public class LocalSessionStore extends io.vertx.mutiny.ext.web.sstore.SessionStore {

  public static final io.smallrye.mutiny.vertx.TypeArg<LocalSessionStore> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new LocalSessionStore((io.vertx.ext.web.sstore.LocalSessionStore) obj),
    LocalSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.LocalSessionStore delegate;
  
  public LocalSessionStore(io.vertx.ext.web.sstore.LocalSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public LocalSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.LocalSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.LocalSessionStore)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  LocalSessionStore() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.web.sstore.LocalSessionStore getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalSessionStore that = (LocalSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vert.x instance
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.LocalSessionStore create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.sstore.LocalSessionStore ret = io.vertx.mutiny.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param sessionMapName name for map used to store sessions
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.LocalSessionStore create(io.vertx.mutiny.core.Vertx vertx, String sessionMapName) { 
    io.vertx.mutiny.ext.web.sstore.LocalSessionStore ret = io.vertx.mutiny.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate(), sessionMapName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param sessionMapName name for map used to store sessions
   * @param reaperInterval how often, in ms, to check for expired sessions
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.LocalSessionStore create(io.vertx.mutiny.core.Vertx vertx, String sessionMapName, long reaperInterval) { 
    io.vertx.mutiny.ext.web.sstore.LocalSessionStore ret = io.vertx.mutiny.ext.web.sstore.LocalSessionStore.newInstance((io.vertx.ext.web.sstore.LocalSessionStore)io.vertx.ext.web.sstore.LocalSessionStore.create(vertx.getDelegate(), sessionMapName, reaperInterval));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_SESSIONID_LENGTH;
  /**
   * Default of how often, in ms, to check for expired sessions
   */
  public static final long DEFAULT_REAPER_INTERVAL = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_REAPER_INTERVAL;
  /**
   * Default name for map used to store sessions
   */
  public static final String DEFAULT_SESSION_MAP_NAME = io.vertx.ext.web.sstore.LocalSessionStore.DEFAULT_SESSION_MAP_NAME;
  public static  LocalSessionStore newInstance(io.vertx.ext.web.sstore.LocalSessionStore arg) {
    return arg != null ? new LocalSessionStore(arg) : null;
  }

}
