package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * A container with the request's headers that are meaningful enough to be parsed
 * Contains:
 * <ul>
 * <li>Accept -> MIME header, parameters and sortable</li>
 * <li>Accept-Charset -> Parameters and sortable</li>
 * <li>Accept-Encoding -> Parameters and sortable</li>
 * <li>Accept-Language -> Parameters and sortable</li>
 * <li>Content-Type -> MIME header and parameters</li>
 * </ul>
 *
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.ParsedHeaderValues original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.ParsedHeaderValues.class)
public class ParsedHeaderValues {

  public static final io.smallrye.mutiny.vertx.TypeArg<ParsedHeaderValues> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ParsedHeaderValues((io.vertx.ext.web.ParsedHeaderValues) obj),
    ParsedHeaderValues::getDelegate
  );

  private final io.vertx.ext.web.ParsedHeaderValues delegate;
  
  public ParsedHeaderValues(io.vertx.ext.web.ParsedHeaderValues delegate) {
    this.delegate = delegate;
  }

  public ParsedHeaderValues(Object delegate) {
    this.delegate = (io.vertx.ext.web.ParsedHeaderValues)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ParsedHeaderValues() {
    this.delegate = null;
  }

  public io.vertx.ext.web.ParsedHeaderValues getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.LanguageHeader> TYPE_ARG_3 = new TypeArg<io.vertx.mutiny.ext.web.LanguageHeader>(o1 -> io.vertx.mutiny.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.MIMEHeader> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.web.MIMEHeader>(o1 -> io.vertx.mutiny.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.ParsedHeaderValue> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.ext.web.ParsedHeaderValue>(o1 -> io.vertx.mutiny.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.web.ParsedHeaderValue> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.ext.web.ParsedHeaderValue>(o1 -> io.vertx.mutiny.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParsedHeaderValues that = (ParsedHeaderValues) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return List of MIME values in the <code>Accept</code> header
   */
  public List<io.vertx.mutiny.ext.web.MIMEHeader> accept() { 
    List<io.vertx.mutiny.ext.web.MIMEHeader> ret = delegate.accept().stream().map(elt -> io.vertx.mutiny.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of charset values in the <code>Accept-Charset</code> header
   */
  public List<io.vertx.mutiny.ext.web.ParsedHeaderValue> acceptCharset() { 
    List<io.vertx.mutiny.ext.web.ParsedHeaderValue> ret = delegate.acceptCharset().stream().map(elt -> io.vertx.mutiny.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of encofing values in the <code>Accept-Encoding</code> header
   */
  public List<io.vertx.mutiny.ext.web.ParsedHeaderValue> acceptEncoding() { 
    List<io.vertx.mutiny.ext.web.ParsedHeaderValue> ret = delegate.acceptEncoding().stream().map(elt -> io.vertx.mutiny.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of languages in the <code>Accept-Language</code> header
   */
  public List<io.vertx.mutiny.ext.web.LanguageHeader> acceptLanguage() { 
    List<io.vertx.mutiny.ext.web.LanguageHeader> ret = delegate.acceptLanguage().stream().map(elt -> io.vertx.mutiny.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return MIME value in the <code>Content-Type</code> header
   */
  public io.vertx.mutiny.ext.web.MIMEHeader contentType() { 
    io.vertx.mutiny.ext.web.MIMEHeader ret = io.vertx.mutiny.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)delegate.contentType());
    return ret;
  }

  public static  ParsedHeaderValues newInstance(io.vertx.ext.web.ParsedHeaderValues arg) {
    return arg != null ? new ParsedHeaderValues(arg) : null;
  }

}
