package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An auth handler that provides HTTP Basic Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.DigestAuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.DigestAuthHandler.class)
public class DigestAuthHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<DigestAuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DigestAuthHandler((io.vertx.ext.web.handler.DigestAuthHandler) obj),
    DigestAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.DigestAuthHandler delegate;
  
  public DigestAuthHandler(io.vertx.ext.web.handler.DigestAuthHandler delegate) {
    this.delegate = delegate;
  }

  public DigestAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.DigestAuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DigestAuthHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.DigestAuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DigestAuthHandler that = (DigestAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx the vertx instance
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.DigestAuthHandler create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth authProvider) { 
    io.vertx.mutiny.ext.web.handler.DigestAuthHandler ret = io.vertx.mutiny.ext.web.handler.DigestAuthHandler.newInstance((io.vertx.ext.web.handler.DigestAuthHandler)io.vertx.ext.web.handler.DigestAuthHandler.create(vertx.getDelegate(), authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param authProvider the auth service to use
   * @param nonceExpireTimeout the nonce expire timeout in milliseconds.
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.DigestAuthHandler create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth authProvider, long nonceExpireTimeout) { 
    io.vertx.mutiny.ext.web.handler.DigestAuthHandler ret = io.vertx.mutiny.ext.web.handler.DigestAuthHandler.newInstance((io.vertx.ext.web.handler.DigestAuthHandler)io.vertx.ext.web.handler.DigestAuthHandler.create(vertx.getDelegate(), authProvider.getDelegate(), nonceExpireTimeout));
    return ret;
  }

  /**
   * The default nonce expire timeout to use in milliseconds.
   */
  public static final long DEFAULT_NONCE_EXPIRE_TIMEOUT = io.vertx.ext.web.handler.DigestAuthHandler.DEFAULT_NONCE_EXPIRE_TIMEOUT;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  DigestAuthHandler newInstance(io.vertx.ext.web.handler.DigestAuthHandler arg) {
    return arg != null ? new DigestAuthHandler(arg) : null;
  }

}
